<?php

/**
 * Register file protection hooks
 *
 * @package WishListMember/Features/File_Protection
 */

namespace WishListMember\Features\File_Protection;

// Register methods.
add_filter(
    'wishlistmember_instance_methods',
    /**
     * Callback for `wishlistmember_instance_methods` filter.
     *
     * Registers file protection methods.
     *
     * @param array $methods The methods array.
     *
     * @return array
     */
    function ($methods) {
        $object         = new File_Protection_Methods();
        $object_methods = get_class_methods($object);
        foreach ($object_methods as $method) {
            $methods[ $method ] = [[$object, $method]];
        }
        return $methods;
    }
);

// Register hooks.
add_action(
    'wishlistmember_register_hooks',
    /**
     * Callback for `wishlistmember_register_hooks` action.
     *
     * Registers file protection hooks.
     *
     * @param WishListMember $wlm WishListMember instance.
     *
     * @return void
     */
    function ($wlm) {
        add_action('add_attachment', [$wlm, 'add_attachment']);
        add_action('clean_attachment_cache', [$wlm, 'edit_attachment']);
        add_action('delete_attachment', [$wlm, 'delete_attachment']);
        add_action('edit_attachment', [$wlm, 'edit_attachment']);
        add_action('wishlistmember_migrate_file_protection', [$wlm, 'run_file_protect_migration']);
    }
);
