<?php

/**
 * Setup file protection view
 *
 * @package WishListMember/Features/File_Protection
 */

add_filter(
    'wishlist_member_submenu',
    /**
     * Callback for `wishlist_member_submenu` filter.
     *
     * Adds Content Protection > Files menu.
     *
     * @param array  $menu The menu array.
     * @param string $key  The menu key.
     *
     * @return array
     */
    function ($menu, $key) {
        if ('content_protection' === $key) {
            // Insert file protection menu after folders.
            $menu_item = [
                [
                    'key'   => 'files',
                    'name'  => 'Files',
                    'title' => 'Files',
                    'icon'  => 'attach_file',
                    'sub'   => [],
                ],
            ];
            $keys      = array_flip(array_column($menu, 'key'));
            $position  = isset($keys['folders']) ? $keys['folders'] : count($menu);
            array_splice($menu, $position + 1, 0, $menu_item);
        }
        return $menu;
    },
    10,
    2
);

add_action(
    'wishlistmember_admin_screen',
    /**
     * Callback for `wishlistmember_admin_screen` action.
     *
     * Adds Content Protection > Files screen.
     *
     * @param string $screen The screen.
     *
     * @return void
     */
    function ($screen) {
        if ('content_protection/files' === $screen) {
            require_once __DIR__ . '/views/files.php';
        }
    }
);

add_filter(
    'wishlistmember_admin_screen_js',
    /**
     * Callback for `wishlistmember_admin_screen_js` filter.
     *
     * Adds Content Protection > Files screen JS.
     *
     * @param string $js_url The JS URL.
     * @param string $screen The screen.
     *
     * @return string
     */
    function ($js_url, $screen) {
        if ('content_protection/files' === $screen) {
            return plugin_dir_url(__FILE__) . 'views/files.js';
        }
        return $js_url;
    },
    10,
    2
);
