<?php

/**
 * Class that handles the IPN notification service.
 *
 * @package WishListMember\Features\Mothership
 */


declare(strict_types=1);

namespace WishListMember\Features\Mothership;

require_once 'mothership-plugin-connector.php';

use WishListMember\GroundLevel\Container\Container;
use WishListMember\GroundLevel\InProductNotifications\Service as IPNService;

/**
 * Handles the IPN notification service.
 */
class IPN_Notification_Handler
{
    /**
     * Loads the hooks for the IPN Notification Service.
     *
     * @param Container $container The container.
     */
    public function load_hooks(Container $container): void
    {
        add_action('init', function () use ($container) {
            self::init($container);
        }, 5);

        // Add a filter to wrap the IPN root element in a <li> element and add a style to it.
        add_filter('wlm_ipn_root_element_html', function ($html, $id) use ($container) {
            return '<li><div id="' . $id . '" style="margin-top: -2px;"></div></li>';
        }, 10, 2);
    }

    /**
     * Initializes the IPN Notification Service.
     *
     * @param Container $container The container.
     */
    public static function init(Container $container): void
    {
        // Set IPN Service parameters.
        $container->addParameter(IPNService::PRODUCT_SLUG, WLM_PRODUCT_SLUG);
        $container->addParameter(IPNService::PREFIX, 'wlm');
        $container->addParameter(IPNService::THEME, [
            'inboxBtnVariant' => 'icon',
            'inboxBtnOpacity' => 0.6,
        ]);
        $container->addParameter(IPNService::RENDER_HOOK, 'wishlistmember_header_icons');
        $container->addService(
            IPNService::class,
            static function () use ($container): IPNService {
                return new IPNService($container);
            },
            true
        );
    }
}
