<?php

/**
 * Mothership Plugin Connector
 *
 * @package WishListMember\Features\Mothership
 */

declare(strict_types=1);

namespace WishListMember\Features\Mothership;

use WishListMember\GroundLevel\Mothership\AbstractPluginConnection;

/**
 * This class is responsible for settings methods and properties used for connecting to the Mothership API.
 */
class Mothership_Plugin_Connector extends AbstractPluginConnection
{
    /**
     * Constructor for the MothershipPluginConnector class.
     */
    public function __construct()
    {
        $this->pluginId     = 'wishlistmember';
        $this->pluginPrefix = 'WLM';
    }

    /**
     * Gets the license activation status option.
     *
     * @return boolean The license activation status.
     */
    public function getLicenseActivationStatus(): bool
    {
        return (bool) wishlistmember_instance()->get_option('LicenseStatus') ?? false;
    }

    /**
     * Updates the license activation status option.
     *
     * @param boolean $status The status to update.
     */
    public function updateLicenseActivationStatus(bool $status): void
    {
        wishlistmember_instance()->update_option('LicenseStatus', $status);
    }

    /**
     * Gets the license key option.
     *
     * @return string The license key.
     */
    public function getLicenseKey(): string
    {
        return (string) wishlistmember_instance()->get_option('LicenseKey') ?? '';
    }

    /**
     * Updates the license key option.
     *
     * @param string $licenseKey The license key to update.
     */
    public function updateLicenseKey(string $licenseKey): void
    {
        wishlistmember_instance()->update_option('LicenseKey', $licenseKey);
    }

    /**
     * Gets the domain option.
     *
     * @return string The domain.
     */
    public function getDomain(): string
    {
        $url = wp_parse_url(strtolower(get_bloginfo('url')));
        return $url['host'] . ($url['path'] ?? '');
    }
}
