<?php

/**
 * Constant Contact admin UI > Lists modal
 *
 * @package WishListMember/Autoresponders
 */

foreach ($all_levels as $levels) :
    foreach ($levels as $level) :
        $level = (object) $level;
    ?>
<div
    data-process="modal"
    id="constantcontact-lists-modal-<?php echo esc_attr($level->id); ?>-template" 
    data-id="constantcontact-lists-modal-<?php echo esc_attr($level->id); ?>"
    data-label="constantcontact-lists-modal-<?php echo esc_attr($level->id); ?>"
    data-title="Editing <?php echo esc_attr($config['name']); ?> Settings for <?php echo esc_attr($level->name); ?>"
    data-classes="modal-lg"
    data-show-default-footer="1"
    style="display:none">
    <div class="body">
        <ul class="nav nav-tabs">
            <li class="active nav-item"><a class="nav-link" data-toggle="tab" href="#constantcontact-ar-when-added-<?php echo esc_attr($level->id); ?>"><?php esc_html_e('Added', 'wishlist-member'); ?></a></li>
            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#constantcontact-ar-when-removed-<?php echo esc_attr($level->id); ?>"><?php esc_html_e('Removed', 'wishlist-member'); ?></a></li>
            <?php if (! isset($level->post_type)) : ?>
                <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#constantcontact-ar-when-cancelled-<?php echo esc_attr($level->id); ?>"><?php esc_html_e('Cancelled', 'wishlist-member'); ?></a></li>
                <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#constantcontact-ar-when-uncancelled-<?php echo esc_attr($level->id); ?>"><?php esc_html_e('Uncancelled', 'wishlist-member'); ?></a></li>
            <?php endif; ?>
        </ul>
        <div class="tab-content">
            <div class="row tab-pane active" id="constantcontact-ar-when-added-<?php echo esc_attr($level->id); ?>">
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Add to List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Adds the User to the selected List(s) when Added to the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][added][add]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Remove from List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Removes the User from the selected List(s) when Added to the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][added][remove]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
            </div>
            <div class="row tab-pane" id="constantcontact-ar-when-removed-<?php echo esc_attr($level->id); ?>">
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Add to List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Adds the User to the selected List(s) when Removed from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][removed][add]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Remove from List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Removes the User from the selected List(s) when Removed from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][removed][remove]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
            </div>
            <div class="row tab-pane" id="constantcontact-ar-when-cancelled-<?php echo esc_attr($level->id); ?>">
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Add to List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Adds the User to the selected List(s) when Cancelled from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][cancelled][add]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Remove from List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Removes the User from the selected List(s) when Cancelled from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][cancelled][remove]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
            </div>
            <div class="row tab-pane" id="constantcontact-ar-when-uncancelled-<?php echo esc_attr($level->id); ?>">
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Add to List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Adds the User to the selected List(s) when Uncancelled from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][uncancelled][add]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
                <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Remove from List', 'wishlist-member')); ?>',
                    tooltip : '<?php echo esc_js(__('Removes the User from the selected List(s) when Uncancelled from the Level.', 'wishlist-member')); ?>',
                    type : 'select',
                    multiple : 'multiple',
                    class : 'constantcontact-lists-select',
                    style : 'width: 100%',
                    name : 'list_actions[<?php echo esc_attr($level->id); ?>][uncancelled][remove]',
                    column : 'col-12',
                    'data-placeholder' : '<?php echo esc_js(__('Select Lists', 'wishlist-member')); ?>',
                }
                </template>
            </div>
        </div>
    </div>
</div>
    <?php endforeach;
endforeach;
?>
