<?php

$data = new \stdClass();

$keap_authorization_url = '';
if (class_exists('\WishListMember\Infusionsoft\WLM_Infusionsoft')) {
    $ifsdk = new \WishListMember\Infusionsoft\WLM_Infusionsoft();
    $keap_authorization_url = $ifsdk->get_oauth_authorize_url();
}

$keap_action = wlm_post_data()['action'];
if ('wlm_payment_disconnect_keap' === $keap_action) {
    $app_name = wlm_post_data()['app'];
    $nonce = wlm_post_data()['wlm_payment_disconnect_keap_' . $app_name];
    if (wp_verify_nonce($nonce, 'wlm_payment_disconnect_keap_' . $app_name)) {
        $payment_app = wishlistmember_instance()->get_option('keap_oauth_app_payment');
        $oauth_token = wishlistmember_instance()->get_option('keap_oauth_token_payment');
        $transient_name = $oauth_token ? $oauth_token->accessToken : '';
        if ($transient_name) {
            delete_transient('wlmis_' . md5($transient_name));
        }
        delete_transient('keap_token_refresh_payment');
        wishlistmember_instance()->delete_option('keap_oauth_app_payment');
        wishlistmember_instance()->delete_option('keap_oauth_token_payment');
        wishlistmember_instance()->delete_option('keap_oauth_code_payment');
    }
}

$data->isapikey = wlm_trim($this->get_option('isapikey'));
$oauth_token = wishlistmember_instance()->get_option('keap_oauth_token_payment');
$payment_app = wishlistmember_instance()->get_option('keap_oauth_app_payment');

$show_deprecation_msg = $data->isapikey ? true : false;
$show_deprecation_msg = $oauth_token ? false : $show_deprecation_msg;


$data->isthankyou = $this->get_option('isthankyou');
if (! $data->isthankyou) {
    $this->save_option('isthankyou', $data->isthankyou = $this->make_reg_url());
}
$data->isthankyou_url = $wpm_scregister . $data->isthankyou;

if (isset(wlm_get_data()['isenable_log'])) {
    $this->save_option('isenable_log', (int) wlm_get_data()['isenable_log']);
}
$data->isenable_log = (bool) $this->get_option('isenable_log');

$tags = ['istags_add_app', 'istags_add_rem', 'istags_remove_app', 'istags_remove_rem', 'istags_cancelled_app', 'istags_cancelled_rem', 'istags_uncancelled_app', 'istags_uncancelled_rem', 'istags_expired_app', 'istags_expired_rem', 'istags_unexpired_app', 'istags_unexpired_rem', 'istagspp_add_app', 'istagspp_add_rem', 'istagspp_remove_app', 'istagspp_remove_rem'];

foreach ($tags as $_tag) {
    $x = $this->get_option($_tag);
    if ($x) {
        $x = wlm_maybe_unserialize($x);
    } else {
        $x = [];
    }
    $data->$_tag = $x;
}

thirdparty_integration_data($config['id'], $data);
