<?php

/**
 * Settings file for Infusionsoft integration.
 *
 * @package WLM
 * @since   3.0.0
 */

?>

    <?php if ($show_deprecation_msg) : ?>
    <div class="row">
        <div class="col">
            <p class="text-danger alert alert-danger">
                <?php esc_html_e('Infusionsoft by Keap is sunsetting their Legacy API keys. You will need to use the button below to reconnect your Infusionsoft by Keap integration. The integration must be reconnected for it to continue to function.', 'wishlist-member'); ?>
            </p>
        </div>
    </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-auto mb-4">
            <?php if ($keap_authorization_url) : ?>
            <a class="btn -primary text-nowrap" href='<?php echo esc_url($keap_authorization_url); ?>'>
                <i class="wlm-icons">developer_board</i>
                <span>
                    <?php
                    switch(true) {
                        case $show_deprecation_msg:
                            esc_html_e('Reconnect Infusionsoft by Keap Integration', 'wishlist-member');
                            break;
                        case $oauth_token:
                            esc_html_e('Reconnect to Infusionsoft by Keap', 'wishlist-member');
                            break;
                        default:
                            esc_html_e('Connect to Infusionsoft by Keap', 'wishlist-member');
                    }
                    ?>
                </span>
            </a>
            <?php endif; ?>
        </div>
        <?php echo wp_kses_post($api_status_markup); ?>
        <?php if ($oauth_token) : ?>
            <?php
                $app_name = explode('.', $payment_app)[0];
            ?>
            <div class="col-2 text-right">
                <form method="post" onsubmit="return confirm (wp.i18n.__('Disconnecting the Infusionsoft by Keap Account will prevent this WishList Member payments integration from working.'))">
                    <?php wp_nonce_field('wlm_payment_disconnect_keap_' . $app_name, 'wlm_payment_disconnect_keap_' . $app_name); ?>
                    <input type="hidden" name="action" value="wlm_payment_disconnect_keap">
                    <input type="hidden" name="app" value="<?php echo esc_attr($app_name); ?>">
                    <button type="submit" class="btn -condensed -danger text-nowrap" href='#'>
                        <i class="wlm-icons">info_outline</i>
                        <span><?php esc_html_e('Disconnect', 'wishlist-member'); ?></span>
                    </button>
                </form>
            </div>
        <?php endif; ?>
    </div>
    <form>
        <div class="row api-required">
            <template class="wlm3-form-group">
                {
                    label : '<?php echo esc_js(__('Order Form Web Page URL', 'wishlist-member')); ?>',
                    name : 'isthankyou',
                    addon_left : '<?php echo esc_js($wpm_scregister); ?>',
                    column : 'col-md-6',
                    class : 'text-center -url',
                    group_class : '-url-group',
                    tooltip : '<?php echo esc_js(__('The end string of the displayed Thank You URL can be edited if desired. Note that this Thank You URL must be copied and pasted exactly without any spaces before or after it.', 'wishlist-member')); ?>',
                }
            </template>
        </div>
        <input type="hidden" name="action" value="admin_actions" />
        <input type="hidden" name="WishListMemberAction" value="save" />
    </form>
