<?php

/**
 * Load Infusionsoft SDK
 */

require_once 'vendor-prefixed/autoload.php';

add_filter(
    'wishlistmember_get_option',
    /**
     * Handler for the `wishlistmember_get_option` filter to ensure that
     * Keap tokens are of the \WishListMember\Infusionsoft\Token class.
     *
     * @param  mixed $value The value of the option.
     * @param  string $option The name of the option.
     * @return mixed
     */
    function ($value, $option) {
        if ('keap_oauth_token_payment' === $option || 'keap_oauth_token_autoresponder' === $option) {
            $value = (array)$value;
            $token = new \WishListMember\Infusionsoft\Token();
            $token->setAccessToken(wlm_arrval($value, 'accessToken'));
            $token->setRefreshToken(wlm_arrval($value, 'refreshToken'));
            $token->setEndOfLife(wlm_arrval($value, 'endOfLife'));
            $token->setExtraInfo((array)wlm_arrval($value, 'extraInfo'));
            return $token;
        }
        return $value;
    },
    10,
    2
);
