<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */ namespace Infusionsoft\Api\Rest;

use WishListMember\Infusionsoft\Api\Rest\Traits\CannotDelete;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotModel;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSync;

class WishListMember_EmailService extends WishListMember_RestModel
{
    use CannotSync, CannotDelete, CannotModel;

    public $full_url = 'https://api.infusionsoft.com/crm/rest/v1/emails';

    public $return_key = 'emails';
    
    public function send($attributes = [])
    {
        $response = $this->client->restfulRequest('post', $this->getFullUrl('/queue'), $attributes);
        return $response;
    }
}
