<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */ namespace Infusionsoft\Api\Rest;

use WishListMember\Infusionsoft\Api\Rest\Traits\CannotCreate;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotDelete;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotFind;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotModel;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSave;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSync;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotWhere;
use WishListMember\Infusionsoft\Infusionsoft;
use WishListMember\Infusionsoft\InfusionsoftException;

class WishListMember_TagService extends WishListMember_RestModel
{
    use CannotSync, CannotDelete, CannotModel;

    public $full_url = 'https://api.infusionsoft.com/crm/rest/v1/tags';

    public $return_key = 'tags';

    public function __construct(Infusionsoft $client)
    {
        parent::__construct($client);
    }

    public function contacts($where = [])
    {
        $data = $this->client->restfulRequest('get', $this->getFullUrl($this->id . '/contacts'), $where);
        $this->fill($data);

        return $this;
    }

    public function removeContacts($contactIds)
    {
        if ( ! is_array($contactIds)) {
            throw new InfusionsoftException('Must be an array of contact ids');
        } elseif (count($contactIds) > 100) {
            throw new InfusionsoftException('A maximum of 100 contact ids can be modified at once');
        }

        $contactIds = ['ids' => implode(",", $contactIds)];

        $response = $this->client->restfulRequest('delete', $this->getFullUrl($this->id . '/contacts'), $contactIds);

        return $response;
    }

    public function addContacts($contactIds)
    {
        if ( ! is_array($contactIds)) {
            throw new InfusionsoftException('Must be an array of contact ids');
        } elseif (count($contactIds) > 100) {
            throw new InfusionsoftException('A maximum of 100 contact ids can be modified at once');
        }

        $contacts      = new \stdClass();
        $contacts->ids = $contactIds;

        $response = $this->client->restfulRequest('post', $this->getFullUrl($this->id . '/contacts'), $contacts);

        return $response;
    }

    public function addCategory($name, $description)
    {

        $body = ['description' => $description, 'name' => $name];

        $response = $this->client->restfulRequest('post', $this->getFullUrl('/categories'), $body);

        return $response;
    }

}
