<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace WishListMember\Infusionsoft\Http;

use WishListMember\fXmlRpc\Client;
use WishListMember\fXmlRpc\Exception\ExceptionInterface as fXmlRpcException;
use WishListMember\fXmlRpc\Parser\BestParserDelegate;
use WishListMember\fXmlRpc\Parser\NativeParser;

class InfusionsoftSerializer implements SerializerInterface {

	/**
	 * @param string          $method
	 * @param string          $uri
	 * @param array           $params
	 * @param ClientInterface $client
	 * @return mixed|void
	 * @throws HttpException
	 */
	public function request($method, $uri, $params, ClientInterface $client)
	{
		// Although we are using fXmlRpc to handle the XML-RPC formatting, we
		// can still use Guzzle as our HTTP client which is much more robust.
		try
		{
			$transport = $client->getXmlRpcTransport();
			$parser = null;

			if(extension_loaded('xmlrpc')) {
			    $parser = new BestParserDelegate();
			}

			$client = new Client($uri, $transport, $parser);

			$response = $client->call($method, $params);

			return $response;
		}
		catch (fXmlRpcException $e)
		{
			throw new HttpException($e->getMessage(), $e->getCode(), $e);
		}
	}

}
