<?php
/**
 * @license BSD-3-Clause
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

declare(strict_types=1);

namespace WishListMember\Laminas\Diactoros\Exception;

use Throwable;
use UnexpectedValueException;

class DeserializationException extends UnexpectedValueException implements ExceptionInterface
{
    public static function forInvalidHeader(): self
    {
        throw new self('Invalid header detected');
    }

    public static function forInvalidHeaderContinuation(): self
    {
        throw new self('Invalid header continuation');
    }

    public static function forRequestFromArray(Throwable $previous): self
    {
        return new self('Cannot deserialize request', $previous->getCode(), $previous);
    }

    public static function forResponseFromArray(Throwable $previous): self
    {
        return new self('Cannot deserialize response', $previous->getCode(), $previous);
    }

    public static function forUnexpectedCarriageReturn(): self
    {
        throw new self('Unexpected carriage return detected');
    }

    public static function forUnexpectedEndOfHeaders(): self
    {
        throw new self('Unexpected end of headers');
    }

    public static function forUnexpectedLineFeed(): self
    {
        throw new self('Unexpected line feed detected');
    }
}
