<?php

namespace WishListMember\PaymentProviders\Stripe\PHPLib\Issuing;

/**
 * You can <a href="https://stripe.com/docs/issuing/cards">create physical or
 * virtual cards</a> that are issued to cardholders.
 *
 * @property string $id Unique identifier for the object.
 * @property string $object String representing the object's type. Objects of the same type share the same value.
 * @property string $brand The brand of the card.
 * @property null|string $cancellation_reason The reason why the card was canceled.
 * @property \WishListMember\PaymentProviders\Stripe\PHPLib\Issuing\Cardholder $cardholder <p>An Issuing <code>Cardholder</code> object represents an individual or business entity who is <a href="https://stripe.com/docs/issuing">issued</a> cards.</p><p>Related guide: <a href="https://stripe.com/docs/issuing/cards#create-cardholder">How to create a Cardholder</a></p>
 * @property int $created Time at which the object was created. Measured in seconds since the Unix epoch.
 * @property string $currency Three-letter <a href="https://www.iso.org/iso-4217-currency-codes.html">ISO currency code</a>, in lowercase. Must be a <a href="https://stripe.com/docs/currencies">supported currency</a>.
 * @property string $cvc The card's CVC. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with <a href="https://stripe.com/docs/api/expanding_objects">the <code>expand</code> parameter</a>. Additionally, it's only available via the <a href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot; endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
 * @property int $exp_month The expiration month of the card.
 * @property int $exp_year The expiration year of the card.
 * @property string $last4 The last 4 digits of the card number.
 * @property bool $livemode Has the value <code>true</code> if the object exists in live mode or the value <code>false</code> if the object exists in test mode.
 * @property \WishListMember\PaymentProviders\Stripe\PHPLib\StripeObject $metadata Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
 * @property string $number The full unredacted card number. For security reasons, this is only available for virtual cards, and will be omitted unless you explicitly request it with <a href="https://stripe.com/docs/api/expanding_objects">the <code>expand</code> parameter</a>. Additionally, it's only available via the <a href="https://stripe.com/docs/api/issuing/cards/retrieve">&quot;Retrieve a card&quot; endpoint</a>, not via &quot;List all cards&quot; or any other endpoint.
 * @property null|string|\WishListMember\PaymentProviders\Stripe\PHPLib\Issuing\Card $replaced_by The latest card that replaces this card, if any.
 * @property null|string|\WishListMember\PaymentProviders\Stripe\PHPLib\Issuing\Card $replacement_for The card this card replaces, if any.
 * @property null|string $replacement_reason The reason why the previous card needed to be replaced.
 * @property null|\WishListMember\PaymentProviders\Stripe\PHPLib\StripeObject $shipping Where and how the card will be shipped.
 * @property \WishListMember\PaymentProviders\Stripe\PHPLib\StripeObject $spending_controls
 * @property string $status Whether authorizations can be approved on this card.
 * @property string $type The type of the card.
 */
class Card extends \WishListMember\PaymentProviders\Stripe\PHPLib\ApiResource
{
    const OBJECT_NAME = 'issuing.card';

    use \WishListMember\PaymentProviders\Stripe\PHPLib\ApiOperations\All;
    use \WishListMember\PaymentProviders\Stripe\PHPLib\ApiOperations\Create;
    use \WishListMember\PaymentProviders\Stripe\PHPLib\ApiOperations\Retrieve;
    use \WishListMember\PaymentProviders\Stripe\PHPLib\ApiOperations\Update;

    /**
     * @param null|array        $params
     * @param null|array|string $opts
     *
     * @throws \WishListMember\PaymentProviders\Stripe\PHPLib\Exception\ApiErrorException if the request fails
     *
     * @return \WishListMember\PaymentProviders\Stripe\PHPLib\Issuing\CardDetails the card details associated with that issuing card
     */
    public function details($params = null, $opts = null)
    {
        $url                   = $this->instanceUrl() . '/details';
        list($response, $opts) = $this->_request('get', $url, $params, $opts);
        $obj                   = \WishListMember\PaymentProviders\Stripe\PHPLib\Util\Util::convertToStripeObject($response, $opts);
        $obj->setLastResponse($response);

        return $obj;
    }
}
