<?php /** @noinspection PhpUndefinedConstantInspection */

class CronjobClient {
	
	public function __construct() {
	}
	
	public function add_custom_intervals( $schedules ) {
		$schedules['every_five_minutes'] = array(
			'interval' => 300,
			'display'  => __( 'Every 5 Minutes' ),
		);
		$schedules['every_fifteen_minutes'] = array(
			'interval' => 900,
			'display'  => __( 'Every 15 Minutes' ),
		);
		// twicedaily = default WP scheme
		return $schedules;
	}
	
	public function add_cron_job($name, $interval, $start_time = null, $callback) {
		if(is_null($start_time)){
			$start_time = time();
		} else {
			$start_time = strtotime($start_time);
		}
		if ( ! wp_next_scheduled( $name ) ) {
			wp_schedule_event( $start_time, $interval, $name );
		} else {
			wp_clear_scheduled_hook( $name );
		}
		add_action( $name, $callback );
	}
}

$custom_cron_jobs = new CronjobClient();

add_filter( 'cron_schedules', array( $custom_cron_jobs, 'add_custom_intervals' ) );
$custom_cron_jobs->add_cron_job( 'wpo_clean_up_revisions_cron', 'twicedaily',null, 'wpo_clean_up_revisions' );
$custom_cron_jobs->add_cron_job( 'wpo_delete_spam_comments_cron', 'twicedaily',null, 'wpo_delete_spam_comments' );
$custom_cron_jobs->add_cron_job( 'wpo_wc_db_updater_cron', 'twicedaily',null, 'wpo_wc_db_updater' );
$custom_cron_jobs->add_cron_job( 'wpo_cleanup_own_cron', 'every_fifteen_minutes',null, 'wpo_cleanup_own' );