<?php

add_action('customize_register', 'senhblog_footer_customize_register');
function senhblog_footer_customize_register($wp_customize){
    
    $wp_customize->add_section('senhblog_footer', array(
        'title'    => customize_options_language('10. Footer', '10. Voet'),
        'description' => '',
        'priority' => 129,
    ));

	$wp_customize->add_setting('footer_prefooter_padding', array(
        'default'        => '15',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_prefooter_padding', array(
        'label'      => customize_options_language('Pre-footer padding', 'Pre-footer afstand') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_prefooter_padding',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting(
		'footer_prefooter_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_prefooter_backgroundcolor',
			array(
				'label'      => customize_options_language('Pre-footer background color', 'Pre-footer achtergrondkleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_prefooter_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('footer_widgets_enabled', array(
        'default'        => true,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_widgets_enabled', array(
        'label'      => customize_options_language('Footer widgets enabled', 'Footer widgets geactiveerd'),
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_widgets_enabled',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('footer_widgets_distribution', array(
        'default'        => '4-4-4',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_widgets_distribution', array(
        'label'      => customize_options_language('Footer widgets distribution', 'Footer widgets verdeling') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_widgets_distribution',
		'type'		=> 'select',
		'choices'	=> array(
			'12' => '100%', 
			'6-6' => '50%-50%', 
			'8-4' => '66%-33%',
			'4-8' => '33%-66%',
			'6-3-3' => '50%-25%-25%',
			'3-6-3' => '25%-50%-25%',
			'3-3-6' => '25%-25%-50%',
			'5-5-2'	=> '40%-40%-20%',
			'5-2-5' => '40%-20%-40%',
			'2-5-5' => '20%-40%-40%',
			'2-8-2' => '12.5%-75%-12.5%',
			'4-4-4' => '33%-33%-33%',
			'3-3-3-3' => '25%-25%-25%-25%'
		)
    ));

	$wp_customize->add_setting(
		'footer_widgets_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_widgets_backgroundcolor',
			array(
				'label'      => customize_options_language('Footer widgets background color', 'Footer widgets achtergrondkleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_widgets_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'footer_widgets_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_widgets_fontcolor',
			array(
				'label'      => customize_options_language('Footer widgets font color', 'Footer widgets lettertype kleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_widgets_fontcolor'
			)
		)
	);

	$wp_customize->add_setting('footer_widgets_headers_fontsize', array(
        'default'        => 18,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_widgets_headers_fontsize', array(
        'label'      => customize_options_language('Footer widgets headers font size', 'Footer widgets koppen lettertype grootte') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_widgets_headers_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('footer_widgets_headers_fontweight', array(
        'default'        => 'bold',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('footer_widgets_headers_fontweight', array(
        'label'      => customize_options_language('Footer widgets headers font weight', 'Footer widgets koppen lettertype dikte') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_widgets_headers_fontweight',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting(
		'footer_widgets_bulletpointscolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_widgets_bulletpointscolor',
			array(
				'label'      => customize_options_language('Footer widgets bulletpoints color', 'Footer widgets bulletpoints kleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_widgets_bulletpointscolor'
			)
		)
	);

	$wp_customize->add_setting('footer_menu_enabled', array(
        'default'        => true,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_menu_enabled', array(
        'label'      => customize_options_language('Footer menu enabled', 'Footer menu geactiveerd'),
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_menu_enabled',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('footer_menu_alignment', array(
        'default'        => 'center',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_menu_alignment', array(
        'label'      => customize_options_language('Footer menu alignment', 'Footer menu positie') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_menu_alignment',
		'type'		=> 'select',
		'choices'	=> array('left' => customize_options_language('Left', 'Links'), 'center' => customize_options_language('Center', 'Gecentreerd'), 'right' => customize_options_language('Right', 'Rechts'))
    ));

	$wp_customize->add_setting(
		'footer_menu_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_menu_backgroundcolor',
			array(
				'label'      => customize_options_language('Footer menu background color', 'Footer menu achtergrondkleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_menu_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('footer_menu_seperator', array(
        'default'        => '|',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_menu_seperator', array(
        'label'      => customize_options_language('Footer menu seperator', 'Footer menu scheidingsteken') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_menu_seperator'
    ));

	$wp_customize->add_setting(
		'footer_menu_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_menu_fontcolor',
			array(
				'label'      => customize_options_language('Footer menu font color', 'Footer menu lettertype kleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_menu_fontcolor'
			)
		)
	);

	$wp_customize->add_setting('footer_menu_fontsize', array(
        'default'        => 13,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_menu_fontsize', array(
        'label'      => customize_options_language('Footer menu font size', 'Footer menu lettertype grootte') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_menu_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('footer_menu_links_underlined', array(
        'default'        => false,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_menu_links_underlined', array(
        'label'      => customize_options_language('Footer menu links underlined', 'Footer menu links onderstreept'),
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_menu_links_underlined',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('footer_copyright_enabled', array(
        'default'        => true,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_enabled', array(
        'label'      => customize_options_language('Copyright text enabled', 'Copyright tekst geactiveerd'),
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_enabled',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('footer_copyright_alignment', array(
        'default'        => 'center',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_alignment', array(
        'label'      => customize_options_language('Footer copyright alignment', 'Footer copyright positie') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_alignment',
		'type'		=> 'select',
		'choices'	=> array('left' => customize_options_language('Left', 'Links'), 'center' => customize_options_language('Center', 'Gecentreerd'), 'right' => customize_options_language('Right', 'Rechts'))
    ));

	$wp_customize->add_setting(
		'footer_copyright_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'footer_copyright_backgroundcolor',
			array(
				'label'      => customize_options_language('Footer copyright background color', 'Footer copyright achtergrondkleur') . ':',
				'section'    => 'senhblog_footer',
				'settings'   => 'footer_copyright_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('footer_copyright_text', array(
        'default'        => '',
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_text', array(
        'label'      => customize_options_language('Copyright text', 'Copyright tekst') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_text',
		'type'		=> 'textarea'
    ));

	$wp_customize->add_setting('footer_copyright_padding_top', array(
        'default'        => 15,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_padding_top', array(
        'label'      => customize_options_language('Copyright padding top', 'Copyright afstand boven') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_padding_top',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('footer_copyright_padding_bottom', array(
        'default'        => 15,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_padding_bottom', array(
        'label'      => customize_options_language('Copyright padding bottom', 'Copyright afstand beneden') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_padding_bottom',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('footer_copyright_padding_left', array(
        'default'        => 15,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_padding_left', array(
        'label'      => customize_options_language('Copyright padding left', 'Copyright afstand links') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_padding_left',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('footer_copyright_padding_right', array(
        'default'        => 15,
        'transport'     => 'refresh', 
    )); 
    $wp_customize->add_control('footer_copyright_padding_right', array(
        'label'      => customize_options_language('Copyright padding right', 'Copyright afstand rechts') . ':',
        'section'    => 'senhblog_footer',
        'settings'   => 'footer_copyright_padding_right',
		'type'		=> 'number'
    ));

}