<?php

add_action('customize_save', function($wpc) {
	$settings_changed = json_decode(stripslashes($_POST['customized']), true);
	if (isset($settings_changed['content_show_gravatar'])) {
		if ($settings_changed['content_show_gravatar']) {
			update_option('show_avatars', '1');
		} else {
			update_option('show_avatars', '0');
		}
	}
});

add_action('init', function() {
	if (isset($_GET['reset_customized_settings'])) {
		remove_theme_mods();
		echo '<script>top.location="/wp-admin/customize.php";</script>';
		die();
	} else if (isset($_GET['download_customized_settings'])) {
		$theme_mods = get_theme_mods();

		unset($theme_mods[0]);

		// dont export html head/body
		unset($theme_mods['general_head_html'], $theme_mods['general_footer_html']);

		//function defination to convert array to xml
		function array_to_xml($array, &$xml_user_info) {
			foreach($array as $key => $value) {
				if(is_array($value)) {
					if(!is_numeric($key)){
						$subnode = $xml_user_info->addChild("$key");
						array_to_xml($value, $subnode);
					}else{
						$subnode = $xml_user_info->addChild("item$key");
						array_to_xml($value, $subnode);
					}
				}else {
					$xml_user_info->addChild("$key",htmlspecialchars("$value"));
				}
			}
		}

		$xml_user_info = new SimpleXMLElement("<?xml version=\"1.0\"?><theme_mods></theme_mods>");

		//function call to convert array to xml
		array_to_xml($theme_mods, $xml_user_info);

		header('Content-type: text/xml');
		header('Content-Disposition: attachment; filename="' . $_SERVER['SERVER_NAME'] . '_' . date('Y-m-d') . '.xml"');
		print $xml_user_info->asXML();
		
		die();
	} else if (isset($_FILES['customizedoptions']) || isset($_POST['customizedoptions-dragdrop'])) {
		if ($file = $_FILES['customizedoptions']['tmp_name']) {
			if (file_exists($file)) {
				$xml = simplexml_load_file($file);	 
			}
		}
		if ($_POST['customizedoptions-dragdrop']) {
			$tmp = tempnam('/tmp', 'cusdrodp');
			file_put_contents($tmp, base64_decode(end(explode(',', $_POST['customizedoptions-dragdrop']))));
			$xml = simplexml_load_file($tmp);
		}

		if ($xml) {
			$skip_mods = array('general_head_html', 'general_footer_html');
			$xml = json_decode(json_encode($xml), true);
			foreach ($xml as $name => $v) {
				if (in_array($name, $skip_mods)) continue;
				set_theme_mod($name, $v ?: '');
			}
			return;
		}

		echo 'Failed to open XML-file<script>top.location="/wp-admin/customize.php";</script>';
		die();
	}
});

add_action('customize_register', 'senhblog_load_customize_classes');
function senhblog_load_customize_classes() {
	require_once(get_stylesheet_directory() . '/lib/customizer/wp_slider_control.php');
}

function senhblog_get_themefonts_array() {
	$themefonts = array('Arial' => 'Arial', 'OpenSans' => 'Open Sans', 'Roboto' => 'Roboto', 'Verdana' => 'Verdana', 'Helvetica' => 'Helvetica', 'HelveticaNeue' => 'Helvetica Neue', 'Lato' => 'Lato', 'SansSerif' => 'sans-serif', 'CarroisGothic' => 'Carrois Gothic');
	return $themefonts;
}


add_action('customize_register', 'senhblog_promotionwidget_customize_register');
function senhblog_promotionwidget_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_promotionwidget', array(
        'title'    => 'Promotion Widget',
        'description' => '',
        'priority' => 120,
    ));
 
    $wp_customize->add_setting('promotionwidget_afternumposts', array(
        'default'        => ''
    ));

	$options = array();
	$default_posts_per_page = get_option('posts_per_page');
	$num_options = $default_posts_per_page;
	for ($i = 0; $i < $num_options; $i++) $options[$i] = $i;
 
    $wp_customize->add_control('control7', array(
        'label'      => 'When enabled, after how many posts should the promotion widget be shown:',
        'section'    => 'senhblog_promotionwidget',
        'settings'   => 'promotionwidget_afternumposts',
		'type'	=> 'select',
		'choices'  => $options
    ));

}


add_action('customize_register', 'senhblog_general_customize_register');
function senhblog_general_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_general', array(
        'title'    => customize_options_language('1. General + filters', '1. Algemeen + filters'),
        'description' => '',
        'priority' => 120,
    ));
 
    $wp_customize->add_setting('general_options_language', array(
        'default'        => 'en'
    )); 
    $wp_customize->add_control('general_options_lang', array(
        'label'      => customize_options_language('Choose English or Dutch (language for options)', 'Kies engels of nederlands (taal voor de opties)') . ':',
        'section'    => 'senhblog_general',
        'settings'   => 'general_options_language',
		'type'	=> 'select',
		'choices'  => array('en' => customize_options_language('English', 'Engels'), 'nl' => customize_options_language('Dutch', 'Nederlands'))
    ));

	$wp_customize->add_setting('general_non_option', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_non_option', array(
        'label'      => customize_options_language('Choose wich option you want to be visible', 'Kies welke opties je wilt laten zien') . ':',
        'section'    => 'senhblog_general',
        'settings'   => 'general_non_option'
    ));

	$wp_customize->add_setting('general_select_deselect_all', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_select_deselect_all', array(
        'label'      => customize_options_language('Select/deselect all', 'Selecteer/deselecteer alles'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_select_deselect_all',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('general_show_color_options', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_show_color_options', array(
        'label'      => customize_options_language('Color options', 'Kleur opties'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_show_color_options',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('general_show_font_options', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_show_font_options', array(
        'label'      => customize_options_language('Font options', 'Lettertype opties'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_show_font_options',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('general_show_layout_options', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_show_layout_options', array(
        'label'      => customize_options_language('Layout options', 'Layout opties'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_show_layout_options',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('general_show_text_options', array(
        'default'        => true
    )); 
    $wp_customize->add_control('general_show_text_options', array(
        'label'      => customize_options_language('Text options', 'Tekst opties'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_show_text_options',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('general_hide_other_customize_tabs', array(
        'default'        => false
    )); 
    $wp_customize->add_control('general_hide_other_customize_tabs', array(
        'label'      => customize_options_language('Hide other tabs in the customizer', 'Verberg alle andere tabs in de customizer'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_hide_other_customize_tabs',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting(
		'general_favicon_image',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'general_favicon_image',
			array(
				'label'      => customize_options_language('Favicon image', 'Favicon afbeelding') . ':',
				'section'    => 'senhblog_general',
				'settings'   => 'general_favicon_image'
			)
		)
	);

	$wp_customize->add_setting('general_favicon_image_url', array(
        'default'        => '',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('general_favicon_image_url', array(
        'label'      => customize_options_language('Favicon URL (alternative)', 'Favicon afbeelding URL (alternatief)') . ':',
        'section'    => 'senhblog_general',
        'settings'   => 'general_favicon_image_url'
    ));

	$wp_customize->add_setting('general_head_html', array(
        'default'        => ''
    )); 
    $wp_customize->add_control('general_head_html', array(
        'label'      => customize_options_language('Add HTML to HEAD:', 'Voeg HTML toe aan HEAD:'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_head_html',
		'type'		=> 'textarea'
    ));

	$wp_customize->add_setting('general_footer_html', array(
        'default'        => ''
    )); 
    $wp_customize->add_control('general_footer_html', array(
        'label'      => customize_options_language('Add HTML to BODY:', 'Voeg HTML toe aan BODY:'),
        'section'    => 'senhblog_general',
        'settings'   => 'general_footer_html',
		'type'		=> 'textarea'
    ));

}


add_action('customize_register', 'senhblog_layout_customize_register');
function senhblog_layout_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_layout', array(
        'title'    => customize_options_language('2. Layout', '2. Layout'),
        'description' => '',
        'priority' => 121,
    ));
 
    $wp_customize->add_setting('layout_container_width', array(
        'default'        => '1150',
		'transport'	=> 'postMessage'
    )); 
    $wp_customize->add_control(new WP_Slider_Control($wp_customize, 'layout_container_width', array(
        'label'      => customize_options_language('Maximum page width:', 'Maximale pagina breedte:'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_container_width',
		'slider_min' => 0,
		'slider_max' => 3000,
		'default' => 1150
    )));

	$wp_customize->add_setting('layout_fullwidth_header_footer', array(
        'default'        => true
    )); 
    $wp_customize->add_control('layout_fullwidth_header_footer', array(
        'label'      => customize_options_language('Full width header and footer', 'Volledige breedte header en footer'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_fullwidth_header_footer',
		'type' => 'checkbox'
    ));

	$themecolors = array('' => customize_options_language('Default', 'Standaard'));
	$themecolors_path = get_stylesheet_directory() . '/themecolors';
	foreach (glob($themecolors_path . '/*.css') as $file) {
		$name = basename($file);
		$langs = explode('.', $name);
		$themecolors[$name] = customize_options_language($langs[0], $langs[1]);
	}

	$wp_customize->add_setting('layout_themecolor', array(
        'default'        => ''
    )); 
    $wp_customize->add_control('general_options_language', array(
        'label'      => customize_options_language('Choose theme color:', 'Kies themakleur:'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_themecolor',
		'type'	=> 'select',
		'choices'  => $themecolors
    ));

	$themefonts = array();
	$themefonts_path = get_stylesheet_directory() . '/themefonts';
	foreach (glob($themefonts_path . '/*.css') as $file) {
		$name = basename($file);
		$themefonts[$name] = current(explode('.', $name));
	}

	$wp_customize->add_setting('layout_themefont', array(
        'default'        => 'Verdana.css'
    )); 
    $wp_customize->add_control('general_options_language', array(
        'label'      => customize_options_language('Choose font:', 'Kies lettertype:'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_themefont',
		'type'	=> 'select',
		'choices'  => $themefonts
    ));

	/*$wp_customize->add_setting('layout_sidebar_enabled', array(
        'default'        => true
    )); 
    $wp_customize->add_control('layout_sidebar_enabled', array(
        'label'      => customize_options_language('Show sidebar', 'Sidebar weergeven'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_sidebar_enabled',
		'type' => 'checkbox'
    ));*/

	$wp_customize->add_setting('layout_sidebar_visibility', array(
        'default'        => 'show_sidebar'
    )); 
    $wp_customize->add_control('layout_sidebar_visibility', array(
        'label'      => customize_options_language('Show sidebar', 'Sidebar weergeven') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_sidebar_visibility',
		'type' => 'select',
		'choices' => array('show_sidebar' => customize_options_language('Show sidebar', 'Sidebar weergeven'), 'hide_sidebar_on_archive' => customize_options_language('Hide sidebar on archive pages', 'Sidebar verbergen op overzicht pagina`s'), 'hide_sidebar' => customize_options_language('Hide sidebar', 'Sidebar verbergen'))
    ));

	$wp_customize->add_setting('layout_sidebar_position', array(
        'default'        => 'right'
    )); 
    $wp_customize->add_control('layout_sidebar_position', array(
        'label'      => customize_options_language('Sidebar position:', 'Sidebar positie:'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_sidebar_position',
		'type'	=> 'select',
		'choices'  => array('left' => customize_options_language('Left', 'Links'), 'right' => customize_options_language('Right', 'Rechts'))
    ));

	$wp_customize->add_setting('layout_sidebar_width', array(
        'default'        => '300',
		'transport'	=> 'postMessage'
    )); 
    $wp_customize->add_control(new WP_Slider_Control($wp_customize, 'layout_sidebar_width', array(
        'label'      => customize_options_language('Sidebar width:', 'Sidebar breedte:'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_sidebar_width',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 300
    )));

	$wp_customize->add_setting(
		'layout_background_content',
		array(
			'default' => '#ffffff',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_background_content',
			array(
				'label'      => customize_options_language('Background content + sidebar', 'Achtergrond content + zijbar') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_background_content'
			)
		)
	);

	$wp_customize->add_setting(
		'layout_background_content_sides',
		array(
			'default' => '#ffffff',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_background_content_sides',
			array(
				'label'      => customize_options_language('Background content (sides)', 'Achtergrond content (zijden)') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_background_content_sides'
			)
		)
	);

	$wp_customize->add_setting('layout_boxed_style', array(
        'default'        => 'none'
    )); 
    $wp_customize->add_control('layout_boxed_style', array(
        'label'      => customize_options_language('Site border style', 'Site omlijning stijl') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_boxed_style',
		'type' => 'select',
		'choices' => array('none' => customize_options_language('None', 'Geen'), 'border' => customize_options_language('Border', 'Omlijning'), 'shadow' => customize_options_language('Shadow', 'Schaduw'), 'glow' => customize_options_language('Glow', 'Gloed'))
    ));

	$wp_customize->add_setting('layout_boxed_border_width', array(
        'default'        => '0'
    )); 
    $wp_customize->add_control('layout_boxed_border_width', array(
        'label'      => customize_options_language('Site border width', 'Site omlijning dikte') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_boxed_border_width',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'layout_boxed_border_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_boxed_border_color',
			array(
				'label'      => customize_options_language('Site border color', 'Site omlijning kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_boxed_border_color'
			)
		)
	);

	$wp_customize->add_setting(
		'layout_boxed_shadow_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_boxed_shadow_color',
			array(
				'label'      => customize_options_language('Site shadow color', 'Site schaduw kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_boxed_shadow_color'
			)
		)
	);

	$wp_customize->add_setting('layout_boxed_glow_thickness', array(
        'default'        => '5'
    )); 
    $wp_customize->add_control('layout_boxed_glow_thickness', array(
        'label'      => customize_options_language('Site glow thickness', 'Site gloed dikte') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_boxed_glow_thickness',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'layout_boxed_glow_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_boxed_glow_color',
			array(
				'label'      => customize_options_language('Site glow color', 'Site gloed kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_boxed_glow_color'
			)
		)
	);

	$wp_customize->add_setting('layout_enable_all_border', array(
        'default'        => false
    )); 
    $wp_customize->add_control('layout_enable_all_border', array(
        'label'      => customize_options_language('Enable border for all elements', 'Activeer omlijning voor alle elementen'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_enable_all_border',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('layout_all_border_width', array(
        'default'        => '1',
		'transport'	=> 'postMessage'
    )); 
    $wp_customize->add_control(new WP_Slider_Control($wp_customize, 'layout_all_border_width', array(
        'label'      => customize_options_language('All elements border width', 'Alle elementen omlijning dikte') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_all_border_width',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 1
    )));

	$wp_customize->add_setting(
		'layout_all_border_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_all_border_color',
			array(
				'label'      => customize_options_language('All elements border color', 'Alle elementen omlijning kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_all_border_color'
			)
		)
	);

	$wp_customize->add_setting(
		'layout_all_shadow',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_all_shadow',
			array(
				'label'      => customize_options_language('All elements shadow color', 'Alle elementen schaduw kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_all_shadow'
			)
		)
	);

	$wp_customize->add_setting('layout_mainmenu_enabled', array(
        'default'        => true
    )); 
    $wp_customize->add_control('layout_mainmenu_enabled', array(
        'label'      => customize_options_language('Enable mainmenu', 'Activeer hoofdmenu'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_mainmenu_enabled',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('layout_submenu_enabled', array(
        'default'        => false
    )); 
    $wp_customize->add_control('layout_submenu_enabled', array(
        'label'      => customize_options_language('Enable submenu', 'Activeer submenu'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_submenu_enabled',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('layout_extramenu_enabled', array(
        'default'        => false
    )); 
    $wp_customize->add_control('layout_extramenu_enabled', array(
        'label'      => customize_options_language('Enable extra mainmenu', 'Activeer extra hoofdmenu'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_extramenu_enabled',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('layout_enable_contentborder', array(
        'default'        => false
    )); 
    $wp_customize->add_control('layout_enable_contentborder', array(
        'label'      => customize_options_language('Enable content border', 'Activeer content omlijning'),
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_enable_contentborder',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('layout_contentborder_width', array(
        'default'        => '3',
		'transport'	=> 'postMessage'
    )); 
    $wp_customize->add_control('layout_contentborder_width', array(
        'label'      => customize_options_language('Content border width', 'Content omlijning dikte') . ':',
        'section'    => 'senhblog_layout',
        'settings'   => 'layout_contentborder_width',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting(
		'layout_contentborder_color',
		array(
			'default' => '',
			'transport'	=> 'postMessage'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'layout_contentborder_color',
			array(
				'label'      => customize_options_language('Content border color', 'Content omlijning kleur') . ':',
				'section'    => 'senhblog_layout',
				'settings'   => 'layout_contentborder_color'
			)
		)
	);

	$wp_customize->add_setting('content_show_gravatar', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('content_show_gravatar', array(
        'label'      => customize_options_language('Show author gravatar', 'Weergeef auteur avatar'),
        'section'    => 'senhblog_layout',
        'settings'   => 'content_show_gravatar',
		'type'		=> 'checkbox'
    ));

}



require_once('customize-header.php');
require_once('customize-mainmenu.php');
require_once('customize-submenu.php');
require_once('customize-search.php');
require_once('customize-blog.php');
require_once('customize-content.php');
require_once('customize-sidebar.php');
require_once('customize-comments.php');
require_once('customize-footer.php');


add_action('customize_register', 'senhblog_importexport_customize_register');
function senhblog_importexport_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_importexport', array(
        'title'    => customize_options_language('Import/export', 'Import/export'),
        'description' => '',
        'priority' => 130,
    ));
 
	$wp_customize->add_setting('importexport_non_option', array(
        'default'        => false
    )); 
    $wp_customize->add_control('importexport_non_option', array(
        'label'      => customize_options_language('Download a XML-file with all customized settings', 'Download een XML-bestand met alle aangepaste instellingen') . ':',
        'section'    => 'senhblog_importexport',
        'settings'   => 'importexport_non_option'
    ));

	$wp_customize->add_setting('importexport_non_option2', array(
        'default'        => false
    )); 
    $wp_customize->add_control('importexport_non_option2', array(
        'label'      => customize_options_language('Upload a XML-file with customized settings', 'Upload een XML-bestand met aangepaste instellingen') . ':',
        'section'    => 'senhblog_importexport',
        'settings'   => 'importexport_non_option2'
    ));

}



function customize_options_language($en, $nl) {
	if (get_theme_mod('general_options_language') == 'nl') return $nl;
	return $en;
}


add_action('customize_preview_init', 'senhblog_customizer_live_preview');
function senhblog_customizer_live_preview() {
	wp_enqueue_script( 
		  'senhblog-themecustomizer',			//Give the script an ID
		  get_template_directory_uri().'/theme-customizer.js',//Point to file
		  array( 'jquery','customize-preview' ),	//Define dependencies
		  '',						//Define a version (optional) 
		  true						//Put script in footer?
	);
}

require_once('customize-custom-css.php');

add_action('admin_enqueue_scripts', function() {
	wp_enqueue_style('admin_customize_css', get_template_directory_uri() . '/customize.css', false, '1.0.0');
	wp_enqueue_script('admin_customize_js', get_template_directory_uri() . '/customize.js', true, '1.0.4');
});

add_action('wp_enqueue_scripts', function() {
	if (get_theme_mod('layout_themecolor')) {
		$themecolors_path = get_template_directory_uri() . '/themecolors';
		wp_enqueue_style('themcolor',
							$themecolors_path . '/' . get_theme_mod('layout_themecolor'),
							false,
							'',
							false);
	}

	$themefonts_path = get_template_directory_uri() . '/themefonts';
	wp_enqueue_style('themcolor',
						$themefonts_path . '/' . get_theme_mod('layout_themefont', 'Verdana.css'),
						false,
						'',
						false);

	if (get_theme_mod('content_headings_fontfamily')) {
		wp_enqueue_style('headingsthemefont',
						$themefonts_path . '/' . get_theme_mod('content_headings_fontfamily'),
						false,
						'',
						false);
	}
});


