<?php
/**
 * Listify child theme.
 */
 
function listify_child_styles() {
    wp_enqueue_style( 'listify-child', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'listify_child_styles', 999 );


/**
 * Register meta box(es).
 */
function wpdocs_register_meta_boxes() {
	add_meta_box( 'job_listing-prices', __( 'Prices', 'job_listing' ), 'job_listing_callback', 'job_listing' );
}
add_action( 'add_meta_boxes', 'wpdocs_register_meta_boxes' );

/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function job_listing_callback( $post ) {
	

	wp_nonce_field('job_listing_meta_box_nonce', 'job_listing_meta_box_nonce');
	
	?>
	   
	   <p class="myplugin_option_box">
			<label for="price" class="myplugin-desc"><?php _e('Pprice', 'job_listing'); ?></label>
			<input id="price" type="text" name="price" class="myplugin-option-input" value="<?php echo get_post_meta($post->ID, 'price', true); ?>"/>
			<!--<span>Ex: http://linkedin.com/myplugintheme</span>-->
		</p>
   
   <?php
}

/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function job_listing_meta_box( $post_id ) {
	
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;
	
    if (!isset($_POST['job_listing_meta_box_nonce']) || !wp_verify_nonce($_POST['job_listing_meta_box_nonce'], 'job_listing_meta_box_nonce'))
        return;
	

    if (isset($_POST['price'])){
        update_post_meta($post_id, 'price', $_POST['price']);
	}    
}

add_action( 'save_post', 'job_listing_meta_box' );


function custom_listify_content_job_listing_after() {
	
	
	
    ?>
		<# if ( data.id ) { #>
		
			<h3 class="job_listing-price"><?php echo '€3.99 per min | De eerste 3 minuten voor €1 EURO';//print_r($id);//echo get_post_meta({{data.id}},'price'); ?></h3>
			
		<# } #>
		
	<?php
}
add_action( 'listify_content_job_listing_after', 'custom_listify_content_job_listing_after', 999 );

/** Place any new code below this line */
if ( ! class_exists('Elementor_Add_Page_Body_CSS_Class'))
{
  class Elementor_Add_Page_Body_CSS_Class
  {
    public $page_setting_key;
    public $page_setting_label;
    public $page_setting_placeholder;
    public $textdomain;
    
    // Class constructor
    public function __construct()
    {
      $this->page_setting_key         = 'additional_body_classes';
      $this->page_setting_label       = 'Additional page body classes';
      $this->page_setting_description = 'Add your classes WITHOUT the dot. e.g.: my-class';
      $this->page_setting_placeholder = 'body-class-1 body-class-2';
      $this->textdomain               = 'yourplugin';
    }
    
    // Initialize our hooks/filters
    public function init()
    {
      add_action('elementor/documents/register_controls', [ $this, 'add_body_class_control' ]);
      add_filter('body_class', [ $this, 'maybe_add_additional_body_classes' ]);
    }
    
    // Maybe add a custom body class value based on the page controls
    public function maybe_add_additional_body_classes($classes)
    {
      $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
      $page_settings_model = $page_settings_manager->get_model( get_the_ID() );
      
      $value = $page_settings_model->get_settings( $this->page_setting_key );
      if ( ! empty( sanitize_text_field( $value ) ) )
      {
        $classes[] = sanitize_text_field( $value );
      }
      
      return $classes;
    }
    
    // Register the body class control in the Page Settings control stack
    function add_body_class_control( \Elementor\Controls_Stack $controls_stack )
    {
      if ( ! \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
        return;
      }

      $controls_stack->start_injection( [
        'of' => 'post_status',
        'fallback' => [
          'of' => 'post_title',
        ],
      ] );

      $controls_stack->add_control(
        $this->page_setting_key,
        [
          'type'        => \Elementor\Controls_Manager::TEXT,
          'label'       => esc_html__( $this->page_setting_label, $this->textdomain ),
          'label_block' => true,
          'placeholder' => esc_html__( $this->page_setting_placeholder, $this->textdomain ),
          'description' => esc_html__( $this->page_setting_description, $this->textdomain ),
          'separator'   => 'before',
        ]
      );
      
      $controls_stack->end_injection();
    }

  }
  
  $Elementor_Add_Page_Body_CSS_Class = new Elementor_Add_Page_Body_CSS_Class();
  $Elementor_Add_Page_Body_CSS_Class->init();
}	
add_action( 'init', 'add_shortcodes_search' );


function add_shortcodes_search() {
	add_shortcode( 'listings_search', 'listings_shortcode_callback');
	add_shortcode( 'fetured_listings', 'fetured_listings_shortcode_callback' );
}

function listings_shortcode_callback(){
	
	ob_start();

	global $listify_job_manager;

	$atts = apply_filters(
		'job_manager_output_jobs_defaults',
		array(
			'per_page'                  => get_option( 'job_manager_per_page' ),
			'orderby'                   => 'featured',
			'order'                     => 'DESC',
			'show_categories'           => true,
			'categories'                => true,
			'selected_category'         => false,
			'job_types'                 => false,
			'location'                  => false,
			'keywords'                  => false,
			'selected_job_types'        => false,
			'show_category_multiselect' => false,
			'selected_region'           => false,
			'flat'                      => true,
		)
	);

	$filters = Listify_WP_Job_Manager_Template_Filters::get_filters( 'home', $atts );

	if ( empty( $filters ) ) {
		return;
	}
	?>

	<?php do_action( 'job_manager_job_filters_before', $atts ); ?>

	<form class="job_search_form job_search_form--count-<?php echo absint( count( $filters ) ); ?>" action="<?php echo esc_url( listify_get_listings_page_url() ); ?>" method="GET">
		<?php do_action( 'job_manager_job_filters_start', $atts ); ?>

		<div class="search_jobs">
			<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>
			
			<?php foreach ( $filters as $key => $filter ) : ?>
				<?php echo $filter; // WPCS: XSS ok. ?>
			<?php endforeach; ?>

			<?php do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>
		</div>

		<?php do_action( 'job_manager_job_filters_end', $atts ); ?>
	</form>

	<?php do_action( 'job_manager_job_filters_after', $atts );
		
	return ob_get_clean();
}

function fetured_listings_shortcode_callback( $atts ) {
	
	$atts = shortcode_atts(
		array(
			'ids'     => '', // Listings IDs, comma separated.
			'columns' => 3,
		),
		$atts
	);
	// Get listings.
	$args = array(
		'posts_per_page'         => 3,
		// 'featured'               => true,
		// 'no_found_rows'          => true,
		// 'update_post_term_cache' => false,
	);

	if ( $atts['ids'] ) {
		$args['post__in'] = wp_parse_id_list( $atts['ids'] );
	}

	listify_get_listings(
		array(
			'anchor'     => '#listings-shortcode-' . md5( serialize( $atts ) ),
			'query_args' => $args,
			'columns'    => $atts['columns'],
		)
	);

	ob_start();
	
	?>
	
		<ul id="listings-shortcode-<?php echo md5( serialize( $atts ) ); ?>" class="listings-shortcode">
		</ul>
		
	<?php
	
	return ob_get_clean();
}


add_filter( 'pa_display_conditions_values', function( $apply ) {
    return false;
});

// if(isset($_GET) && !empty($_GET)){
	
	// print_r($_GET);
// }
