<?php
/**
 * Primary Color
 *
 * @uses $wp_customize
 * @since 1.5.0
 */
if ( ! defined( 'ABSPATH' ) || ! $wp_customize instanceof WP_Customize_Manager ) {
	exit; // Exit if accessed directly.
}

$wp_customize->add_setting(
	'color-primary',
	array(
		'default'           => listify_theme_color( 'color-primary' ),
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'color-primary',
		array(
			'label'    => __( 'Primary Color', 'listify' ),
			'priority' => 20,
			'section'  => 'color-global',
		)
	)
);
/*
Settings only for vintage skin (new skin)
*/
$listify_new_skin = get_theme_mod( 'color-scheme' );	
if( isset($listify_new_skin) && $listify_new_skin == "listify-new-skin" ){
	$wp_customize->add_setting(
		'color-secondary',
		array(
			'default'           => listify_theme_color( 'color-secondary' ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'color-secondary',
			array(
				'label'    => __( 'Secondary Color', 'listify' ),
				'priority' => 20,
				'section'  => 'color-global',
			)
		)
	);


	$wp_customize->add_setting(
		'color-tertiary',
		array(
			'default'           => listify_theme_color( 'color-tertiary' ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'color-tertiary',
			array(
				'label'    => __( 'TertiaryColor', 'listify' ),
				'priority' => 20,
				'section'  => 'color-global',
			)
		)
	);
	$wp_customize->add_setting(
		'primary-color-1',
		array(
			'default'           => listify_theme_color( 'primary-color-1' ),
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'primary-color-1',
			array(
				'label'    => __( 'Primary Color-1', 'listify' ),
				'priority' => 20,
				'section'  => 'color-global',
			)
		)
	);
}