<?php
/**
 * Content Header
 *
 * @uses $wp_customize
 * @since 1.5.0
 */
$wp_customize->add_setting(
	'fixed-header',
	array(
		'default'   => true,
		'transport' => 'postMessage',
	)
);

$wp_customize->add_control(
	'fixed-header',
	array(
		'label'    => __( 'Fixed Header', 'listify' ),
		'type'     => 'checkbox',
		'priority' => 50,
		'section'  => 'title_tagline',
	)
);

/*
Settings only for vintage skin (new skin)
*/
$listify_new_skin = get_theme_mod( 'color-scheme' );	
if( isset($listify_new_skin) && $listify_new_skin == "listify-new-skin" ){
		
	// Text Options Section Inside Theme
	$wp_customize->add_setting(
		'header-button-text',
		array(
			'default'   => __( 'Explore' ),
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'header-button-text',
		array(
			'label'    => __( 'Header Button Text', 'listify' ),
			'type'     => 'text',
			'priority' => 50,
			'section'  => 'title_tagline',
		)
	);

	// Url Options Section Inside Theme
	$wp_customize->add_setting(
		'header-button-url',
		array(
			'default'   => __('#'),
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'header-button-url',
		array(
			'label'    => __( 'Header Button Url', 'listify' ),
			'type'     => 'text',
			'priority' => 50,
			'section'  => 'title_tagline',
		)
	);
	// Display Options Section Inside Theme
	$wp_customize->add_setting(
		'header-button-display',
		array(
			'default'   => true,
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		'header-button-display',
		array(
			'label'    => __( 'Header Button Display', 'listify' ),
			'type'     => 'checkbox',
			'priority' => 50,
			'section'  => 'title_tagline',
		)
	);
}