<?php
/**
 * Search Menu Icon
 *
 * @uses $wp_customize
 * @since 1.7.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$listify_new_skin = get_theme_mod( 'color-scheme' );	
$listify_search = 'left';
if( isset($listify_new_skin) && $listify_new_skin == "listify-new-skin" ){
	$listify_search = 'none';
}
$wp_customize->add_setting(
	'nav-search',
	array(
		'default' => $listify_search,
	)
);

$wp_customize->add_control(
	'nav-search',
	array(
		'label'    => __( 'Search Icon', 'listify' ),
		'type'     => 'select',
		'choices'  => array(
			'left'  => __( 'Left', 'listify' ),
			'right' => __( 'Right', 'listify' ),
			'none'  => __( 'None', 'listify' ),
		),
		'priority' => 20,
		'section'  => 'nav-menus',
	)
);
