<?php

/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */ 

$store_url_data = STORE_URL_DATA;

$theme_info = wp_get_theme();
	
if (wp_get_theme()->parent()) {
	$theme_info = wp_get_theme()->parent();
}

if( !defined( 'THEMESLUG' ) ){
	define('THEMESLUG', strtolower($theme_info['Name']));
}
define('THEMENAME', $theme_info['Name']);
define('THEMEVERSION', $theme_info['Version']);
define('THEMEAUTHOR', $theme_info['Author']);
define('STOREURL', $store_url_data['store_website']);
define('EDDAJAX', true);

/**
 * EDD Theme Updater Activate License
 */ 
function astoundify_edd_theme_updater_admin(){
	
	// retrieve the activated theme data from the database
	$theme_activation_data = get_option('thm_act_arr_data');
	
	$token = $theme_activation_data['license']  ? esc_attr( $theme_activation_data['license'] ) : false;
	$license_add_remove = isset( $_POST['license_add_remove'] ) ? esc_attr( $_POST['license_add_remove'] ) : false;
	
	if( $theme_activation_data['activation_response'] == 'theme_activation_successfull' ){
		update_option( THEMESLUG . '_license_key', $token );	
	}
			
	if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
		include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
	}
	
	// Loads the updater classes
	$updater = new EDD_Theme_Updater_Admin(

		// Config settings
		$config = array(
			'remote_api_url' 	=> STOREURL, // Site where EDD is hosted
			'item_name'      	=> THEMENAME, // Name of theme
			'theme_slug'     	=> THEMESLUG, // Theme slug
			'version'        	=> THEMEVERSION, // The current version of this theme
			'author'         	=> THEMEAUTHOR, // The author of this theme
			'download_id'    	=> '', // Optional, used for generating a license renewal link
			'item_id'    		=> 70, //$theme_activation_data['item_id'],
			'renew_url'      	=> '', // Optional, allows for a custom license renewal link
			'beta'           	=> false, // Optional, set to true to opt into beta versions
			'licenseaction'  	=> 'activate',
			'edd_ajax'  		=> EDDAJAX
		),

		// Strings
		$strings = array(
			'theme-license'             => __( 'Theme License', 'edd-theme-updater' ),
			'enter-key'                 => __( 'Enter your theme license key.', 'edd-theme-updater' ),
			'license-key'               => __( 'License Key', 'edd-theme-updater' ),
			'license-action'            => __( 'License Action', 'edd-theme-updater' ),
			'deactivate-license'        => __( 'Deactivate License', 'edd-theme-updater' ),
			'activate-license'          => __( 'Activate License', 'edd-theme-updater' ),
			'status-unknown'            => __( 'License status is unknown.', 'edd-theme-updater' ),
			'renew'                     => __( 'Renew?', 'edd-theme-updater' ),
			'unlimited'                 => __( 'unlimited', 'edd-theme-updater' ),
			'license-key-is-active'     => __( 'License key is active.', 'edd-theme-updater' ),
			'expires%s'                 => __( 'Expires %s.', 'edd-theme-updater' ),
			'expires-never'             => __( 'Lifetime License.', 'edd-theme-updater' ),
			'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'edd-theme-updater' ),
			'license-key-expired-%s'    => __( 'License key expired %s.', 'edd-theme-updater' ),
			'license-key-expired'       => __( 'License key has expired.', 'edd-theme-updater' ),
			'license-keys-do-not-match' => __( 'License keys do not match.', 'edd-theme-updater' ),
			'license-is-inactive'       => __( 'License is inactive.', 'edd-theme-updater' ),
			'license-key-is-disabled'   => __( 'License key is disabled.', 'edd-theme-updater' ),
			'site-is-inactive'          => __( 'Site is inactive.', 'edd-theme-updater' ),
			'license-status-unknown'    => __( 'License status is unknown.', 'edd-theme-updater' ),
			'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'edd-theme-updater' ),
			'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'edd-theme-updater' ),
		)

	);

	$theme_license_url = add_query_arg( array( 'page' => 'listify-setup'), admin_url('admin.php') );
	
	$response = $updater->check_license();
	update_option(THEMESLUG . '_license_key_reason', $response);
	$status = get_option( THEMESLUG . '_license_key_status', false );
	if($status == 'site_inactive'){
	    $status = 'Inactive';

		$redirect = add_query_arg( array( 'sl_activation' => 'false', 'msg' => __( 'Invalid', 'listify' ) ), $theme_license_url );
		wp_redirect( $redirect );
		exit();
	}

	wp_redirect( $theme_license_url );
	exit();
	
}


/**
 * EDD Theme Updater Deactivate License
 */ 
function astoundify_remove_theme_updater_admin(){
	
	if( isset( $_POST['license_deactivate_btn'] ) ) {
		// retrieve the activated theme data from the database
		$theme_activation_data = get_option('thm_act_arr_data');
		$token = $theme_activation_data['license']  ? esc_attr( $theme_activation_data['license'] ) : false;
		$license_add_remove = isset( $_POST['license_add_remove'] ) ? esc_attr( $_POST['license_add_remove'] ) : false;
		
		if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
			include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
		}
	
		// Loads the updater classes
		$updater = new EDD_Theme_Updater_Admin(
	
			// Config settings
			$config = array(
				'remote_api_url' 	=> STOREURL, // Site where EDD is hosted
				'item_name'      	=> THEMENAME, // Name of theme
				'theme_slug'     	=> THEMESLUG, // Theme slug
				'version'        	=> THEMEVERSION, // The current version of this theme
				'author'         	=> THEMEAUTHOR, // The author of this theme
				'download_id'    	=> '', // Optional, used for generating a license renewal link
				'item_id'    		=> 70, //$theme_activation_data['item_id'],
				'renew_url'      	=> '', // Optional, allows for a custom license renewal link
				'beta'           	=> false, // Optional, set to true to opt into beta versions
				'licenseaction'  	=> 'deactivate', // ajax purpose
				'edd_ajax'  		=> EDDAJAX
			),
	
			// Strings
			$strings = array(
				'theme-license'             => __( 'Theme License', 'edd-theme-updater' ),
				'enter-key'                 => __( 'Enter your theme license key.', 'edd-theme-updater' ),
				'license-key'               => __( 'License Key', 'edd-theme-updater' ),
				'license-action'            => __( 'License Action', 'edd-theme-updater' ),
				'deactivate-license'        => __( 'Deactivate License', 'edd-theme-updater' ),
				'activate-license'          => __( 'Activate License', 'edd-theme-updater' ),
				'status-unknown'            => __( 'License status is unknown.', 'edd-theme-updater' ),
				'renew'                     => __( 'Renew?', 'edd-theme-updater' ),
				'unlimited'                 => __( 'unlimited', 'edd-theme-updater' ),
				'license-key-is-active'     => __( 'License key is active.', 'edd-theme-updater' ),
				'expires%s'                 => __( 'Expires %s.', 'edd-theme-updater' ),
				'expires-never'             => __( 'Lifetime License.', 'edd-theme-updater' ),
				'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'edd-theme-updater' ),
				'license-key-expired-%s'    => __( 'License key expired %s.', 'edd-theme-updater' ),
				'license-key-expired'       => __( 'License key has expired.', 'edd-theme-updater' ),
				'license-keys-do-not-match' => __( 'License keys do not match.', 'edd-theme-updater' ),
				'license-is-inactive'       => __( 'License is inactive.', 'edd-theme-updater' ),
				'license-key-is-disabled'   => __( 'License key is disabled.', 'edd-theme-updater' ),
				'site-is-inactive'          => __( 'Site is inactive.', 'edd-theme-updater' ),
				'license-status-unknown'    => __( 'License status is unknown.', 'edd-theme-updater' ),
				'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'edd-theme-updater' ),
				'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'edd-theme-updater' ),
			)
	
		);	
	  
		$response = $updater->check_license();	
		if( $response == 'License is inactive.' ){		
			delete_option( THEMESLUG . '_license_key_reason' );	
			delete_option( THEMESLUG . '_license_key');				
			delete_option( THEMESLUG . '_license_key_status');				
		}		
		$status = '';

	}
	
}
add_action('admin_init', 'astoundify_remove_theme_updater_admin');

/**
 * EDD Theme Updater Default Active
 */ 
//global $pagenow;
//if (( $pagenow == "themes.php" || $pagenow == "update-core.php" )) {  // commment this line if ajax not used /  want to use as Appearance --> Theme License
	
	$theme_activation_data = get_option('thm_act_arr_data');
	
	if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
		include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
	}
	
	// Loads the updater classes
	$updater = new EDD_Theme_Updater_Admin(
			
		// Config settings
		$config = array(
			'remote_api_url' 	=> STOREURL, // Site where EDD is hosted
			'item_name'      	=> THEMENAME, // Name of theme
			'item_id'    		=> 70, //$theme_activation_data['item_id'],
			'theme_slug'     	=> THEMESLUG, // Theme slug
			'version'        	=> THEMEVERSION, // The current version of this theme
			'author'         	=> THEMEAUTHOR, // The author of this theme
			'download_id'    	=> '', // Optional, used for generating a license renewal link
			'renew_url'      	=> '', // Optional, allows for a custom license renewal link
			'beta'           	=> false, // Optional, set to true to opt into beta versions
			'licenseaction'  	=> false, // Optional, set to true to opt into beta versions
			'edd_ajax'  		=> EDDAJAX
		),

		// Strings
		$strings = array(
			'theme-license'             => __( 'Theme License', 'edd-theme-updater' ),
			'enter-key'                 => __( 'Enter your theme license key.', 'edd-theme-updater' ),
			'license-key'               => __( 'License Key', 'edd-theme-updater' ),
			'license-action'            => __( 'License Action', 'edd-theme-updater' ),
			'deactivate-license'        => __( 'Deactivate License', 'edd-theme-updater' ),
			'activate-license'          => __( 'Activate License', 'edd-theme-updater' ),
			'status-unknown'            => __( 'License status is unknown.', 'edd-theme-updater' ),
			'renew'                     => __( 'Renew?', 'edd-theme-updater' ),
			'unlimited'                 => __( 'unlimited', 'edd-theme-updater' ),
			'license-key-is-active'     => __( 'License key is active.', 'edd-theme-updater' ),
			'expires%s'                 => __( 'Expires %s.', 'edd-theme-updater' ),
			'expires-never'             => __( 'Lifetime License.', 'edd-theme-updater' ),
			'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'edd-theme-updater' ),
			'license-key-expired-%s'    => __( 'License key expired %s.', 'edd-theme-updater' ),
			'license-key-expired'       => __( 'License key has expired.', 'edd-theme-updater' ),
			'license-keys-do-not-match' => __( 'License keys do not match.', 'edd-theme-updater' ),
			'license-is-inactive'       => __( 'License is inactive.', 'edd-theme-updater' ),
			'license-key-is-disabled'   => __( 'License key is disabled.', 'edd-theme-updater' ),
			'site-is-inactive'          => __( 'Site is inactive.', 'edd-theme-updater' ),
			'license-status-unknown'    => __( 'License status is unknown.', 'edd-theme-updater' ),
			'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'edd-theme-updater' ),
			'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'edd-theme-updater' ),
		)
	);	
	
// } // commment this curly brace if ajax not used /  want to use as Appearance --> Theme License
