<?php

/**
 * Search Form Widget
 *
 * @since 1.0.0
 *
 * @package Listify
 * @category Widget
 * @author Astoundify
 */

class Listify_Widget_Search_Form extends WP_Widget {

	function __construct() {

		parent::__construct(

		'listify_search_listings', 

		__('Listify Search Listings', 'listify'), 
		  
		array( 'description' => __( 'Display Search Listings.', 'listify' ), ) 
		);

	}

	public function widget( $args, $instance ) {
	
		$title = apply_filters( 'widget_title', $instance['title'] );
		$widget_head = apply_filters( 'widget_head', $instance['widget_head'] );
		$widget_desc = apply_filters( 'widget_desc', $instance['widget_desc'] );
		$widget_radius = apply_filters( 'widget_radius', $instance['widget_radius'] );

		$job_manager_enable_types = get_option("job_manager_enable_types", 1);

		$widget_extra_filter = apply_filters( 'widget_extra_filter', $instance['widget_extra_filter'] );

		$widget_extra_filter_by_label = apply_filters( 'widget_extra_filter_by_label',$instance['widget_extra_filter_by_label'] );

		$widget_listify_class_radius = "";
		$widget_listify_class_types = "";
		$widget_listify_class_label = "";
		  
		echo $args['before_widget'];
		if ( ! empty( $title ) ){
			echo $args['before_title'] . $title . $args['after_title'];	
		}else{
			echo $args['before_title'] . __('Explore This City', 'listify') . $args['after_title'];
		}

		if ( ! empty( $widget_head ) ){
			$widget_head = $widget_head;
		}else{
			$widget_head = __('Header', 'listify');

		}
		
		if ( ! empty( $widget_desc ) ){
			$widget_desc = $widget_desc;
		}else{
			$widget_desc = __('Description', 'listify');
		}

		if (  ( ! empty( $widget_radius ) ) && $widget_radius == "true"  ){
				$widget_listify_class_radius = "";
		}
		else{
				$widget_listify_class_radius = "widget_listify_class_radius";
		}

		if (  ( ! empty( $widget_extra_filter ) ) && ( $widget_extra_filter == "true" ) && ($job_manager_enable_types != 0 ) ){
				$widget_listify_class_types = "";
		}
		else{
				$widget_listify_class_types = "widget_listify_class_types";
		}

		if (  ( ! empty( $widget_extra_filter_by_label ) ) && ( $widget_extra_filter_by_label == "true" ) ){
				$widget_listify_class_label = "";
		}
		else{
				$widget_listify_class_label = "widget_listify_class_label";
		}
		
		the_widget(

			'Listify_Widget_Search_Listings',
			apply_filters(
				'listify_widget_search_listings_default',
				array(
					'title'       => $widget_head,
					'description' => $widget_desc
				)
			),
			array(
				'before_widget' => '<div class="wp_widget_listify_search_listings job_listings '.$widget_listify_class_label .' '. $widget_listify_class_types . ' ' . $widget_listify_class_radius .'">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="wp-widget-listify-widget-section-title"><h2 class="wp-widget-listify-widget-title">',
				'after_title'   => '</h2></div>',
				'widget_id'     => 'search-12391',
				'id'            => 'wp-widget-area-listify',
			)

		);

		echo $args['after_widget'];
	}
          
	
	public function form( $instance ) {
		

		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'Listify Search Title', 'listify' );
		}

		if ( isset( $instance[ 'widget_head' ] ) ) {
			$widget_head = $instance[ 'widget_head' ];
		}
		else {
			$widget_head = __( 'Listify Search Header', 'listify' );
		}

		if ( isset( $instance[ 'widget_desc' ] ) ) {
			$widget_desc = $instance[ 'widget_desc' ];
		}
		else {
			$widget_desc = __( 'Listify Search Description', 'listify' );
		}

		if ( isset( $instance[ 'widget_radius' ] ) &&  $instance[ 'widget_radius' ] == "true") {
			$widget_radius = "true";
		}
		else {
			$widget_radius = "false";
		}

		if ( isset( $instance[ 'widget_extra_filter' ] ) &&  $instance[ 'widget_extra_filter' ] == "true") {
			$widget_extra_filter = "true";	
		}
		else {
			$widget_extra_filter = "false";
		}

		if ( isset( $instance[ 'widget_extra_filter_by_label' ] ) &&  $instance[ 'widget_extra_filter_by_label' ] == "true") {
			$widget_extra_filter_by_label = "true";
		}
		else {
			$widget_extra_filter_by_label = "false";
		}

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'widget_head' ); ?>"><?php _e( 'Header:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'widget_head' ); ?>" name="<?php echo $this->get_field_name( 'widget_head' ); ?>" type="text" value="<?php echo esc_attr( $widget_head ); ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'widget_desc' ); ?>"><?php _e( 'Description:' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'widget_desc' ); ?>" name="<?php echo $this->get_field_name( 'widget_desc' ); ?>" rows="4" cols="50"><?php echo esc_attr( $widget_desc ); ?></textarea>
		</p>

		<p>
		    <input class="checkbox widefat" type="checkbox" <?php if ($widget_radius == "true"){?> checked="checked" <?php } ?> id="<?php echo $this->get_field_id( 'widget_radius' ); ?>" name="<?php echo $this->get_field_name( 'widget_radius' ); ?>" <?php if ($widget_radius == "true"){?> value="true" <?php }else{ ?> value="false" <?php  } ?>  /> 

		    <label for="<?php echo $this->get_field_id( 'widget_radius' ); ?>"><?php echo __( 'Enable Search by Radius', 'listify' ); ?></label>
		</p>

		<p>
		    <input class="checkbox widget_extra_filter widefat" type="checkbox" <?php if ($widget_extra_filter == "true"){?> checked="checked" <?php } ?> id="<?php echo $this->get_field_id( 'widget_extra_filter' ); ?>" name="<?php echo $this->get_field_name( 'widget_extra_filter' ); ?>" <?php if ($widget_extra_filter == "true"){?> value="true" <?php }else{ ?> value="false" <?php  } ?>  /> 

		    <label for="<?php echo $this->get_field_id( 'widget_extra_filter' ); ?>"><?php echo __( 'Enable Filter by Type', 'listify' ); ?> </label>
		</p>

		<?php 

			if( in_array('wp-job-manager-listing-labels/wp-job-manager-listing-labels.php', apply_filters('active_plugins', get_option('active_plugins'))) ) {
			?> 

				<p>
				    <input class="checkbox widget_extra_filter_by_label widefat" type="checkbox" <?php if ($widget_extra_filter_by_label == "true"){?> checked="checked" <?php } ?> id="<?php echo $this->get_field_id( 'widget_extra_filter_by_label' ); ?>" name="<?php echo $this->get_field_name( 'widget_extra_filter_by_label' ); ?>" <?php if ($widget_extra_filter_by_label == "true"){?> value="true" <?php }else{ ?> value="false" <?php  } ?>  /> 
				    <label for="<?php echo $this->get_field_id( 'widget_extra_filter_by_label' ); ?>"><?php echo __( 'Enable Filter by label', 'listify' ); ?> </label>
				</p>

			<?php 

			}

		?>

		<?php 
	}
      

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		$instance['widget_head'] = ( ! empty( $new_instance['widget_head'] ) ) ? strip_tags( $new_instance['widget_head'] ) : '';

	    $instance['widget_desc'] = ( ! empty( $new_instance['widget_desc'] ) ) ? strip_tags( $new_instance['widget_desc'] ) : '';

	    $instance['widget_radius'] = ( ! empty( $new_instance['widget_radius'] ) ) ? 'true' : 'false';

	    $instance['widget_extra_filter'] = ( ! empty( $new_instance['widget_extra_filter'] ) ) ? 'true' : 'false';	

	    $instance['widget_extra_filter_by_label'] = ( ! empty( $new_instance['widget_extra_filter_by_label'] ) ) ? 'true' : 'false';	    

		return $instance;
	}
 
	// Class wpb_widget ends here


}