<?php
/**
 * Extra procsesing for Listify
 *
 * @since 1.0.0
 */
class Astoundify_CI_Theme_Listify implements Astoundify_CI_PluginInterface {

	/**
	 * Initialize the plugin processing
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function init() {
		self::setup_actions();
	}

	/**
	 * Add any pre/post actions to processing.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public static function setup_actions() {
		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_hours' )
		);

		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_gallery' ),
			20
		);
		
		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_schedule' )
		);
		
		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_sponsors' )
		);
		
		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_speakers' )
		);
		
		add_action(
			'astoundify_import_content_after_import_item_type_object',
			array( __CLASS__, 'set_speakers_social' )
		);
	}

	/**
	 * Add business hours to a listing
	 *
	 * If `hours` is set update the _job_hours meta.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_hours( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'job_listing' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-hours',
			sprintf( 'Business hours for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		if ( isset( $item_data['hours'] ) ) {
			$_hours = array();
			$hours = $item_data['hours'];

			foreach ( $hours as $day => $times ) {
				$_hours[ $day ] = array(
					'start' => $times[0],
					'end' => $times[1],
				);
			}

			update_post_meta( $listing_id, '_job_hours', $_hours );
		}

		// needs better error checking
		return true;
	}

	/**
	 * Set the listing gallery
	 *
	 * If `media` is defined the uploaded images will be set as the gallery
	 * images for the current product.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_gallery( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'job_listing' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-gallery',
			sprintf( 'Gallery for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		// single price
		if ( isset( $item_data['media'] ) ) {
			$images = get_attached_media( 'image', $listing_id );

			if ( ! empty( $images ) ) {
				$image_ids = implode( ',', wp_list_pluck( $images, 'ID' ) );
				$image_urls = array();

				foreach ( $images as $image ) {
					$image_urls[] = wp_get_attachment_url( $image->ID );
				}

				update_post_meta( $listing_id, '_gallery', "[gallery ids={$image_ids}]" );
				update_post_meta( $listing_id, '_gallery_images', $image_urls );
			}
		}

		// needs better error checking
		return true;
	}
	
	/**
	 * Set the listing schedule
	 *
	 * If `schedule` is set update the eventify_cmb2_repeat_group meta.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_schedule( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'job_listing' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-schedule',
			sprintf( 'Schedule for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		// single price
		if ( isset( $item_data['schedule'] ) ) {
			
			$_schedules = array();
			$schedules = $item_data['schedule'];

			foreach ( $schedules as $scheduleskey => $schedulesvalue ) {
				$_schedules[ $scheduleskey ] = array(
					'eventify_schedule_days' => $schedulesvalue[0],
					'eventify_schedule_description' => $schedulesvalue[1]					
				);
			}

			update_post_meta( $listing_id, 'eventify_cmb2_repeat_group', $_schedules );
			
		}

		// needs better error checking
		return true;
	}
	
	/**
	 * Set the listing sponsors
	 *
	 * If `sponsors` is set update the _eventify_options_events_sponsors meta.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_sponsors( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'job_listing' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-sponsors',
			sprintf( 'Sponsors for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		// single price
		if ( isset( $item_data['sponsors'] ) ) {
			
			$_sponsors = array();
			$sponsors = $item_data['sponsors'];

			foreach ( $sponsors as $sponsorskey => $sponsorsvalue ) {
				$_sponsors[ $sponsorskey ] = array(
					'eventify_sponsors_title' => $sponsorsvalue[0],
					'eventify_sponsors_image' => $sponsorsvalue[1],
					'eventify_sponsors_url' => $sponsorsvalue[2]					
				);
			}

			update_post_meta( $listing_id, '_eventify_options_events_sponsors', $_sponsors );
			
		}

		// needs better error checking
		return true;
	}
	
	/**
	 * Set the listing speakers
	 *
	 * If `speakers` is set update the _eventify_options_events_organizer meta.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_speakers( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'job_listing' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-speakers',
			sprintf( 'Speakers for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		// single price
		if ( isset( $item_data['speakers'] ) ) {
			
			$_speakers = array();
			$speakers = $item_data['speakers'];

			foreach ( $speakers as $speakersvalue ) {
				$_speakers[] = $speakersvalue;
			}

			update_post_meta( $listing_id, '_eventify_options_events_organizer', $_speakers );
			
		}
		
		// needs better error checking
		return true;
	}
	
	/**
	 * Set the listing speakers_social
	 *
	 * If `speakers_social` is set update the _eventify_option_social_fields meta.
	 *
	 * @since 1.0.0
	 * @return true|WP_Error True if the format can be set.
	 */
	public static function set_speakers_social( $ItemImport ) {
		$item_data = $ItemImport->item['data'];

		// do nothing if this is not relevant to the current object type
		if ( 'speakers' != $item_data['post_type'] ) {
			return false;
		}

		$error = new WP_Error(
			'set-speaker-social',
			sprintf( 'Speakers Social for %s was not set', $ItemImport->get_id() )
		);

		// only work with a valid processed object
		$object = $ItemImport->get_processed_item();

		if ( is_wp_error( $object ) ) {
			return $error;
		}

		$listing_id = $object->ID;

		// single price
		if ( isset( $item_data['speakers_social'] ) ) {
			
			$_speakers_social = array();
			$speakers_social = $item_data['speakers_social'];

			foreach ( $speakers_social as $speakers_socialkey => $speakers_socialvalue ) {
				$_speakers_social[ $speakers_socialkey ] = array(
					'eventify_facebook_url' => $speakers_socialvalue[0],
					'eventify_facebook_image' => $speakers_socialvalue[1],
					'eventify_twitter_url' => $speakers_socialvalue[2],				
					'eventify_twitter_image' => $speakers_socialvalue[3],					
					'eventify_linkedin_url' => $speakers_socialvalue[4],					
					'eventify_linkedin_image' => $speakers_socialvalue[5],					
					'eventify_github_url' => $speakers_socialvalue[6],				
					'eventify_github_image' => $speakers_socialvalue[7],				
					'eventify_dribbble_url' => $speakers_socialvalue[8],			
					'eventify_dribbble_image' => $speakers_socialvalue[9]		
				);
			}

			update_post_meta( $listing_id, '_eventify_option_social_fields', $_speakers_social );
			
		}
		
		// needs better error checking
		return true;
	}

}
