<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width">
	<title><?php wp_title('|', true, 'right'); ?></title>
	<link rel="profile" href="//gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/bootstrap/bootstrap.min.css">
	<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>
	<script src="<?php echo get_template_directory_uri(); ?>/bootstrap/bootstrap.min.js"></script>-->
	<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css">
	<!--<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/blauw.css">-->

	<?php
	$favicon_url = get_theme_mod('general_favicon_image') ?: get_theme_mod('general_favicon_image_url', get_template_directory_uri() . '/img/default-logo.jpg');
	if (strpos($favicon_url, '/wp-content/') !== false) {
		$favicon_url = @explode('/wp-content/', $favicon_url);
		$favicon_url = '/wp-content/' . $favicon_url[1];
	}
	?>
	<?php if ($favicon_url) { ?>
	<link rel="shortcut icon" type="image/icon" href="<?php echo $favicon_url; ?>"/>
	<?php } ?>

	<?php wp_head(); ?>

    <style>
        /** Cn button color **/
        .cn-button.bootstrap {
            background: linear-gradient(to bottom, #225a2e 0%, #009933 100%);
        }
    </style>

	<?php echo get_theme_mod('general_head_html'); ?>

	<?php dynamic_sidebar('tracking'); ?>

</head>

<body <?php body_class(); ?>>

	<?php if (senhblog_is_layout_boxed()) { ?>
	<div class="boxed-container">
	<?php } ?>

	<header id="header-top-cn">
		<div class="<?php if (false && !get_theme_mod('layout_fullwidth_header_footer', true)) { ?>container<?php } ?>">
			<?php if (senhblog_is_visible('header')) { ?>
			<div class="row header-container-row">
				<div class="col-md-12">
					<div class="header-container container">
						<?php if (senhblog_is_visible('extra-header-menu')) { ?>
						<?php senhblog_nav_menu('header-extra'); ?>
						<?php } ?>
						<?php
						$imgurl = get_theme_mod('header_image', get_theme_mod('header_image_url', get_template_directory_uri() . '/img/default-logo.jpg'));
						if ($imgurlparts = @explode('/wp-content/', $imgurl)) {
							$imgurl = content_url() . '/' . $imgurlparts[1];
							$filepath = ABSPATH . 'wp-content/' . $imgurlparts[1];
							if (file_exists($filepath)) {
								$imginfo = getimagesize($filepath);
							}
						}
						?>
						<a href="<?php echo get_site_url(); ?>"><img src="<?php echo $imgurl; ?>" <?php echo @$imginfo[3]; ?> class="header-image"/></a>
					</div>
				</div>
			</div>
			<?php } ?>

			<div class="">

			<?php if (senhblog_is_visible('mainmenu')) { ?>
			<?php senhblog_nav_menu('header-primary'); ?>
			<?php } ?>

			<?php if (senhblog_is_visible('submenu')) { ?>
			<?php senhblog_nav_menu('header-secondary'); ?>
			<?php } ?>

			</div>
		</div>
	</header>

	<main>

		<?php dynamic_sidebar('below-header-full'); ?>

		<div class="container">

			<?php do_action('senhblog_blogheader'); ?>

			<div class="row">

			<?php if (senhblog_is_visible('breadcrumbs')) { ?>
			<?php do_action('senhblog_breadcrumbs'); ?>
			<?php } ?>
