<?php

add_action('customize_register', 'senhblog_blog1_customize_register');
function senhblog_blog1_customize_register($wp_customize) {

	require_once(get_template_directory() . '/lib/customizer/wp_slider_control.php');

    $wp_customize->add_section('senhblog_blog1', array(
        'title'    => customize_options_language('6a. Blog page top', '6a. Blog pagina bovenkant'),
        'description' => '',
        'priority' => 125,
    ));

    $wp_customize->add_setting('blogheader_title', array(
        'default'        => '',
        'transport'     => 'refresh',
    ));
    $wp_customize->add_control('blogheader_title', array(
        'label'      => customize_options_language('Title', 'Titel') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blogheader_title'
    ));

	if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php')) {
		$wp_customize->add_setting('blog_title_use_yoast_meta_title', array(
			'default'        => false
		));
		$wp_customize->add_control('blog_title_use_yoast_meta_title', array(
			'label'      => customize_options_language('Use SEO title', 'Gebruik SEO titel'),
			'section'    => 'senhblog_blog1',
			'settings'   => 'blog_title_use_yoast_meta_title',
			'type' => 'checkbox'
		));
	}

	$wp_customize->add_setting('blogheader_description', array(
        'default'        => '',
        'transport'     => 'refresh',
    ));
    $wp_customize->add_control('blogheader_description', array(
        'label'      => customize_options_language('Description', 'Omschrijving') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blogheader_description'
    ));

	if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php')) {
		$wp_customize->add_setting('blog_title_use_yoast_meta_description', array(
			'default'        => false
		));
		$wp_customize->add_control('blog_title_use_yoast_meta_description', array(
			'label'      => customize_options_language('Use meta description', 'Gebruik meta-omschrijving'),
			'section'    => 'senhblog_blog1',
			'settings'   => 'blog_title_use_yoast_meta_description',
			'type' => 'checkbox'
		));
	}

	$wp_customize->add_setting('blog_blogheader_title_fontsize', array(
        'default'        => 30,
        'transport'     => 'postMessage'
    ));
    $wp_customize->add_control('blog_blogheader_title_fontsize', array(
        'label'      => customize_options_language('Blog title font size', 'Blog titel lettertype grootte') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blog_blogheader_title_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting(
		'blog_blogheader_title_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_blogheader_title_color',
			array(
				'label'      => customize_options_language('Blog title color', 'Blog titel kleur') . ':',
				'section'    => 'senhblog_blog1',
				'settings'   => 'blog_blogheader_title_color'
			)
		)
	);

	$wp_customize->add_setting('blog_blogheader_title_fontweight', array(
        'default'        => 'normal',
        'transport'     => 'postMessage'
    ));
    $wp_customize->add_control('blog_blogheader_title_fontweight', array(
        'label'      => customize_options_language('Blog title font weight', 'Blog titel lettertype dikte') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blog_blogheader_title_fontweight',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$blogheader_title_cts_show_choices = array('show_title' => customize_options_language('Default', 'Standaard'), 'show_default_title' => customize_options_language('Use title', 'Gebruik titel'));
	if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php')) {
		$blogheader_title_cts_show_choices['use_seo_title'] = customize_options_language('Use SEO title', 'Gebruik SEO titel');
	}
	$wp_customize->add_setting('blogheader_title_cts_show', array(
		'default'        => 'show_title'
	));
	$wp_customize->add_control('blogheader_title_cts_show', array(
		'label'      => customize_options_language('Use title on category/tag/search', 'Gebruik titel bij categorie/tag/zoeken') . ':',
		'section'    => 'senhblog_blog1',
		'settings'   => 'blogheader_title_cts_show',
		'type' => 'select',
		'choices' => $blogheader_title_cts_show_choices
	));

	$blogheader_description_cts_show_choices = array('hide_description' => customize_options_language('Hide description', 'Geen omschrijving'), 'show_description' => customize_options_language('Default description', 'Standaard omschrijving'));
	if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php')) {
		$blogheader_description_cts_show_choices['use_seo_description'] = customize_options_language('Use SEO description', 'Gebruik SEO omschrijving');
	}
	$wp_customize->add_setting('blogheader_description_cts_show', array(
		'default'        => 'show_description'
	));
	$wp_customize->add_control('blogheader_description_cts_show', array(
		'label'      => customize_options_language('Use description on category/tag/search', 'Gebruik omschrijving bij categorie/tag/zoeken') . ':',
		'section'    => 'senhblog_blog1',
		'settings'   => 'blogheader_description_cts_show',
		'type' => 'select',
		'choices' => $blogheader_description_cts_show_choices
	));

	$wp_customize->add_setting('blogheader_padding_top', array(
        'default'        => 15,
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blogheader_padding_top', array(
        'label'      => customize_options_language('Padding top blogheader', 'Afstand bovenkant blogheader') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blogheader_padding_top',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 15
    )));

	$wp_customize->add_setting('blogheader_padding_bottom', array(
        'default'        => 15,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blogheader_padding_bottom', array(
        'label'      => customize_options_language('Padding top blogheader', 'Afstand bovenkant blogheader') . ':',
        'section'    => 'senhblog_blog1',
        'settings'   => 'blogheader_padding_bottom',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 15
    )));
}

add_action('customize_register', 'senhblog_blog2_customize_register');
function senhblog_blog2_customize_register($wp_customize) {

	require_once(get_template_directory() . '/lib/customizer/wp_slider_control.php');

    $wp_customize->add_section('senhblog_blog2', array(
        'title'    => customize_options_language('6b. Blog page blogposts', '6b. Blog pagina blogposts'),
        'description' => '',
        'priority' => 125,
    ));

	$wp_customize->add_setting('blog_num_posts_row', array(
        'default'        => 2,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_num_posts_row', array(
        'label'      => customize_options_language('Num posts in a row', 'Aantal berichten naast elkaar') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_num_posts_row',
		'type'		=> 'select',
		'choices' => array('1' => '1', '2' => '2', '3' => '3', '4' => '4')
    ));

	$wp_customize->add_setting('blog_num_posts_per_page', array(
        'default'        => get_option('posts_per_page'),
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_num_posts_per_page', array(
        'label'      => customize_options_language('Num posts on homepage', 'Aantal berichten op hoofdpagina') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_num_posts_per_page',
		'type'		=> 'number',
		'min' => 1,
		'step' => 1
    ));

	$wp_customize->add_setting('blog_marginbetween_posts', array(
        'default'        => 0,
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_marginbetween_posts', array(
        'label'      => customize_options_language('Margin between blogposts', 'Afstand tussen blogberichten') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_marginbetween_posts',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('blog_marginbottom_posts', array(
        'default'        => 50,
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_marginbottom_posts', array(
        'label'      => customize_options_language('Margin bottom blogposts', 'Afstand onderkant blogberichten') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_marginbottom_posts',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 50
    )));

	$wp_customize->add_setting(
		'blog_postsnippet_background_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_postsnippet_background_color',
			array(
				'label'      => customize_options_language('Blog post snippet background color', 'Blog artikel achtergrondkleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_postsnippet_background_color'
			)
		)
	);

	$wp_customize->add_setting('blog_postsnippet_borderwidth', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_postsnippet_borderwidth', array(
        'label'      => customize_options_language('Blog post snippet border width', 'Blog artikel omlijning dikte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_postsnippet_borderwidth',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('blog_postsnippet_padding', array(
        'default'        => 10,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_postsnippet_padding', array(
        'label'      => customize_options_language('Blog post snippet padding (left and right)', 'Blog artikel padding (links en rechts)') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_postsnippet_padding',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting(
		'blog_postsnippet_bordercolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_postsnippet_bordercolor',
			array(
				'label'      => customize_options_language('Blog post snippet border color', 'Blog artikel omlijning kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_postsnippet_bordercolor'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_postsnippet_shadowcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_postsnippet_shadowcolor',
			array(
				'label'      => customize_options_language('Blog post snippet shadow color', 'Blog artikel schaduw kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_postsnippet_shadowcolor'
			)
		)
	);

	$wp_customize->add_setting('blog_post_title_fontsize', array(
        'default'        => 30,
        'transport'     => 'postMessage'
    ));
    $wp_customize->add_control('blog_post_title_fontsize', array(
        'label'      => customize_options_language('Blog post title font size', 'Blog artikel titel lettertype grootte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_title_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting(
		'blog_post_title_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_title_color',
			array(
				'label'      => customize_options_language('Blog post title color', 'Blog post titel kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_title_color'
			)
		)
	);

	$wp_customize->add_setting('blog_post_description', array(
		'default'        => 'meta_description'
	));
	$wp_customize->add_control('blog_post_description', array(
		'label'      => customize_options_language('Blog post description', 'Blog artikel omschrijving') . ':',
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_description',
		'type' => 'select',
		'choices' => array('meta_description' => customize_options_language('Use meta description', 'Gebruik meta omschrijving'), 'before_more_tag' => customize_options_language('Show all before more tag', 'Toon alles voor de more tag'))
	));

	$wp_customize->add_setting('blog_post_title_underline', array(
		'default'        => false
	));
	$wp_customize->add_control('blog_post_title_underline', array(
		'label'      => customize_options_language('Blog post title underline', 'Blog artikel titel onderlijn'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_title_underline',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_post_title_underline_on_hover', array(
		'default'        => false
	));
	$wp_customize->add_control('blog_post_title_underline_on_hover', array(
		'label'      => customize_options_language('Blog post title underline on hover', 'Blog artikel titel onderlijn bij hover'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_title_underline_on_hover',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_post_title_uppercase', array(
        'default'        => false
    ));
    $wp_customize->add_control('blog_post_title_uppercase', array(
        'label'      => customize_options_language('Blog post title to uppercase', 'Blog artikel titel in hoofdletters'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_title_uppercase',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting(
		'blog_post_title_color_on_hover',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_title_color_on_hover',
			array(
				'label'      => customize_options_language('Blog post title hover color', 'Blog post titel hover kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_title_color_on_hover'
			)
		)
	);

	$wp_customize->add_setting('blog_post_gravatar_size', array(
        'default'        => '80',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_gravatar_size', array(
        'label'      => customize_options_language('Gravatar size', 'Avatar grootte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_gravatar_size',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 80
    )));

	$wp_customize->add_setting('blog_post_details_fontsize', array(
        'default'        => '12',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_details_fontsize', array(
        'label'      => customize_options_language('Blog post details font size', 'Blog artikel details lettertype grootte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_details_fontsize',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 12
    )));

	$wp_customize->add_setting(
		'blog_post_details_link_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_details_link_color',
			array(
				'label'      => customize_options_language('Blog post details link color', 'Blog post details link kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_details_link_color'
			)
		)
	);

	$wp_customize->add_setting('blog_post_details_link_underlined', array(
		'default'        => false
	));
	$wp_customize->add_control('blog_post_details_link_underlined', array(
		'label'      => customize_options_language('Blog post details links underlined', 'Blog artikel details links onderstreept'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_details_link_underlined',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting(
		'blog_post_details_linkhover_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_details_linkhover_color',
			array(
				'label'      => customize_options_language('Blog post details link hover color', 'Blog post details link hover kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_details_linkhover_color'
			)
		)
	);

	$wp_customize->add_setting('blog_post_details_linkhover_underlined', array(
		'default'        => false
	));
	$wp_customize->add_control('blog_post_details_linkhover_underlined', array(
		'label'      => customize_options_language('Blog post details links underline on hover', 'Blog artikel details links onderstreept bij hover'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_details_linkhover_underlined',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_post_show_avatar', array(
		'default'        => true
	));
	$wp_customize->add_control('blog_post_show_avatar', array(
		'label'      => customize_options_language('Blog post show avatar', 'Blog artikel weergeef avatar'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_show_avatar',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_post_show_author', array(
		'default'        => false
	));
	$wp_customize->add_control('blog_post_show_author', array(
		'label'      => customize_options_language('Blog post show author', 'Blog artikel weergeef auteur'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_show_author',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_post_author_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('blog_post_author_position', array(
		'label'      => customize_options_language('Blog post author position', 'Blog artikel auteur positie'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_author_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('blog_post_author_prefix', array(
        'default'        => customize_options_language('By:', 'Door:'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_author_prefix', array(
        'label'      => customize_options_language('Authorname prefix', 'Auteurnaam prefix') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_author_prefix'
    ));

	$wp_customize->add_setting('blog_post_show_category', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_post_show_category', array(
        'label'      => customize_options_language('Show category', 'Weergeef categorie'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_show_category',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_category_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('blog_post_category_position', array(
		'label'      => customize_options_language('Blog post category position', 'Blog artikel categorie positie'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_category_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('blog_post_category_prefix', array(
        'default'        => customize_options_language('Category:', 'Categorie:'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_category_prefix', array(
        'label'      => customize_options_language('Category prefix', 'Categorie prefix') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_category_prefix'
    ));

	$wp_customize->add_setting('blog_post_show_date', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_post_show_date', array(
        'label'      => customize_options_language('Show date', 'Weergeef datum'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_show_date',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_date_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('blog_post_date_position', array(
		'label'      => customize_options_language('Blog post date position', 'Blog artikel datum positie'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_date_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('blog_post_show_comments', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_post_show_comments', array(
        'label'      => customize_options_language('Show number of comments', 'Weergeef aantal reacties'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_show_comments',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_comments_position', array(
		'default'        => 'below_title'
	));
	$wp_customize->add_control('blog_post_comments_position', array(
		'label'      => customize_options_language('Blog post comments position', 'Blog artikel positie reacties'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_post_comments_position',
		'type' => 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'))
	));

	$wp_customize->add_setting('blog_post_text_comments_none', array(
        'default'        => customize_options_language('Response', 'Reageer'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_text_comments_none', array(
        'label'      => customize_options_language('Text comments when no responses', 'Tekst bij reacties als er geen reacties zijn') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_text_comments_none'
    ));

	$wp_customize->add_setting('blog_post_text_comments_one', array(
        'default'        => customize_options_language('1 Response', '1 Reactie'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_text_comments_one', array(
        'label'      => customize_options_language('Text comments when 1 response', 'Tekst bij reacties als er 1 reactie is') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_text_comments_one'
    ));

	$wp_customize->add_setting('blog_post_text_comments_more', array(
        'default'        => customize_options_language("[num] Responses", "[num] Reacties"),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_text_comments_more', array(
        'label'      => customize_options_language('Text comments when 2 or more responses', 'Tekst bij reacties als er 2 of meer reacties zijn') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_text_comments_more'
    ));

	$wp_customize->add_setting('blog_post_seperator_post_details', array(
        'default'        => '|',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_seperator_post_details', array(
        'label'      => customize_options_language('Post details seperator', 'Artikel details scheidingsteken') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_seperator_post_details'
    ));

	$wp_customize->add_setting('blog_post_details_order_above_title', array(
        'default'        => 'author,category,date,comments'
    ));
    $wp_customize->add_control('blog_post_details_order_above_title', array(
        'label'      => customize_options_language('Choose the order of the post details (above title) with drag and drop', 'Kies de volgorde van de artikel details (boven de titel) met drag en drop') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_details_order_above_title'
    ));

	$wp_customize->add_setting('blog_post_details_order_below_title', array(
        'default'        => 'author,category,date,comments'
    ));
    $wp_customize->add_control('blog_post_details_order_below_title', array(
        'label'      => customize_options_language('Choose the order of the post details (below title) with drag and drop', 'Kies de volgorde van de artikel details (onder de titel) met drag en drop') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_details_order_below_title'
    ));

    $wp_customize->add_setting('blog_post_details_margin_top', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_details_margin_top', array(
        'label'      => customize_options_language('Blog post details (extra) margin top', 'Blog artikel details (extra) afstand boven') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_details_margin_top',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('blog_post_details_margin_bottom', array(
        'default'        => 0,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_details_margin_bottom', array(
        'label'      => customize_options_language('Blog post details (extra) margin onder', 'Blog artikel details (extra) afstand onder') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_details_margin_bottom',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('blog_show_post_images', array(
		'default'        => true
	));
	$wp_customize->add_control('blog_show_post_images', array(
		'label'      => customize_options_language('Show post images', 'Weergeef uitgelichte afbeeldingen'),
		'section'    => 'senhblog_blog2',
		'settings'   => 'blog_show_post_images',
		'type' => 'checkbox'
	));

	$wp_customize->add_setting('blog_featured_image_position', array(
        'default'        => 'above_title',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_featured_image_position', array(
        'label'      => customize_options_language('Position featured image', 'Positie uitgelichte afbeelding') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_featured_image_position',
		'type'		=> 'select',
		'choices' => array('above_title' => customize_options_language('Above title', 'Boven titel'), 'below_title' => customize_options_language('Below title', 'Onder titel'), 'at_first_line' => customize_options_language('At first line', 'Op de eerste regel'))
    ));

	$wp_customize->add_setting('blog_post_image_width', array(
        'default'        => '100',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_setting('blog_post_image_width_type', array(
        'default'        => '%',
        'transport'     => 'refresh'
    ));
    /*$wp_customize->add_control('blog_post_image_width', array(
        'label'      => customize_options_language('Post image width (use % or px)', 'Post afbeelding breedte (gebruik % of px') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_image_width'
    ));*/
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_image_width', array(
        'label'      => customize_options_language('Post image width', 'Uitgelichte afbeelding breedte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_image_width',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 100,
		'extra_select_name' => 'blog_post_image_width_type',
		'extra_select_choices' => array('%' => '%', 'px' => 'px')
    )));

    $wp_customize->add_setting('blog_post_image_height', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_image_height', array(
        'label'      => customize_options_language('Featured image height', 'Uitgelichte afbeelding hoogte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_image_height',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0,
		'extra_select_name' => 'content_image_width_type',
		'extra_select_choices' => array('%' => '%', 'px' => 'px'),
		'extra_select_default' => '%',
		'extra_select_disabled' => true
    )));

	$wp_customize->add_setting('blog_post_imagecontainer_maxheight', array(
        'default'        => '200',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_imagecontainer_maxheight', array(
        'label'      => customize_options_language('Post image max height', 'Uitgelichte afbeelding maximale hoogte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_imagecontainer_maxheight',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 200
    )));

	$wp_customize->add_setting('blog_post_image_zoomin', array(
        'default'        => true
    ));
    $wp_customize->add_control('blog_post_image_zoomin', array(
        'label'      => customize_options_language('Blog post image zoom in hover effect', 'Blog artikel afbeelding zoom in hover effect'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_image_zoomin',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_image_fade', array(
        'default'        => false
    ));
    $wp_customize->add_control('blog_post_image_fade', array(
        'label'      => customize_options_language('Blog post image fade-out hover effect', 'Blog artikel afbeelding vervaging hover effect'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_image_fade',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_show_description', array(
        'default'        => true
    ));
    $wp_customize->add_control('blog_post_show_description', array(
        'label'      => customize_options_language('Blog post show description', 'Blog artikel weergeef omschrijving'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_show_description',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting('blog_post_description_fontsize', array(
        'default'        => '14',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('blog_post_description_fontsize', array(
        'label'      => customize_options_language('Blog post description font size', 'Blog artikel omschrijving lettertype grootte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_description_fontsize',
		'type' => 'number'
    ));

	$wp_customize->add_setting('blog_post_show_readmore', array(
        'default'        => ''
    ));
    $wp_customize->add_control('blog_post_show_readmore', array(
        'label'      => customize_options_language('Blog post show readmore button', 'Blog artikel weergeef lees meer-knop'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_show_readmore',
		'type'	=> 'select',
		'choices' => array('button' => 'Weergeef een knop', 'anchor' => 'Weergeef een tekstlink', '' => 'Geen knop of tekstlink weergeven')
    ));

	$wp_customize->add_setting('blog_post_readmore_text', array(
        'default'        => customize_options_language('Read more', 'Naar artikel')
    ));
    $wp_customize->add_control('blog_post_readmore_text', array(
        'label'      => customize_options_language('Blog post readmore button text', 'Blog artikel lees meer-knop tekst') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_text'
    ));

	$wp_customize->add_setting('blog_post_readmore_style', array(
        'default'        => 'default'
    ));
    $wp_customize->add_control('blog_post_readmore_style', array(
        'label'      => customize_options_language('Blog post readmore button style', 'Blog artikel lees meer-knop stijl') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_style',
		'type'	=> 'select',
		'choices' => array('default' => 'Zelfde eigenschappen reactie-knop', 'custom' => 'Eigenschappen kiezen')
    ));

	$wp_customize->add_setting('blog_post_readmore_fontsize', array(
        'default'        => '14',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_readmore_fontsize', array(
        'label'      => customize_options_language('Blog post readmore button font size', 'Blog artikel lees meer-knop lettertype grootte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_fontsize',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'blog_post_readmore_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_readmore_backgroundcolor',
			array(
				'label'      => customize_options_language('Blog post readmore button backgrond color', 'Blog artikel lees meer-knop achtergrondkleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_readmore_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('blog_post_readmore_border_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_readmore_border_width', array(
        'label'      => customize_options_language('Blog post readmore button border width', 'Blog artikel lees meer-knop omlijning dikte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_border_width',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'blog_post_readmore_border_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_readmore_border_color',
			array(
				'label'      => customize_options_language('Blog post readmore button border color', 'Blog artikel lees meer-knop omlijning kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_readmore_border_color'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_post_readmore_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_readmore_fontcolor',
			array(
				'label'      => customize_options_language('Blog post readmore button font color', 'Blog artikel lees meer-knop lettertype kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_readmore_fontcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_post_readmore_hover_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_readmore_hover_fontcolor',
			array(
				'label'      => customize_options_language('Blog post readmore button hover font color', 'Blog artikel lees meer-knop hover lettertype kleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_readmore_hover_fontcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_post_readmore_hover_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_post_readmore_hover_backgroundcolor',
			array(
				'label'      => customize_options_language('Blog post readmore button hover background color', 'Blog artikel lees meer-knop hover achtergrondkleur') . ':',
				'section'    => 'senhblog_blog2',
				'settings'   => 'blog_post_readmore_hover_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('blog_post_readmore_padding_horizontal', array(
        'default'        => '12',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_readmore_padding_horizontal', array(
        'label'      => customize_options_language('Blog post readmore button padding horizontal', 'Blog artikel lees meer-knop afstand horizontaal') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_padding_horizontal',
		'type' => 'number'
    ));

	$wp_customize->add_setting('blog_post_readmore_padding_vertical', array(
        'default'        => '6',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('blog_post_readmore_padding_vertical', array(
        'label'      => customize_options_language('Blog post readmore button padding vertical', 'Blog artikel lees meer-knop afstand verticaal') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_readmore_padding_vertical',
		'type' => 'number'
    ));

    $wp_customize->add_setting('blog_post_video_width', array(
        'default'        => '550',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'blog_post_video_width', array(
        'label'      => customize_options_language('Video width', 'Video breedte') . ':',
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_video_width',
		'slider_min' => 0,
		'slider_max' => 1000,
		'default' => 550
    )));

    $wp_customize->add_setting('blog_post_video_dont_include_rel', array(
        'default'        => false
    ));
    $wp_customize->add_control('blog_post_video_dont_include_rel', array(
        'label'      => customize_options_language('Do not include related videos', 'Geen verwante videos tonen'),
        'section'    => 'senhblog_blog2',
        'settings'   => 'blog_post_video_dont_include_rel',
		'type'	=> 'checkbox'
    ));
}

add_action('customize_register', 'senhblog_blog3_customize_register');
function senhblog_blog3_customize_register($wp_customize) {

	require_once(get_template_directory() . '/lib/customizer/wp_slider_control.php');

    $wp_customize->add_section('senhblog_blog3', array(
        'title'    => customize_options_language('6c. Blog page bottom', '6c. Blog pagina onderkant'),
        'description' => '',
        'priority' => 125,
    ));

	$wp_customize->add_setting('blog_pagination_position', array(
        'default'        => 'below_content'
    ));
    $wp_customize->add_control('blog_pagination_position', array(
        'label'      => customize_options_language('Pagination position', 'Paginering positie') . ':',
        'section'    => 'senhblog_blog3',
        'settings'   => 'blog_pagination_position',
		'type'	=> 'select',
		'choices'  => array('below_content' => customize_options_language('Below content', 'Onder content'), 'below_sidebar' => customize_options_language('Below sidebar', 'Onder zijbar'))
    ));

	$wp_customize->add_setting('blog_pagination_position_alignment', array(
        'default'        => 'left'
    ));
    $wp_customize->add_control('blog_pagination_position_alignment', array(
        'label'      => customize_options_language('Pagination alignment', 'Paginering opstelling') . ':',
        'section'    => 'senhblog_blog3',
        'settings'   => 'blog_pagination_position_alignment',
		'type'	=> 'select',
		'choices'  => array('left' => customize_options_language('Left', 'Links'), 'right' => customize_options_language('Right', 'Rechts'), 'center' => customize_options_language('Centered', 'Gecentreerd'))
    ));

	$wp_customize->add_setting('blog_pagination_text_olderposts', array(
        'default'        => 'Oudere Artikelen',
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_pagination_text_olderposts', array(
        'label'      => customize_options_language('Text \'Older Posts\'', 'Tekst \'Oudere Artikelen\'') . ':',
        'section'    => 'senhblog_blog3',
        'settings'   => 'blog_pagination_text_olderposts'
    ));

	$wp_customize->add_setting('blog_pagination_range', array(
        'default'        => 4,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_pagination_range', array(
        'label'      => customize_options_language('Pagination range', 'Paginering limiet') . ':',
        'section'    => 'senhblog_blog3',
        'settings'   => 'blog_pagination_range',
		'type'		=> 'select',
		'choices' => array('1' => '1', '2' => '2', '3' => '3', '4' => '4', '4' => '4', '5' => '5', '6' => '6', '7' => '7', '8' => '8', '9' => '9', '10' => '10', '11' => '11', '12' => '12')
    ));

	$wp_customize->add_setting(
		'blog_pagination_background_buttons',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_pagination_background_buttons',
			array(
				'label'      => customize_options_language('Background pagination buttons', 'Achtergrond paginering knoppen') . ':',
				'section'    => 'senhblog_blog3',
				'settings'   => 'blog_pagination_background_buttons'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_pagination_background_buttons_hover',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_pagination_background_buttons_hover',
			array(
				'label'      => customize_options_language('Background pagination buttons on hover', 'Achtergrond paginering knoppen bij zweven (hover)') . ':',
				'section'    => 'senhblog_blog3',
				'settings'   => 'blog_pagination_background_buttons_hover'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_pagination_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_pagination_fontcolor',
			array(
				'label'      => customize_options_language('Pagination buttons font color', 'Paginering knoppen tekstkleur') . ':',
				'section'    => 'senhblog_blog3',
				'settings'   => 'blog_pagination_fontcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'blog_pagination_fontcolor_hover',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'blog_pagination_fontcolor_hover',
			array(
				'label'      => customize_options_language('Pagination buttons font color hover', 'Paginering knoppen tekstkleur bij zweven (hover)') . ':',
				'section'    => 'senhblog_blog3',
				'settings'   => 'blog_pagination_fontcolor_hover'
			)
		)
	);

	$wp_customize->add_setting('blog_pagination_margin', array(
        'default'        => 20,
        'transport'     => 'refresh'
    ));
    $wp_customize->add_control('blog_pagination_margin', array(
        'label'      => customize_options_language('Pagination margin (top and bottom)', 'Pagination margin (top and bottom)') . ':',
        'section'    => 'senhblog_blog3',
        'settings'   => 'blog_pagination_margin',
		'type'		=> 'number'
    ));

}
