<?php

add_filter('dynamic_post_date_metadata_icons', function($icons) {
	if (!get_theme_mod('blog_post_show_author', true)) {
		$icons = str_replace('author', '', $icons);
	}
	if (!get_theme_mod('blog_post_show_category', true)) {
		$icons = str_replace('category', '', $icons);
	}
	if (!get_theme_mod('blog_post_show_date', true)) {
		$icons = str_replace('date', '', $icons);
	}
	if (!get_theme_mod('content_show_nrof_comments', true)) {
		$icons = str_replace('comments', '', $icons);
	}
	return $icons;
});

// include plugin.pgp for function is_plugin_active
include_once ABSPATH . 'wp-admin/includes/plugin.php';
add_filter('senhblog_metadata_icons', function($args) {
	global $post;
	
	$content = $args[0];
	$icons = $args[1];
	if (in_array('avatar', $icons) && wp_user_has_avatar(get_the_author_meta('user_email', $post->post_author))) {
		$content = '<a href="' . get_author_posts_url(get_the_author_meta('ID', $post->post_author)) . '" class="post-avatar">' . str_replace('http:', '', get_avatar(get_the_author_meta('user_email', $post->post_author))) . '</a>' . $content;
	}
	return $content;
});


function senhblog_metadata_icons($icons = '', $class = '', $seperator = '|') {
	global $post;

	$icons = str_replace('date', 'date,mdate', $icons);
	$icons = apply_filters('dynamic_post_date_metadata_icons', $icons);

	$icons = explode(",", str_replace(' ', '', $icons));
	if (!is_array($icons) || count($icons) == 0)
		return;

	$result = array();
	for ($i = 0; $i < count($icons); $i++) {
		$icon = $icons[$i];
		switch ($icon) {
			case 'date':
				$result[] = '<span class="postdateicon">' . sprintf(
								sprintf( '<span class="entry-date" title="%1$s">%2$s</span>',
									esc_attr( get_the_time() ),
									get_the_date()
								)
							) . '</span>';
			break;
			case 'mdate':
				$result[] = '<span class="postdateicon">' . sprintf(
								sprintf( '<span class="entry-date" title="%1$s">%2$s</span>',
									esc_attr( get_the_modified_time() ),
									get_the_modified_date()
								)
							) . '</span>';
			break;		
			case 'author':
				$result[] = '<span class="postauthoricon">' . sprintf(__('<span class="%1$s">' . get_theme_mod('blog_post_author_prefix', 'Door:') . '</span> %2$s'),
								'author',
								sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
									get_author_posts_url( $post->post_author ), 
									'',
									get_author_name($post->post_author)
								)
						) . '</span>';
				break;
			case 'category':
				$categories = get_the_category_list(', ');
				if (strlen($categories) == 0)
					break;
				$result[] = '<span class="postcategoryicon">' . sprintf(__('<span class="%1$s">' . get_theme_mod('blog_post_category_prefix', 'Categorie:') . '</span> %2$s'), 'categories', get_the_category_list(', ')) . '</span>';
				break;
			case 'tag':
				$tags_list = get_the_tag_list('', ', ');
				if (!$tags_list)
					break;
				$result[] = '<span class="posttagicon">' . sprintf(__('<span class="%1$s">Tagged</span> %2$s'), 'tags', $tags_list) . '</span>';
				break;
			case 'comments':
				if (!comments_open())
					break;
				ob_start();
				comments_popup_link(get_theme_mod('blog_post_text_comments_none', 'Reageer'), get_theme_mod('blog_post_text_comments_one', '1 Reactie'), str_replace('[num]', '%', get_theme_mod('blog_post_text_comments_more', "[num] Reacties")));
				$html = ob_get_clean();
				if (strlen($html) && strpos($html, '"></a>') === false) {
					$result[] = '<span class="postcommentsicon">' . $html . '</span>';
				}
				break;
			case 'edit':
				if (!current_user_can('edit_post', $post->ID))
					break;
				ob_start();
				edit_post_link(__('Edit'), '');
				$result[] = '<span class="postediticon">' . ob_get_clean() . '</span>';
				break;
		}
	}
	$result = implode(' ' . $seperator . ' ', $result);
	echo '<span class="metadata-icons">' . apply_filters('senhblog_metadata_icons', array($result, $icons)) . '</span>';
}
