(function($) {

	$.customizevalchange = function(name, fn) {
		return $('[data-customize-setting-link="' + name + '"]').change(fn).trigger('change');
	};

	$.getcustomizecontrols = function(names) {
		var els = [];
		for (var i in names) {
			els.push('#customize-control-' + names[i]);
		}
		return $(els.join(', '));
	};

	$.fn.ophide = function() {
		return this.each(function() {
			if ($('#custom-style-' + $(this).attr('id')).length) {
				return;
			}
			$('head').append('<style id="custom-style-' + $(this).data('ophide', true).attr('id') + '">#' + $(this).attr('id') + ' {opacity:0;height:0px;display:none !important;}</style>');
		});
	};

	$.fn.opshow = function() {
		return this.each(function() {
			$('#custom-style-' + $(this).data('ophide', false).attr('id')).remove();
		});
	};

	$(window).load(function() {

		$('[data-customize-setting-link="socialbuttons_ssmb_installtext"]').hide();

		$('#customize-control-content_show_gravatar').append('<div><a href="/wp-admin/options-discussion.php" target="_blank">' + ($('[data-customize-setting-link="general_options_language"]').val() == 'en' ? 'More gravatar options' : 'Meer gravatar opties') + '</a></div>');

		$('#customize-control-socialbuttons_order input').css('position', 'absolute').css('height', 0).css('opacity', 0);
		
		var html = '', socials = ['facebook', 'twitter', 'googleplus', 'mail', 'linkedin', 'pinterest', 'instagram', 'rss', 'youtube'];
		for (var i in socials) {
			html += '<div data-social="' + socials[i] + '" style="float:left;width:30px;height:30px"><img src="/wp-content/themes/senhblog/img/social-buttons/button-' + socials[i] + '-zoom-50.gif" width="30" /></div>';
		}
		$('<div class="customize-control customize-control-text"><div id="social-buttons-sortable" style="height:70px;width:100%">' + html + '</div></div>').appendTo($('#customize-control-socialbuttons_order'));
		$("#social-buttons-sortable").sortable({update:function(e,ui) {
				var order = $(this).sortable("toArray", {attribute: 'data-social'}).join();
				$('[data-customize-setting-link="socialbuttons_order"]').val(order).trigger('change');
			}});
		$("#social-buttons-sortable").disableSelection();
		for (var i in socials) {
			$('[data-customize-setting-link="socialbuttons_url_' + socials[i] + '"]').data('social', socials[i]).change(function() {
				$('[data-social="' + $(this).data('social') + '"]')[$(this).val().length > 0 ? 'show' : 'hide']();
				$('[data-customize-setting-link="socialbuttons_' + $(this).data('social') + '_show_stats"], [data-customize-setting-link="socialbuttons_' + $(this).data('social') + '_counter"]').closest('li')[$(this).val().length > 0 ? 'opshow' : 'ophide']();
			}).trigger('change');
		}

		$('#customize-control-blog_post_details_order_above_title input').css('position', 'absolute').css('height', 0).css('opacity', 0);
		var html = '', post_details = ($('[data-customize-setting-link="blog_post_details_order_above_title"]').val() + '').split(',');
		for (var i in post_details) {
			html += '<div data-postdetail="' + post_details[i] + '" style="float:left;background:#efefef;border:1px solid #cdcdcd;padding: 3px;">' + post_details[i] + '</div>';
		}
		$('<div class="customize-control customize-control-text"><div id="postdetails-above-title-sortable" style="width:100%">' + html + '</div></div>').appendTo($('#customize-control-blog_post_details_order_above_title'));
		$("#postdetails-above-title-sortable").sortable({update:function(e,ui) {
			var order = $(this).sortable("toArray", {attribute: 'data-postdetail'}).join();
			$('[data-customize-setting-link="blog_post_details_order_above_title"]').val(order).trigger('change');
		}});

		$('#customize-control-blog_post_details_order_below_title input').css('position', 'absolute').css('height', 0).css('opacity', 0);
		var html = '', post_details = ($('[data-customize-setting-link="blog_post_details_order_below_title"]').val() + '').split(',');
		for (var i in post_details) {
			html += '<div data-postdetail="' + post_details[i] + '" style="float:left;background:#efefef;border:1px solid #cdcdcd;padding: 3px;">' + post_details[i] + '</div>';
		}
		$('<div class="customize-control customize-control-text"><div id="postdetails-below-title-sortable" style="width:100%">' + html + '</div></div>').appendTo($('#customize-control-blog_post_details_order_below_title'));
		$("#postdetails-below-title-sortable").sortable({update:function(e,ui) {
			var order = $(this).sortable("toArray", {attribute: 'data-postdetail'}).join();
			$('[data-customize-setting-link="blog_post_details_order_below_title"]').val(order).trigger('change');
		}});
		
		$.customizevalchange('mainmenu_show_mobile', function() {
			$('#customize-control-mainmenu_togglebutton_position, #customize-control-mainmenu_display_mobile, #customize-control-mainmenu_togglebutton_color, #customize-control-mainmenu_togglebutton_backgroundcolor')[$(this).val() != 'only_toggle' ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('layout_submenu_enabled', function() {
			$('#accordion-section-senhblog_submenu')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('layout_extramenu_enabled', function() {
			$('#customize-control-header_extra_menu_position, #customize-control-header_extra_menu_seperator, #customize-control-header_extra_menu_fontcolor, #customize-control-header_extra_menu_fontfamily, #customize-control-header_extra_menu_fontsize, #customize-control-header_extra_menu_margintop, #customize-control-header_extra_menu_marginright')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('mainmenu_enable_searchbox', function() {
			$('#accordion-section-senhblog_search')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_show_author', function() {
			$.getcustomizecontrols(['blog_post_author_position', 'blog_post_author_prefix'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_show_category', function() {
			$.getcustomizecontrols(['blog_post_category_position', 'blog_post_category_prefix'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_show_date', function() {
			$.getcustomizecontrols(['blog_post_date_position'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_show_comments', function() {
			$.getcustomizecontrols(['blog_post_comments_position', 'blog_post_text_comments_none', 'blog_post_text_comments_one', 'blog_post_text_comments_more'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_show_post_images', function() {
			$.getcustomizecontrols(['blog_featured_image_position', 'blog_post_image_width', 'blog_post_imagecontainer_maxheight', 'blog_post_image_zoomin'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.each(['author', 'category', 'date', 'comments'], function(k, v) {
			$.customizevalchange('blog_post_' + v + '_position', function() {
				if ($(this).val() == 'above_title') {
					$('#postdetails-below-title-sortable [data-postdetail="' + v + '"]').hide();
					$('#postdetails-above-title-sortable [data-postdetail="' + v + '"]').show();
				} else {
					$('#postdetails-below-title-sortable [data-postdetail="' + v + '"]').show();
					$('#postdetails-above-title-sortable [data-postdetail="' + v + '"]').hide();
				}
			});
		});

		$.customizevalchange('blog_post_show_description', function() {
			$.getcustomizecontrols(['blog_post_description_fontsize'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_show_readmore', function() {
			$.getcustomizecontrols(['blog_post_readmore_text', 'blog_post_readmore_style'])[!$(this).val() ? 'ophide' : 'opshow']();

			$.getcustomizecontrols(['blog_post_readmore_style'])[$(this).val() != 'button' ? 'ophide' : 'opshow']();
			
			var a = $.getcustomizecontrols(['blog_post_readmore_style']);
			var vis = a.find('select').first().val() == 'custom' && !$(this).data('ophide') && $(this).val() == 'button';
			$.getcustomizecontrols(['blog_post_readmore_fontsize', 'blog_post_readmore_fontcolor', 'blog_post_readmore_backgroundcolor', 'blog_post_readmore_hover_fontcolor', 'blog_post_readmore_hover_backgroundcolor', 'blog_post_readmore_padding_horizontal', 'blog_post_readmore_padding_vertical', 'blog_post_readmore_border_width', 'blog_post_readmore_border_color'])[!vis ? 'ophide' : 'opshow']();

			$.getcustomizecontrols(['blog_post_readmore_fontsize', 'blog_post_readmore_fontcolor', 'blog_post_readmore_hover_fontcolor'])[!$(this).val() ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_post_readmore_style', function() {
			var a = $.getcustomizecontrols(['blog_post_show_readmore']);

			var vis = $(this).val() == 'custom' && $(a).find('select').first().val() == 'button';
			$.getcustomizecontrols(['blog_post_readmore_fontsize', 'blog_post_readmore_fontcolor', 'blog_post_readmore_backgroundcolor', 'blog_post_readmore_hover_fontcolor', 'blog_post_readmore_hover_backgroundcolor', 'blog_post_readmore_padding_horizontal', 'blog_post_readmore_padding_vertical', 'blog_post_readmore_border_width', 'blog_post_readmore_border_color'])[!vis ? 'ophide' : 'opshow']();
			
			$.getcustomizecontrols(['blog_post_readmore_fontsize', 'blog_post_readmore_fontcolor', 'blog_post_readmore_hover_fontcolor'])[!$(a).find('select').first().val() ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('mainmenu_enable_seperator', function() {
			$.getcustomizecontrols(['mainmenu_seperator_width', 'mainmenu_seperator_color'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('mainmenu_enable_homebutton', function() {
			$.getcustomizecontrols(['mainmenu_homebutton_size'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('submenu_enable_seperator', function() {
			$.getcustomizecontrols(['submenu_seperator_width', 'submenu_seperator_color'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('mainmenu_show_mobile', function() {
			$.getcustomizecontrols(['searchbox_visible_mobile']).find('[value="mainmenu"]')[$(this).val() != 'only_toggle' ? 'hide' : 'show']();
		});

		$.customizevalchange('searchbox_show_on_toggle', function() {
			$.getcustomizecontrols(['searchbox_searchtoggle_color'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('searchbox_visible_mobile', function() {
			$.getcustomizecontrols(['searchbox_collapsed_on_mobile'])[$(this).val() != 'mainmenu' ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('content_show_biography', function() {
			$.getcustomizecontrols(['content_show_biography_avatar_size', 'content_show_biography_title_fontsize', 'content_show_biography_title_fontcolor', 'content_show_biography_borderwidth', 'content_show_biography_bordercolor'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('comments_response_button_style', function() {
			var vis = $(this).val() == 'custom';
			$.getcustomizecontrols(['comments_response_button_fontsize', 'comments_response_button_fontcolor', 'comments_response_button_backgroundcolor', 'comments_response_button_hover_fontcolor', 'comments_response_button_hover_backgroundcolor', 'comments_response_button_padding_horizontal', 'comments_response_button_padding_vertical', 'comments_response_button_border_width', 'comments_response_button_border_color'])[!vis ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('footer_widgets_enabled', function() {
			$.getcustomizecontrols(['footer_widgets_distribution', 'footer_widgets_fullwidth', 'footer_widgets_backgroundcolor', 'footer_widgets_fontcolor', 'footer_widgets_bulletpointscolor'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('footer_menu_enabled', function() {
			$.getcustomizecontrols(['footer_menu_alignment', 'footer_menu_backgroundcolor', 'footer_menu_seperator', 'footer_menu_fontcolor', 'footer_menu_fontsize'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('footer_copyright_enabled', function() {
			$.getcustomizecontrols(['footer_copyright_alignment', 'footer_copyright_backgroundcolor', 'footer_copyright_text'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('content_featured_image_visible', function() {
			$.getcustomizecontrols(['content_image_position', 'content_image_alignment', 'content_image_width', 'content_image_maxheight'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('general_hide_other_customize_tabs', function() {
			var fn = $(this).is(':checked') ? 'ophide' : 'opshow';
			$('.accordion-section').each(function() {
				var id = $(this).attr('id');
				if (!id) return;
				if (id.split('senhblog').length == 2) {
					$(this).opshow();
				} else {
					$(this)[fn]();
				}
			});
		//	$('#accordion-panel-widgets, #accordion-section-senhblog_promotionwidget').opshow();
		//	$('#accordion-section-title_tagline, #accordion-section-colors, #accordion-panel-nav_menus, #accordion-section-static_front_page, #accordion-panel-widgets')[$(this).is(':checked') ? 'ophide' : 'opshow']();
		//	$('#accordion-section-senhblog_general .customize-section-back').click();
		});


		$.customizevalchange('layout_sidebar_visibility', function() {
			$.getcustomizecontrols(['layout_sidebar_position', 'layout_sidebar_width'])[$(this).val() == 'hide_sidebar' ? 'ophide' : 'opshow']();
		});	

		$.customizevalchange('layout_enable_all_border', function() {
			$.getcustomizecontrols(['layout_all_border_width', 'layout_all_border_color', 'layout_all_shadow'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('layout_enable_contentborder', function() {
			$.getcustomizecontrols(['layout_contentborder_width', 'layout_contentborder_color'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_title_use_yoast_meta_title', function() {
			$.getcustomizecontrols(['blogheader_title'])[$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('blog_title_use_yoast_meta_description', function() {
			$.getcustomizecontrols(['blogheader_description'])[$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('header_allow_scroll', function() {
			$.getcustomizecontrols(['header_affix_height'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('mainmenu_allow_scroll', function() {
			$.getcustomizecontrols(['mainmenu_scrolling_fontsize'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('submenu_allow_scroll', function() {
			$.getcustomizecontrols(['submenu_scrolling_fontsize'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('layout_boxed_style', function() {
			$.getcustomizecontrols(['layout_boxed_border_width', 'layout_boxed_border_color'])[$(this).val() == 'border' ? 'opshow' : 'ophide']();
			$.getcustomizecontrols(['layout_boxed_shadow_color'])[$(this).val() == 'shadow' ? 'opshow' : 'ophide']();
			$.getcustomizecontrols(['layout_boxed_glow_color', 'layout_boxed_glow_thickness'])[$(this).val() == 'glow' ? 'opshow' : 'ophide']();
		});	

		


		
		

		$('[data-customize-setting-link="general_non_option"]').hide();

		var container_show_options = $('#customize-control-general_show_color_options, #customize-control-general_show_font_options, #customize-control-general_show_layout_options, #customize-control-general_show_text_options');
		container_show_options.css('margin-top', -20);
		container_show_options.find('input').change(function(e) {
		});
		$('#customize-control-general_select_deselect_all').css('margin-top', -20);

		$('[data-customize-setting-link="general_select_deselect_all"]').change(function() {
			if ($(this).is(':checked')) {
				container_show_options.find('input').prop('checked', true).trigger('change');
			} else {
				container_show_options.find('input').prop('checked', false).trigger('change');
			}
		});

		$.customizevalchange('general_show_color_options', function() {
			$('[id*=color]:visible, [id*=background]:visible, [id*=layout_all_shadow]:visible')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
			container_show_options.opshow();
		});

		$.customizevalchange('general_show_font_options', function() {
			$('[id*=fontsize], [id*=fontweight], [id*=underline], [id*=uppercase], [id*=fontfamily], [id*=italic]')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('general_show_layout_options', function() {
			$('#accordion-section-senhblog_layout')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
		});

		$.customizevalchange('general_show_text_options', function() {
			$('[id*=text]')[!$(this).is(':checked') ? 'ophide' : 'opshow']();
			$.getcustomizecontrols(['footer_menu_seperator', 'comments_response_on_text', 'comments_response_button_text', 'comments_before_notes', 'comments_give_response_text', 'search_placeholder', 'header_extra_menu_seperator', 'blog_pagination_text_olderposts', 'socialbuttons_preline', 'general_footer_html', 'general_head_html'])[!$(this).is(':checked') ? 'ophide' : 'opshow']();
			container_show_options.opshow();
		});


		$('#customize-control-general_hide_other_customize_tabs').append('<div style="margin-top:15px"><a href="?reset_customized_settings=true" class="button button-default" onclick="if (!confirm(\'Are you sure? (Weet je het zeker?)\')) return false;">Reset settings</a></div>');

		$('#customize-control-importexport_non_option input, #customize-control-importexport_non_option2 input').hide();
		$('#customize-control-importexport_non_option').append('<a href="?download_customized_settings=true" class="button button-default">Download XML-file</a>');
		$('#customize-control-importexport_non_option2').append('<form action="" method="post" enctype="multipart/form-data"><input type="file" name="customizedoptions" id="customizedoptions" onchange="this.parentNode.submit()" style="opacity:0;position:absolute;width:1px;height:1px;"><a id="upload-xml-file-button" href="javascript:;" onclick="jQuery(\'#customizedoptions\').click()" class="button button-default">Upload XML-file</a></form>');


		var allcolors = [], colorstr = '';
		$('.wp-color-picker').each(function() {
			if (!$(this).val()) return;
			if (colorstr.indexOf($(this).val()) != -1) return;
			colorstr += $(this).val();
			allcolors[$(this).val()]++;
		});
		$(document).on('mousedown', '.wp-color-result', function(e) {
			if ($(this).data('colors-extended')) return;
			$(this).data('colors-extended', true);

			$(this).parent().find('.wp-picker-holder .iris-picker').height(300);

			var html = '';
			for (var i in allcolors) {
				html += '<a onclick="$(this).closest(\'.wp-color-picker\').val($(this).data(\'color\');" data-color="' + i + '" style="margin-top:5px;background-color: ' + i + '; height: 19.5784px; width: 19.5784px; margin-left: 3.6px;" class="iris-palette" tabindex="0"></a>';
			}

			var $pc = $(this).parent().find('.wp-picker-holder .iris-palette-container');
			$pc.css('bottom', $pc.outerHeight()+10).append('<hr style="margin-top:25px;"><div style="clear:both;">Reeds gekozen kleuren:</div>' + html);
		});

		
		var dropZone = document.getElementById('upload-xml-file-button');
		
		if (dropZone) {
	
			// Optional.   Show the copy icon when dragging over.  Seems to only work for chrome.
			dropZone.addEventListener('dragover', function(e) {
				e.stopPropagation();
				e.preventDefault();
				e.dataTransfer.dropEffect = 'copy';
			});
	
			// Get file data on drop
			dropZone.addEventListener('drop', function(e) {
				$(dropZone).parent().append('<p><b>Bestand wordt geladen...</b></p>');
				$(dropZone).hide();
	
				e.stopPropagation();
				e.preventDefault();
				var files = e.dataTransfer.files; // Array of all files
				for (var i=0, file; file=files[i]; i++) {
					if (file.type.match(/xml.*/)) {
						var reader = new FileReader();
						reader.onload = function(e2) { // finished reading file data.
							$('<form method="POST" action=""><input type="text" name="customizedoptions-dragdrop" value="' + e2.target.result + '"></form>').appendTo('body').submit();
						}
						reader.readAsDataURL(file); // start reading the file data.
			}   }   });
			
		}
		
	});
})(jQuery);