<?php

function senhblog_load_lib_files() {
    foreach (glob(dirname( __FILE__ ) . '/lib/*.php') as $file) include $file;
}

add_action( 'after_setup_theme', 'my_theme_setup' );
function my_theme_setup(){
    load_theme_textdomain( 'senhtheme', get_template_directory() . '/languages' );
}

if( function_exists('acf_add_options_page') ) {

    $option_page = acf_add_options_page(array(
    'page_title'     => 'Facebook Pixel ID',
    'menu_title'     => 'Facebook Pixel ID',
    'menu_slug'     => 'facebook_pixel_id'
    ));

    acf_add_options_page([
        'page_title' => 'Website opties',
        'menu_title' => 'Website opties',
        'menu_slug' => 'website_opties'
    ]);

}

senhblog_load_lib_files();
function theme_slug_filter_wp_title( $title ) {
 if ( is_404() ) {
    $title = 'ADD 404 TEXT HERE';
 }
return $title;
}
add_filter( 'wp_title', 'theme_slug_filter_wp_title' );

// NOTE: THE CODE TO COPY/PASTE STARTS *BELOW* THIS LINE
// Setting a custom timeout value for cURL. Using a high value for priority to ensure the function runs after any other added to the same action hook.
add_action('http_api_curl', 'sar_custom_curl_timeout', 9999, 1);
function sar_custom_curl_timeout( $handle ){
	curl_setopt( $handle, CURLOPT_CONNECTTIMEOUT, 30 ); // 30 seconds. Too much for production, only for testing.
	curl_setopt( $handle, CURLOPT_TIMEOUT, 30 ); // 30 seconds. Too much for production, only for testing.
}
// Setting custom timeout for the HTTP request
add_filter( 'http_request_timeout', 'sar_custom_http_request_timeout', 9999 );
function sar_custom_http_request_timeout( $timeout_value ) {
	return 30; // 30 seconds. Too much for production, only for testing.
}
// Setting custom timeout in HTTP request args
add_filter('http_request_args', 'sar_custom_http_request_args', 9999, 1);
function sar_custom_http_request_args( $r ){
	$r['timeout'] = 30; // 30 seconds. Too much for production, only for testing.
	return $r;
}
wp_oembed_add_provider( '/https?:\/\/(.+)?(wistia.com|wi.st)\/(medias|embed)\/.*/', 'http://fast.wistia.com/oembed', true);
// Downgrade to jQuery given version

    add_filter( 'comment_form_default_fields', 'youruniqueprefix_modify_comment_author_email_url_labels' );
    function youruniqueprefix_modify_comment_author_email_url_labels( $fields ) {
        $commenter = wp_get_current_commenter();
        $req = get_option( 'require_name_email' );
        $aria_req = ( $req ? " aria-required='true'" : '' );
        $args = wp_parse_args( $args );
        if ( ! isset( $args['format'] ) )
            $args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
        $html5 = 'html5' === $args['format'];
        $fields = array(
                        'author' => '<p class="comment-form-author">' . ' <label for="author">' . __( 'Naam', 'senhtheme' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                        '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
                        'email' => '<p class="comment-form-email"> <label for="email">' . __( 'E-mail', 'senhtheme' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                        '<input id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></p>',

                        );
        return $fields;
    }

//how about contact form 7?
// you could check various different setups to see if the contact form 7 is on singular
	/*if( is_singular() ) {
    	$post = get_post();
    	if( has_shortcode($post->post_content, 'contact-form-7') ) {
        	$check_cf7 = true;
    	}
    } //false
    if( !$check_cf7 ) {
        wp_dequeue_script( 'contact-form-7' );
        wp_dequeue_style( 'contact-form-7' );
    }*/
function rankya_contactform7check_dequeue() {
    //set to false so that you have something to check against
	$check_cf7 = false;
    // if its page named 'contact' then set to true
	// if your contact form 7 is on page named 'contact-us'
	// then change below accordingly
	if( is_page('gtg')) {
        	$check_cf7 = true;
    }
	//so therefore dequeue only if is false
    if( !$check_cf7 ) {
        wp_dequeue_script( 'contact-form-7' );
        wp_dequeue_style( 'contact-form-7' );
    }
}
add_action( 'wp_enqueue_scripts', 'rankya_contactform7check_dequeue', 77 );

write_customize_css_to_file();

function write_customize_css_to_file() {
    ob_start();

    senhblog_customize_css();

    $content = ob_get_contents();

    ob_clean();

    $path = get_template_directory() . '/custom.css';

    $file = fopen($path, 'w');
    fwrite($file, $content);
}
