<?php

function senh_get_theme_mod($key, $default = false) {
    $result = get_theme_mod($key, $default);

    if (empty($result)) {
        return $default;
    }

    return $result;
}

add_action('wp_ajax_customize_css', 'dynaminc_css');
add_action('wp_ajax_nopriv_customize_css', 'dynaminc_css');
function dynaminc_css() {
	header('Content-type: text/css');
	senhblog_customize_css();
	die();
}

add_action('wp_enqueue_scripts', function() {
	if (!current_user_can('manage_options')) {
		//wp_enqueue_style('customize', admin_url('admin-ajax.php').'?action=customize_css', array(), '1.0.1', 'all');

		$randomInt = rand(0, 9999999);
		$randomInt2 = rand(0, 9999999);
//        wp_enqueue_style('customize', get_template_directory_uri() . '/custom.css', false, "{$randomInt}.{$randomInt2}.0");
	}
	wp_dequeue_style('font-awesome');
	wp_enqueue_style('font-awesome-sh', get_template_directory_uri() . '/fontawesome/font-awesome.min.css', array(), '4.5.0');
}, 1000);

function senhtheme_pagecustom_css() {
	?>
	<style>
	.container {
		width: <?php echo get_theme_mod('layout_container_width', '1150'); ?>px;
	}
	</style>
	<?php
}

add_action('wp_head', function() {
	senhtheme_pagecustom_css();

	if (!current_user_can('manage_options')) {
//		return;
	}
?>
<style><?php senhblog_customize_css(); ?>
<?php
});

function senhblog_customize_css() {
	global $amps;


	$themefonts = senhblog_get_themefonts_array();
	
	$blog_postsnippet_padding = senh_get_theme_mod('blog_postsnippet_padding', 10);

	$layout_has_full_background = (get_theme_mod('layout_background_content') == senh_get_theme_mod('layout_background_content_sides')) != '';
	$content_shadow = senh_get_theme_mod('content_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'));

?>
	.container {
		width: <?php echo senh_get_theme_mod('layout_container_width', '1150'); ?>px;
		max-width: 100%;
		margin-left: auto;
		margin-right: auto;
	}
	body {
		background-color: <?php echo senh_get_theme_mod('layout_background_content_sides', '#ffffff'); ?>;
	}
	main > .container > .row {
		background-color: <?php echo senh_get_theme_mod('layout_background_content', '#ffffff'); ?>;
	}




	body.single .main-content-inner,
	body.page .main-content-inner,
	#author-infobox,
	#breadcrumbs {
		background-color: <?php echo senh_get_theme_mod('content_background_color', 'transparent'); ?>;
	}


	/*.main-content {
		background-color: <?php echo senh_get_theme_mod('content_background_color', 'transparent'); ?>;
	}*/

	.sidebar-right {
		float: <?php echo senh_get_theme_mod('layout_sidebar_position', 'right'); ?>;
		max-width: <?php echo senh_get_theme_mod('layout_sidebar_width', '300'); ?>px;
	}
	.sidebar-section {
		max-width: <?php echo senh_get_theme_mod('layout_sidebar_width', '300'); ?>px;
		margin: 0 auto;
	}

	.post-content a:link,
	.post-content a:active,
	.post-content a:focus,
	.post-content a:visited,
	.post-content a:hover,

	.page-content a:link,
	.page-content a:active,
	.page-content a:focus,
	.page-content a:visited,
	.page-content a:hover,

	#author-infobox a:link,
	#author-infobox a:active,
	#author-infobox a:focus,
	#author-infobox a:visited,
	#author-infobox a:hover {
		<?php if (get_theme_mod('content_link_color')) { ?>
		color: <?php echo senh_get_theme_mod('content_link_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('content_link_underlined')) { ?>
			text-decoration: underline;
		<?php } else { ?>
			text-decoration: none;
		<?php } ?>
	}

	.post-content a:hover,

	.page-content a:hover,

	#author-infobox a:hover {
		<?php if (get_theme_mod('content_link_hover_color')) { ?>
		color: <?php echo senh_get_theme_mod('content_link_hover_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('content_link_hover_underlined')) { ?>
			text-decoration: underline;
		<?php } else { ?>
			text-decoration: none;
		<?php } ?>
	}

	.home-post {
		margin-bottom: <?php echo senh_get_theme_mod('blog_marginbottom_posts', '50'); ?>px;
	<?php if (get_theme_mod('blog_num_posts_row', 2) > 1 && ($margin = senh_get_theme_mod('blog_marginbetween_posts'))) { ?>
		margin-left: <?php echo $margin/2; ?>px;
		margin-right: <?php echo $margin/2; ?>px;
	<?php } ?>
	}

	.home-post .home-post-cover {
		<?php if ($width = senh_get_theme_mod('blog_post_image_width')) { ?>
		width: <?php echo $width . senh_get_theme_mod('blog_post_image_width_type', '%'); ?>;
		text-align: left;
		height: <?php echo senh_get_theme_mod('blog_post_image_height') == 0 ? 'auto' : senh_get_theme_mod('blog_post_image_height') . senh_get_theme_mod('blog_post_image_width_type', '%'); ?>;
		<?php }?>
		max-height: <?php echo senh_get_theme_mod('blog_post_imagecontainer_maxheight', 200); ?>px;
	}

	<?php if (get_theme_mod('content_border_color')) { ?>
	.pagination > li > a {
		border-color: <?php echo senh_get_theme_mod('content_border_color'); ?>;
	}
	<?php } ?>

	.pagination-container {
		margin: <?php echo senh_get_theme_mod('blog_pagination_margin', 20); ?>px 0px;
	}

	.pagination > .active > a:hover,
	.pagination > li > a:link,
	.pagination > li > a:hover,
	.pagination > li > a:visited {
		color: <?php echo senh_get_theme_mod('blog_pagination_fontcolor') ?: senh_get_theme_mod('content_link_hover_color', 'inherit'); ?>;
		text-decoration: none;
	}
	.pagination > .active > a:hover,
	.pagination > li > a:hover,
	.pagination > li.active > a {
		color: <?php echo senh_get_theme_mod('blog_pagination_fontcolor_hover') ?: senh_get_theme_mod('content_link_color', 'inherit'); ?>;
		text-decoration: none;
	}
	<?php if (get_theme_mod('blog_pagination_background_buttons', '')) { ?>
	.pagination > li > a,
	.pagination > li > a:active,
	.pagination > li > a:focus,
	.pagination > li > a:hover,
	.pagination > .active > a,
	.pagination > .active > a:hover,
	.pagination > .active > a:active,
	.pagination > .active > a:focus {
		background-color: <?php echo senh_get_theme_mod('blog_pagination_background_buttons') ?: 'transparent'; ?>;
	}
	<?php } ?>
	<?php if (get_theme_mod('blog_pagination_background_buttons_hover', '')) { ?>
	.pagination > li > a:hover,
	.pagination > .active > a,
	.pagination > .active > a:hover,
	.pagination > .active > a:active,
	.pagination > .active > a:focus {
		background-color: <?php echo senh_get_theme_mod('blog_pagination_background_buttons_hover') ?: 'transparent'; ?>;
	}
	<?php } ?>

<?php if (!isset($amps)) { ?>

	<?php if (get_theme_mod('header_fillwidth')) { ?>
	header > .container {
		max-width: none;
		width: 100%;
	}
	<?php } ?>
	.header-container<?php if (get_theme_mod('layout_fullwidth_header_footer', true)) { ?>-row<?php } ?> {
		<?php if (get_theme_mod('header_background')) { ?>
		background-color: <?php echo senh_get_theme_mod('header_background'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('header_background_image')) { ?>
		background: url(<?php echo senhblog_parse_https(get_theme_mod('header_background_image')); ?>) <?php echo senh_get_theme_mod('header_background_image_atts', 'center center'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('header_background_image_cover')) { ?>
		background-size: cover;
		<?php } ?>
	}
	header .header-image {
		margin-top: <?php echo senh_get_theme_mod('header_image_margin_top'); ?>px;
		margin-bottom: <?php echo senh_get_theme_mod('header_image_margin_bottom'); ?>px;
		margin-left: <?php echo senh_get_theme_mod('header_image_margin_left'); ?>px;
		max-height: <?php echo senh_get_theme_mod('header_height', 100); ?>px;
		width: auto;
	}



	<?php if (!get_theme_mod('layout_fullwidth_header_footer', true)) { ?>
	header.affix {
		width: <?php echo senh_get_theme_mod('layout_container_width', '1150'); ?>px;
		max-width: 100%;
		margin-left: auto;
		margin-right: auto;
		left: auto;
	}
	<?php } ?>

	<?php if (get_theme_mod('layout_fullwidth_header_footer', true)) { ?>
	/*.header-container-row {
		margin: 0px;
	}*/
	<?php } ?>

	<?php if (!get_theme_mod('header_allow_scroll')) { ?>
	header.affix .header-image {
		display: none;
	}
	header.affix .header-container-row {
		height: 0px !important;
		padding: 0px !important;
		display: none;
	}
	<?php } else { ?>
	header.affix .header-image {
		max-height: <?php echo (get_theme_mod('header_affix_height', 100)/100)*get_theme_mod('header_height', 100); ?>px;
	}
	<?php } ?>


	<?php if (!get_theme_mod('mainmenu_allow_scroll')) { ?>
	header.affix #navbar-header-primary {
		display: none;
	}
	<?php } ?>
	<?php if (!get_theme_mod('submenu_allow_scroll')) { ?>
	header.affix #navbar-header-secondary {
		display: none;
	}
	<?php } ?>


	.navbar-header-extra {
		right: 0px;
	}
	.navbar-header-extra .nav > li::before {
		content: "<?php echo senh_get_theme_mod('header_extra_menu_seperator'); ?>";
		color: <?php echo senh_get_theme_mod('header_extra_menu_fontcolor'); ?> !important;
	}
	.navbar-header-extra .nav > li {
		font-family: <?php echo isset($themefonts[get_theme_mod('header_extra_menu_fontfamily')]) && !empty($themefonts[get_theme_mod('header_extra_menu_fontfamily')]) ? $themefonts[get_theme_mod('header_extra_menu_fontfamily')] : ''; ?>;
		font-size: <?php echo senh_get_theme_mod('header_extra_menu_fontsize'); ?>px;
	}
	.navbar-header-extra .nav > li > a,
	.navbar-header-extra .nav > li > a:hover,
	.navbar-header-extra .nav > li > a:active,
	.navbar-header-extra .nav > li > a:visited,
	.navbar-header-extra .nav > li > a:focus {
		color: <?php echo senh_get_theme_mod('header_extra_menu_fontcolor'); ?> !important;
		background: none;
	}
	.navbar-header-extra {
		margin-top: <?php echo senh_get_theme_mod('header_extra_menu_margintop'); ?>px;
		margin-right: <?php echo senh_get_theme_mod('header_extra_menu_marginright'); ?>px;
	}

	header.affix .navbar-header-extra .nav > li > a {
		<?php if (get_theme_mod('header_extra_menu_scrolling_fontsize') !== false && senh_get_theme_mod('header_extra_menu_fontsize', 13) !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('header_extra_menu_fontsize', 13)/100*get_theme_mod('header_extra_menu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}


	<?php do_action('senhtheme_customize_css'); ?>



	<?php if ($content_shadow) { ?>
	/*body.blog .blog-header,*/
	body.archive .blog-header {
		box-shadow: 2px 2px 5px <?php echo $content_shadow; ?>;
		padding: 15px;
		background-color: <?php echo senh_get_theme_mod('content_background_color', 'transparent'); ?>;
		margin-bottom: 30px;
		margin-left: 15px;
		margin-right: 15px;
	}
	/*body.blog .blog-description,*/
	body.archive .blog-description {
		margin-bottom: 0px;
	}
	<?php } ?>
	body.archive .blog-header {
		overflow: hidden;
		padding-top: <?php echo senh_get_theme_mod('blogheader_padding_top', 15); ?>px;
		padding-bottom: <?php echo senh_get_theme_mod('blogheader_padding_bottom', 15); ?>px;
	}


	<?php if (get_theme_mod('mainmenu_toggle_icon')) { ?>
	#navbar-header-primary .menu-item-has-children > a:after {
		content: "▾";
	}
	<?php } ?>





	<?php if (get_theme_mod('mainmenu_alignment') == 'right') { ?>
	#navbar-header-primary .nav {
		float: right;
	}
	<?php } else if (get_theme_mod('mainmenu_alignment') == 'center') { ?>
	#navbar-header-primary > .container {
		text-align: center;
		height: <?php echo senh_get_theme_mod('mainmenu_height', 40); ?>px;
	}
	#navbar-nav-header-primary {
		display: inline-block;
	}
	<?php } ?>

<?php } ?>

	#navbar-header-primary {
		<?php if (get_theme_mod('mainmenu_color')) { ?>
		background-color: <?php echo senh_get_theme_mod('mainmenu_color'); ?>;
		<?php } ?>
		border-bottom: <?php echo senh_get_theme_mod('mainmenu_border_bottom_width', '0'); ?>px solid <?php echo senh_get_theme_mod('mainmenu_border_bottom_color', 'transparent'); ?>;
		border-top: <?php echo senh_get_theme_mod('mainmenu_border_top_width', '0'); ?>px solid <?php echo senh_get_theme_mod('mainmenu_border_top_color', 'transparent'); ?>;
		<?php if (get_theme_mod('mainmenu_shadow_color')) { ?>
		box-shadow: 0px 5px 5px <?php echo senh_get_theme_mod('mainmenu_shadow_color'); ?>;
		<?php } ?>
	}
	#navbar-nav-header-primary {
		margin-left: <?php echo senh_get_theme_mod('mainmenu_marginleft'); ?>px;
		margin-right: <?php echo senh_get_theme_mod('mainmenu_marginright'); ?>px;
		margin-top: <?php echo senh_get_theme_mod('mainmenu_margintop'); ?>px;
	}
	#navbar-header-primary {
		margin-bottom: <?php echo senh_get_theme_mod('mainmenu_marginbottom'); ?>px;
	}

	.navbar-header-primary .nav.force-show-items .menu-item {
		display: block !important;
	}

	.navbar-header-primary .nav	{
		<?php if (get_theme_mod('mainmenu_show_mobile_items', 'no') == 'yes') { ?>
		padding-right: 40px;
		<?php } ?>
	}

	.navbar-header-primary .nav > li > a,
	.navbar-header-primary .nav > li > a:active,
	.navbar-header-primary .nav > li > a:focus,
	.navbar-header-primary .nav > .active > a {
		font-family: <?php echo $themefonts[get_theme_mod('mainmenu_fontfamily')]; ?>;
		font-size: <?php echo senh_get_theme_mod('mainmenu_fontsize'); ?>px;
		color: <?php echo senh_get_theme_mod('mainmenu_fontcolor'); ?>;
	}
	/*body.home .navbar-header-primary .nav > .home > a {
		color: <?php echo senh_get_theme_mod('mainmenu_fontcolor'); ?>;
	}*/
	.navbar-header-primary .nav > .active > a, body.home .navbar-header-primary .nav > .home > a {
		border-bottom: <?php echo senh_get_theme_mod('mainmenu_hover_border_bottom_width', 0); ?>px solid <?php echo senh_get_theme_mod('mainmenu_hover_border_bottom_color', 'transparent'); ?>;
	}
	.navbar-header-primary .nav > li > a:focus,
	.navbar-header-primary .nav > li > a:hover,
	.navbar-header-primary .nav > .active > a:focus,
	.navbar-header-primary .nav > .active > a:hover,
	.navbar-header-primary .nav .open > a,
	.navbar-header-primary .nav .open > a:focus,
	.navbar-header-primary .nav .open > a:hover,
	.navbar-header-primary .nav > li:hover,
	.navbar-header-primary .nav > li:focus,
	.navbar-header-primary .nav > .active:hover,
	.navbar-header-primary .dropdown-menu > li > a:hover,
	.navbar-header-primary .nav > li:active,
	.navbar-header-primary .nav > .active:active,
	.navbar-header-primary .nav > li > a:active,
	.navbar-header-primary .nav > .active > a:active,
	.navbar-header-primary .dropdown-menu > li > a:active,
	.navbar-header-primary .dropdown-menu > .active > a:hover,
	.navbar-header-primary .dropdown-menu > .active > a {
		background-color: <?php echo senh_get_theme_mod('mainmenu_hover_color') ?: senh_get_theme_mod('mainmenu_color'); ?>;
		color: <?php echo senh_get_theme_mod('mainmenu_hover_fontcolor', 'inherit'); ?>;
		<?php if (get_theme_mod('mainmenu_hover_underline', false)) { ?>
		text-decoration: underline;
		<?php } ?>
	}
	.navbar-header-primary .nav > li > a {
		/*first normalize border bottom*/
		border-bottom: <?php echo senh_get_theme_mod('mainmenu_hover_border_bottom_width', 0); ?>px solid transparent;
	}
	.navbar-header-primary .nav > li > a:hover {
		border-bottom: <?php echo senh_get_theme_mod('mainmenu_hover_border_bottom_width', 0); ?>px solid <?php echo senh_get_theme_mod('mainmenu_hover_border_bottom_color', 'transparent'); ?>;
	}
	.navbar-header-primary .nav > .active > a {
		<?php if (get_theme_mod('mainmenu_active_color')) { ?>
		background-color: <?php echo senh_get_theme_mod('mainmenu_active_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('mainmenu_active_fontcolor')) { ?>
		color: <?php echo senh_get_theme_mod('mainmenu_active_fontcolor'); ?>;
		<?php } ?>
	}
<?php if (!isset($amps)) { ?>
	<?php if (get_theme_mod('mainmenu_shadow_color')) { ?>
	.navbar-header-primary .dropdown-menu {
		box-shadow: 0px 6px 12px <?php echo senh_get_theme_mod('mainmenu_shadow_color'); ?>;
	}
	<?php } ?>

	.navbar-header-primary .dropdown-menu > li > a {
		background-color: <?php echo senh_get_theme_mod('mainmenu_subitems_hover_color') ?: senh_get_theme_mod('mainmenu_color'); ?>;
	}
	.navbar-header-primary .dropdown-menu > li > a,
	.navbar-header-primary .dropdown-menu > .active > a {
		font-family: <?php echo $themefonts[get_theme_mod('mainmenu_fontfamily')]; ?>;
		font-size: <?php echo senh_get_theme_mod('mainmenu_subitems_fontsize'); ?>px;
		color: <?php echo senh_get_theme_mod('mainmenu_fontcolor'); ?>;
	}

	<?php if (!get_theme_mod('mainmenu_enable_seperator')) { ?>
	.navbar-header-primary .nav > li {
		border: none !important;
	}
	<?php } else { ?>
	.navbar-header-primary .nav > li {
		border-color: <?php echo senh_get_theme_mod('mainmenu_seperator_color', 'transparent'); ?>;
	}
	.navbar-header-primary .nav > li {
		border-right-width: <?php echo senh_get_theme_mod('mainmenu_seperator_width', 1); ?>px;
	}
	.navbar-header-primary .nav > li:first-child {
		border-left-width: <?php echo senh_get_theme_mod('mainmenu_seperator_width', 1); ?>px;
	}
	<?php } ?>


	.navbar-header-primary .nav > li > a {
		line-height: <?php echo senh_get_theme_mod('mainmenu_height', 40); ?>px;
	}
	header.affix .navbar-header-primary .nav > li > a {
		line-height: <?php echo (get_theme_mod('mainmenu_height', 40)/100*get_theme_mod('mainmenu_scrolling_fontsize', 100)); ?>px;
	}

	.navbar-header-primary .nav > li.home > a {
		font-size: <?php echo senh_get_theme_mod('mainmenu_homebutton_size', 17); ?>px;
	}



	header.affix .navbar-header-primary .nav > li.home > a {
		<?php if (get_theme_mod('mainmenu_homebutton_size', 17) !== false && senh_get_theme_mod('mainmenu_scrolling_fontsize') !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('mainmenu_homebutton_size', 17)/100*get_theme_mod('mainmenu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}
	header.affix .navbar-header-primary .nav > li > a,
	header.affix .navbar-header-primary .nav > .active > a {
		<?php if (get_theme_mod('mainmenu_scrolling_fontsize') !== false && senh_get_theme_mod('mainmenu_fontsize') !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('mainmenu_fontsize')/100*get_theme_mod('mainmenu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}
	header.affix .navbar-header-primary .dropdown-menu > li > a,
	header.affix .navbar-header-primary .dropdown-menu > .active > a {
		<?php if (get_theme_mod('mainmenu_subitems_fontsize') !== false && senh_get_theme_mod('mainmenu_scrolling_fontsize') !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('mainmenu_subitems_fontsize')/100*get_theme_mod('mainmenu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}

	<?php if (get_theme_mod('submenu_visible', true) == false) { ?>
	#navbar-header-secondary {
		display: none;
	}
	<?php } ?>

	.navbar-header-secondary .nav > li > a {
		line-height: <?php echo senh_get_theme_mod('submenu_height', 30); ?>px;
	}
	.navbar-header-secondary .nav > li.home {
		line-height: <?php echo senh_get_theme_mod('submenu_height', 30); ?>px;
	}
	header.affix .navbar-header-secondary .nav > li > a {
		line-height: <?php echo (get_theme_mod('submenu_height', 30)/100*get_theme_mod('submenu_scrolling_fontsize', 100)); ?>px;
	}


	<?php if (get_theme_mod('layout_fullwidth_header_footer', true)) { ?>
	/*#navbar-header-primary > .container,
	#navbar-header-secondary > .container,
	.footer > .container {
		width: 100%;
		max-width: 100%;
	}*/

	@media(min-width:500px) {

		<?php if /*(get_theme_mod('layout_background_content') == senh_get_theme_mod('layout_background_content_sides'))*/ ($layout_has_full_background) { ?>
		header nav .container,
		.header-container {
			padding-left: 15px; /*15*/ /*30*/
			padding-right: 15px; /*15*/
		}

		main > .container {
			padding-left: 15px;/*30*/
		}
		.footer > .container {
			padding-left: 15px;/*30*/
			padding-right: 15px;/*30*/
		}

		body.single main > .container,
		body.page main > .container {
			padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		}
		body.single .footer > .container,
		body.page .footer > .container {
			padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
			padding-right: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		}
		/*body.single header nav .container,
		body.page header nav .container,
		body.single .header-container,
		body.page .header-container {
			padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		}*/


		<?php } else { ?>
		header nav .container,
		.header-container {
			padding-left: 45px;
			padding-right: 30px;
		}

		<?php if (get_theme_mod('content_shadow_color') || senh_get_theme_mod('content_border_width')) { ?>
		body.single main > .container,
		body.page main > .container {
			padding-left: 30px;
		}
		<?php } ?>

		<?php } ?>

		<?php if (get_theme_mod('content_border_width', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('content_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		body.single main > .container,
		body.page main > .container {
			padding-left: <?php echo senh_get_theme_mod('content_padding', 15)-30; ?>px;
		}
		<?php } ?>

		/*header .navbar {
			padding-left: 15px;
			padding-right: 15px;
		}*/

		<?php if (get_theme_mod('comments_border_width', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		/*#comments > h4 {
			padding-left: 30px;
			padding-right: 30px;
		}*/
		<?php } else { ?>
		#comments > h4 {
			padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
			padding-right: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		}
		<?php } ?>
	}
	<?php } else { ?>
	@media(min-width:500px) {
		.header-container {
			padding-left: 30px;
			padding-right: 15px;
		}
	}
	@media(min-width:500px) {
		header .navbar {
			padding-left: 15px;
			<?php if (get_theme_mod('comments_border_width', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
			padding-right: 15px;
			<?php } ?>
		}
	}
	#comments > h4 {
		padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		padding-right: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
	}
	<?php } ?>


	<?php if (get_theme_mod('layout_mainmenu_enabled', true) || senh_get_theme_mod('layout_submenu_enabled')) { ?>
	main > .container > .row {
		padding-top: 15px;
	}
	<?php } ?>

	main > .container > .row {
		padding-bottom: 15px;
	}


	.pagination > nav {
		padding-left: 15px;
		padding-right: 15px;
	}

	.site-footer.container {
		padding-left: 0px;
		padding-right: 0px;
		position: static; /* if relative inner elements can't be global initially */
	}
	.boxed-container {
		width: <?php echo senh_get_theme_mod('layout_container_width', 1150); ?>px;
		margin: 0px auto;
		max-width: 100%;
		<?php if (get_theme_mod('layout_boxed_style') == 'border') { ?>
		border-left: <?php echo senh_get_theme_mod('layout_boxed_border_width') ?: '0' ?>px solid <?php echo senh_get_theme_mod('layout_boxed_border_color') ?: 'transparent' ?>;
		border-right: <?php echo senh_get_theme_mod('layout_boxed_border_width') ?: '0' ?>px solid <?php echo senh_get_theme_mod('layout_boxed_border_color') ?: 'transparent' ?>;
		<?php } else if (get_theme_mod('layout_boxed_style') == 'shadow') { ?>
		box-shadow: 2px 2px 5px <?php echo senh_get_theme_mod('layout_boxed_shadow_color') ?: 'transparent' ?>;
		<?php } else if (get_theme_mod('layout_boxed_style') == 'glow') { ?>
		box-shadow: 0px 0px <?php echo senh_get_theme_mod('layout_boxed_glow_thickness', 5)*3; ?>px <?php echo senh_get_theme_mod('layout_boxed_glow_thickness', 5); ?>px <?php echo senh_get_theme_mod('layout_boxed_glow_color') ?: 'transparent' ?>;
		<?php } ?>
	}



	<?php if (get_theme_mod('submenu_alignright')) { ?>
	#navbar-header-secondary .nav {
		float: right;
	}
	<?php } ?>
	#navbar-header-secondary {
		<?php if (get_theme_mod('submenu_color')) { ?>
		background-color: <?php echo senh_get_theme_mod('submenu_color'); ?>;
		<?php } ?>
		border-bottom: <?php echo senh_get_theme_mod('submenu_border_bottom_width', '0'); ?>px solid <?php echo senh_get_theme_mod('submenu_border_bottom_color', 'transparent'); ?>;
	}
	#navbar-nav-header-secondary {
		margin-left: <?php echo senh_get_theme_mod('submenu_marginleft'); ?>px;
		margin-right: <?php echo senh_get_theme_mod('submenu_marginright'); ?>px;
		margin-top: <?php echo senh_get_theme_mod('submenu_margintop'); ?>px;
		margin-bottom: <?php echo senh_get_theme_mod('submenu_marginbottom'); ?>px;
	}
	.navbar-header-secondary .nav > li.home,
	.navbar-header-secondary .nav > li > a,
	.navbar-header-secondary .nav > .active > a {
		font-family: <?php echo isset($themefonts[get_theme_mod('submenu_fontfamily')]) && !empty($themefonts[get_theme_mod('submenu_fontfamily')]) ? $themefonts[get_theme_mod('submenu_fontfamily')] : ''; ?>;
		font-size: <?php echo senh_get_theme_mod('submenu_fontsize', 13); ?>px;
		color: <?php echo senh_get_theme_mod('submenu_fontcolor'); ?>;
	}
	.navbar-header-secondary .nav > li > a:focus,
	.navbar-header-secondary .nav > li > a:hover,
	.navbar-header-secondary .nav > .active > a:focus,
	.navbar-header-secondary .nav > .active > a:hover,
	.navbar-header-secondary .nav .open > a,
	.navbar-header-secondary .nav .open > a:focus,
	.navbar-header-secondary .nav .open > a:hover,
	.navbar-header-secondary .nav > li:hover,
	.navbar-header-secondary .nav > li:focus,
	.navbar-header-secondary .nav > .active:hover,
	.navbar-header-secondary .dropdown-menu > li > a:hover,
	.navbar-header-secondary .nav > li:active,
	.navbar-header-secondary .nav > .active:active,
	.navbar-header-secondary .nav > li > a:active,
	.navbar-header-secondary .nav > .active > a:active,
	.navbar-header-secondary .dropdown-menu > li > a:active {
		background-color: <?php echo senh_get_theme_mod('submenu_hover_color') ?: 'none'; ?>;
		color: <?php echo senh_get_theme_mod('submenu_hover_fontcolor', senh_get_theme_mod('submenu_fontcolor')); ?>;
		<?php if (get_theme_mod('submenu_hover_underline', false)) { ?>
		text-decoration: underline;
		<?php } ?>
	}
	.navbar-header-secondary .nav > li > a:active,
	.navbar-header-secondary .nav > .active > a:active,
	.navbar-header-secondary .dropdown-menu > li > a:active {
		<?php if (get_theme_mod('submenu_active_color')) { ?>
		background-color: <?php echo senh_get_theme_mod('submenu_active_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('submenu_active_fontcolor')) { ?>
		color: <?php echo senh_get_theme_mod('submenu_active_fontcolor'); ?>;
		<?php } ?>
	}
	.navbar-header-secondary .dropdown-menu > li > a {
		background-color: <?php echo senh_get_theme_mod('submenu_color'); ?>;
	}
	.navbar-header-secondary .dropdown-menu > li > a,
	.navbar-header-secondary .dropdown-menu > .active > a {
		font-family: <?php echo isset($themefonts[get_theme_mod('submenu_fontfamily')]) && !empty($themefonts[get_theme_mod('submenu_fontfamily')]) ? $themefonts[get_theme_mod('submenu_fontfamily')] : ''; ?>;
		font-size: <?php echo senh_get_theme_mod('submenu_subitems_fontsize', 13); ?>px;
		color: <?php echo senh_get_theme_mod('submenu_fontcolor'); ?>;
	}
	<?php if (!get_theme_mod('submenu_enable_seperator')) { ?>
	.navbar-header-secondary .nav > li {
		border: none !important;
	}
	<?php } else { ?>
	.navbar-header-secondary .nav > li {
		border-color: <?php echo senh_get_theme_mod('submenu_seperator_color', 'black'); ?>;
		border-right-width: <?php echo senh_get_theme_mod('submenu_seperator_width', 1); ?>px;
	}
	.navbar-header-secondary .nav > li:first-child {
		border-left-width: <?php echo senh_get_theme_mod('submenu_seperator_width', 1); ?>px;
	}
	<?php } ?>

	/*.navbar-header-secondary .nav > .active > a,
	.navbar-header-secondary .dropdown-menu > .active > a {
		<?php if (get_theme_mod('submenu_active_color')) { ?>
		background-color: <?php echo senh_get_theme_mod('mainmenu_active_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('submenu_active_fontcolor')) { ?>
		color: <?php echo senh_get_theme_mod('mainmenu_active_fontcolor'); ?>;
		<?php } ?>
	}*/

	header.affix .navbar-header-secondary .nav > li.home,
	header.affix .navbar-header-secondary .nav > li > a,
	header.affix .navbar-header-secondary .nav > .active > a {
		<?php if (get_theme_mod('submenu_scrolling_fontsize') !== false && senh_get_theme_mod('submenu_fontsize', 13) !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('submenu_fontsize', 13)/100*get_theme_mod('submenu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}
	header.affix .navbar-header-secondary .dropdown-menu > li > a,
	header.affix .navbar-header-secondary .dropdown-menu > .active > a {
		<?php if (get_theme_mod('submenu_subitems_fontsize', 13) !== false && senh_get_theme_mod('submenu_scrolling_fontsize') !== false) { ?>
		font-size: <?php echo senh_get_theme_mod('submenu_subitems_fontsize', 13)/100*get_theme_mod('submenu_scrolling_fontsize'); ?>px;
		<?php } ?>
	}

	.navbar-header-primary .navbar-search-form {
		width: <?php echo senh_get_theme_mod('search_width', 170); ?>px;
		margin-top: <?php echo senh_get_theme_mod('search_margintop', 6); ?>px;
		margin-bottom: <?php echo senh_get_theme_mod('search_marginbottom'); ?>px;
		margin-right: <?php echo senh_get_theme_mod('search_marginright'); ?>px;
	}
	.navbar-header-primary .navbar-search-form .form-control, .navbar-header-primary .navbar-search-form .btn {
		height: <?php echo senh_get_theme_mod('search_height', 28); ?>px;
		font-size: <?php echo senh_get_theme_mod('search_fontsize', 12); ?>px;
	}
	header.affix .navbar-header-primary .navbar-search-form .form-control, header.affix .navbar-header-primary .navbar-search-form .btn {
		<?php if (get_theme_mod('search_scrolling_fontsize') !== false) { ?>
		height: <?php echo senh_get_theme_mod('search_height', 28)/100*get_theme_mod('search_scrolling_fontsize'); ?>px;
		font-size: <?php echo senh_get_theme_mod('search_fontsize', 12)/100*get_theme_mod('search_scrolling_fontsize'); ?>px;
		<?php } ?>
	}


	body.single .post-featured-image-container {
		<?php if ($width = senh_get_theme_mod('content_image_width')) { ?>
			<?php if (get_theme_mod('content_image_position') == 'above_title') { ?>
			min-width: 100%;
			<?php } else { ?>
			width: <?php echo $width . senh_get_theme_mod('content_image_width_type', '%'); ?>;
			height: <?php echo senh_get_theme_mod('content_image_height') == 0 ? 'auto' : senh_get_theme_mod('content_image_height') . senh_get_theme_mod('content_image_width_type', '%'); ?>;
			overflow: hidden;
			<?php } ?>
		<?php } ?>
	}
	.blog-header .post-avatar, .blog-header .post-avatar img {
		<?php if ($size = senh_get_theme_mod('content_gravatar_size', 30)) { ?>
		width: <?php echo $size; ?>px;
		height: <?php echo $size; ?>px;
		<?php } ?>
	}
	.blog-header .post-avatar {
		<?php if ($size = senh_get_theme_mod('content_gravatar_size', 30)) { ?>
		margin-top: -<?php echo $size/2-10; ?>px;
		margin-right: <?php echo isset($height) && !empty($height) ? $height/2 + 10 : 0; ?>px;
		<?php } ?>
	}


	h1 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h1', 30); ?>px;
		font-weight: <?php echo senh_get_theme_mod('content_weight_h1', 'normal'); ?>;
		color: <?php echo senh_get_theme_mod('content_color_h1', 'inherit'); ?>;
	}
	h2 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h2', 26); ?>px;
		font-weight: <?php echo senh_get_theme_mod('content_weight_h2', 'normal'); ?>;
		color: <?php echo senh_get_theme_mod('content_color_h2', 'inherit'); ?>;
	}
	h3 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h3', 16); ?>px;
		font-weight: <?php echo senh_get_theme_mod('content_weight_h3', 'normal'); ?>;
		color: <?php echo senh_get_theme_mod('content_color_h3', 'inherit'); ?>;
	}
	h4 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h4', 16); ?>px;
		font-weight: <?php echo senh_get_theme_mod('content_weight_h4', 'normal'); ?>;
		color: <?php echo senh_get_theme_mod('content_color_h4', 'inherit'); ?>;
	}
	/*h5 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h5', 14); ?>px;
	}
	h6 {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_h6', 14); ?>px;
	}
	h1, h2, h3, h4, h5, h6 {
		font-family: <?php echo senh_get_theme_mod('content_headers_fontfamily', 'Roboto'); ?>
	}*/
	.main-content,
	.main-content p,
	.main-content ul li,
	.main-content ol li {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_paragraph', 14); ?>px;
		line-height: <?php echo senh_get_theme_mod('content_lineheight_paragraph', 19); ?>px;
	}
	#commentform p, #commentform .form-control {
		font-size: <?php echo senh_get_theme_mod('content_fontsize_paragraph', 14); ?>px;
		line-height: <?php echo senh_get_theme_mod('content_lineheight_paragraph', 19); ?>px;
	}
	@media(max-width:767px) {
		.main-content p,
		.main-content > ul > li,
		.main-content > ol > li {
			font-size: <?php echo senh_get_theme_mod('content_fontsize_paragraph_mobile', 14); ?>px;
		}
		<?php if (get_theme_mod('mainmenu_show_mobile', 'yes') == 'only_toggle') { ?>
		header .header-image {
			max-width: 85%;
			margin-left: 10%;
		}
		<?php if (get_theme_mod('mainmenu_togglebutton_position') == 'right') { ?>
		header .header-image {
			margin-left: 0px;
		}
		#navbar-header-header-primary {
			left: none;
			right: 5px;
		}
		<?php } else { ?>
		#navbar-header-header-primary {
			left: 5px;
		}
		<?php } ?>
		<?php } ?>
	}
	p, h1, h2, h3, h4, h5, h6, ul, ol {
		/*margin-top: <?php echo senh_get_theme_mod('content_paragraph_margintop', 0); ?>px;*/
		margin-bottom: <?php echo senh_get_theme_mod('content_paragraph_marginbottom', 10); ?>px;
	}
	.main-content ul li::before, .sidebar-right ul li::before {
	    content: url("/wp-content/themes/<?php echo get_template(); ?>/bulletpoint.php?size=<?php echo senh_get_theme_mod('content_thickness_bulletpoints', 6); ?>&color=<?php echo urlencode(get_theme_mod('content_color_bulletpoints', '#990000')); ?>");
		margin: 0px 4px !important;
		margin-left: -13px !important;
	}
	.sidebar-right ul li::before {
		float: left;
	}
	/*.main-content ol li, .sidebar-right ol li {
		color: <?php echo senh_get_theme_mod('content_color_listol', '#000000'); ?>;
	}*/

	.main-content blockquote,
	.main-content ul,
	.main-content ol {
		padding-left: <?php echo senh_get_theme_mod('content_indent_quote_ol_ul', 26); ?>px;
	}

	.followus {
		margin-bottom: <?php echo senh_get_theme_mod('sidebar_margin_widgets', 20); ?>px;
	}



	blockquote {
		background-color: <?php echo senh_get_theme_mod('content_quote_backgroundcolor', '#F8EFE4'); ?>;
		<?php if (get_theme_mod('content_quote_italic', true)) { ?>
		font-style: italic;
		<?php } ?>
		margin: <?php echo senh_get_theme_mod('content_quote_margintop', 10); ?>px <?php echo senh_get_theme_mod('content_quote_marginright', 10); ?>px <?php echo senh_get_theme_mod('content_quote_marginbottom', 10); ?>px <?php echo senh_get_theme_mod('content_quote_marginleft', 0); ?>px;
	}
	.main-content blockquote p {
		font-size: <?php echo senh_get_theme_mod('content_quote_fontsize', 'inherit'); ?>px;
	}



	.post-content h1,
	.page-content h1,
	.post-content h2,
	.page-content h2,
	.post-content h3,
	.page-content h3,
	.post-content h4,
	.page-content h4,
	.post-content h5,
	.page-content h5,
	.post-content h6,
	.page-content h6 {
		font-family: <?php echo isset($themefonts[get_theme_mod('content_header_fontfamily', 'inherit')]) ? $themefonts[get_theme_mod('content_header_fontfamily', 'inherit')] : ''; ?>
	}





	.sidebar-right .widget-container {
		margin-top: <?php echo senh_get_theme_mod('sidebar_margin_widgets', 20); ?>px;
	}
	.sidebar-right .widget-container {
		border-width: <?php echo senh_get_theme_mod('sidebar_bordersize', senh_get_theme_mod('layout_all_border_width', 0)); ?>px;
		border-color: <?php echo senh_get_theme_mod('sidebar_bordercolor', senh_get_theme_mod('layout_all_border_color', 'transparent')); ?>;
		<?php if ($color = senh_get_theme_mod('layout_all_shadow', 'transparent')) { ?>
		box-shadow: 2px 2px 5px <?php echo $color; ?>;
		<?php } ?>
	}
	.sidebar-right .widget-container {
		background-color: <?php echo senh_get_theme_mod('sidebar_backgroundcolor', 'transparent'); ?>;
	}
	.sidebar-right > .widget-container > .widget-content > .widget-title {
	<?php if (get_theme_mod('sidebar_fontcolor_widget_head')) { ?>
		color: <?php echo senh_get_theme_mod('sidebar_fontcolor_widget_head'); ?>;
	<?php } ?>
	/*	font-family: <?php echo senh_get_theme_mod('sidebar_fontfamily_widget_head', 'inherit'); ?>;*/
	}
	.sidebar-content ul {
		padding-left: <?php echo senh_get_theme_mod('content_indent_quote_ol_ul', 26); ?>px;
	}
	.sidebar-content ul li,
	.sidebar-content ol li {
		padding-left: <?php echo senh_get_theme_mod('content_indent_quote_ol_ul', 26)/2; ?>px;
	}




	#comments #respond, .comment-body {
	<?php if ($bw = senh_get_theme_mod('comments_border_width', senh_get_theme_mod('layout_all_border_width', 0))) { ?>
		border: <?php echo $bw; ?>px solid <?php echo senh_get_theme_mod('comments_border_color', senh_get_theme_mod('layout_all_border_color', 'transparent')); ?>;
		/*padding: 15px;*/
	<?php } ?>
		<?php if ($color = senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		box-shadow: 2px 2px 5px <?php echo $color; ?>;
		/*padding: 15px;*/
		<?php } ?>

		<?php if (get_theme_mod('comments_border_width', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		padding: 15px <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
		<?php } else { ?>
		padding: 15px <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
		<?php } ?>

		background-color: <?php echo senh_get_theme_mod('comments_background_color', 'transparent'); ?>;
	}
	#comments #respond {
		background-color: <?php echo senh_get_theme_mod('comments_background_color', 'transparent'); ?>;

		<?php if ($color = senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		padding: 1px <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
		<?php } ?>
	}

	#navbar-header-header-primary .navbar-toggle {
		color: <?php echo senh_get_theme_mod('mainmenu_togglebutton_color', 'black'); ?>
	}
	#navbar-header-header-primary .navbar-toggle .navbar-toggle-background {
		background-color: <?php echo senh_get_theme_mod('mainmenu_togglebutton_backgroundcolor', 'red'); ?>
	}

	<?php if (get_theme_mod('layout_enable_contentborder')) { ?>
	main > .container > .row {
		border-left-width: <?php echo senh_get_theme_mod('layout_contentborder_width', 0); ?>px;
		border-right-width: <?php echo senh_get_theme_mod('layout_contentborder_width', 0); ?>px;
		border-color: <?php echo senh_get_theme_mod('layout_contentborder_color', 'transparent'); ?>;
	}
	<?php } ?>

	<?php
	// when header and footer are fullwidth, and background colors of inner content en outer sides are not the same
	// push the inner content 15px to mid, so it's correctly aligned with the menu
	if (get_theme_mod('layout_fullwidth_header_footer', true) == true && senh_get_theme_mod('layout_background_content') != senh_get_theme_mod('layout_background_content_sides')) { ?>
	main > .container > .row {
		margin-left: 0px;
		margin-right: 0px;
	}
	<?php } ?>


	body.page .blog-header {
		padding-top: 15px;
	}
	body.single .blog-header {
		padding-top: <?php echo senh_get_theme_mod('content_blogheader_padding_top') ?: 0; ?>px;

		<?php
			//Graag instellen: als uitgelichte afbeelding uitgesloten of niet bestaat, dan bij body.single .blog-header de margin-top van -30px omzetten naar de ‘Content padding’ setting vermenigvuldigd met 2 bij onderdeel 7 van het thema. Die is bij exterug.nl 15px, dus wordt dan margin-top: 30px.
			$marginTop = senh_get_theme_mod('content_blogheader_offset_y') ?: 0;
			/*if (!has_post_thumbnail()) {
				$marginTop = senh_get_theme_mod('content_padding', 15)*2;
			}*/
		?>
		margin-top: <?php echo $marginTop; ?>px;
	}
	body.single .post-featured-image-container + .blog-header {
		<?php
			//Graag instellen: als uitgelichte afbeelding uitgesloten of niet bestaat, dan bij body.single .blog-header de margin-top van -30px omzetten naar de ‘Content padding’ setting vermenigvuldigd met 2 bij onderdeel 7 van het thema. Die is bij exterug.nl 15px, dus wordt dan margin-top: 30px.
			$marginTop = senh_get_theme_mod('content_blogheader_offset_y') ?: 0;
		?>
		margin-top: <?php echo $marginTop; ?>px;
	}

	<?php if (get_theme_mod('content_image_position') != 'above_title') { ?>
	body.single .blog-header
		padding-top: 15px;
	}
	<?php } ?>
	<?php if (!get_theme_mod('blog_postsnippet_borderwidth', senh_get_theme_mod('layout_all_border_width', 0))) { ?>
	.blog-header {
		min-height: 15px;
	}
	<?php } ?>


	.blog-header h1 a:link,
	.blog-header h1 a:active,
	.blog-header h1 a:visited,
	.blog-header h1 a:hover {
		font-size: <?php echo senh_get_theme_mod('blog_post_title_fontsize', 30); ?>px;
		color: <?php echo senh_get_theme_mod('blog_post_title_color', 'inherit'); ?>;
		text-decoration: none;
	}
	.blog-header h1 a:hover {
		<?php if (get_theme_mod('blog_post_title_underline_on_hover')) { ?>
		text-decoration: underline;
		<?php } ?>
	}
	.blog-header h1 a:hover,
	.blog-header h1 a:active {
		color: <?php echo senh_get_theme_mod('blog_post_title_color_on_hover', 'inherit'); ?>;
	}

<?php } ?>
<?php if (!isset($amps)) { ?>


	.social-media-buttons > li {
		height: <?php echo senh_get_theme_mod('socialbuttons_size', 40); ?>px;
		width: <?php echo senh_get_theme_mod('socialbuttons_size', 40); ?>px;
	}
	.social-media-buttons > li.social-media-stats-enabled {
		height: <?php echo senh_get_theme_mod('socialbuttons_size', 40) + 12; ?>px;
	}
	.social-media-buttons > li {
		margin-left: <?php echo senh_get_theme_mod('socialbuttons_margin', 10); ?>px;
	}

	.blog-title {
		font-size: <?php echo senh_get_theme_mod('blog_blogheader_title_fontsize', 30); ?>px;
		color: <?php echo senh_get_theme_mod('blog_blogheader_title_color', 'black'); ?>;
		font-weight: <?php echo senh_get_theme_mod('blog_blogheader_title_fontweight', 'normal'); ?>;
	}
	.home-post {
		border: <?php echo senh_get_theme_mod('blog_postsnippet_borderwidth', senh_get_theme_mod('layout_all_border_width', 0)) ?: 0; ?>px solid <?php echo senh_get_theme_mod('blog_postsnippet_bordercolor', senh_get_theme_mod('layout_all_border_color', 'transparent')); ?>;
		<?php if ($color = senh_get_theme_mod('blog_postsnippet_shadowcolor', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		box-shadow: 2px 2px 5px <?php echo $color; ?>;
		<?php } ?>

		<?php if (get_theme_mod('blog_postsnippet_borderwidth', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('blog_postsnippet_shadowcolor')) { ?>
		padding-bottom: 10px;
		<?php if (get_theme_mod('blog_featured_image_position') == 'at_first_line') { ?>
		padding-top: 10px;
		<?php } ?>
		<?php } ?>

		padding-bottom: <?php echo $blog_postsnippet_padding; ?>px;
		<?php if (get_theme_mod('blog_featured_image_position') != 'above_title') { ?>
		padding-top: <?php echo $blog_postsnippet_padding; ?>px;
		<?php } ?>

		background-color: <?php echo senh_get_theme_mod('blog_postsnippet_background_color') ?: 'transparent'; ?>;
	}
	.home-post > * {
		<?php //if (get_theme_mod('blog_postsnippet_borderwidth', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('blog_postsnippet_shadowcolor')) { ?>
		margin-left: <?php echo $blog_postsnippet_padding; ?>px;
		margin-right: <?php echo $blog_postsnippet_padding; ?>px;
		<?php //} ?>
	}
	.home-post > .home-post-cover {
		margin-left: 0px;
		margin-right: 0px;
	}
	.home-post h1 a:link,
	.home-post h1 a:active,
	.home-post h1 a:visited,
	.home-post h1 a:hover {
		font-size: <?php echo senh_get_theme_mod('blog_post_title_fontsize', 30); ?>px;
		color: <?php echo senh_get_theme_mod('blog_post_title_color', 'inherit'); ?>;
		<?php if (get_theme_mod('blog_post_title_underline')) { ?>
		text-decoration: underline;
		<?php } else { ?>
		text-decoration: none;
		<?php } ?>
		<?php if (get_theme_mod('blog_post_title_uppercase')) { ?>
		text-transform: uppercase;
		<?php } ?>
	}

	.home-post h1 a:hover {
		<?php if (get_theme_mod('blog_post_title_underline_on_hover')) { ?>
		text-decoration: underline;
		<?php } else { ?>
		text-decoration: none;
		<?php } ?>
	}

	.home-post h1 a:hover,
	.home-post h1 a:active {
		color: <?php echo senh_get_theme_mod('blog_post_title_color_on_hover', 'inherit'); ?>;
	}
	.home-post .post-avatar,
	.blog-header .post-avatar img {
		<?php if ($size = senh_get_theme_mod('blog_post_gravatar_size', 80)) { ?>
		width: <?php echo $size; ?>px;
		height: <?php echo $size; ?>px;
		<?php } ?>
	}
	.home-post .post-avatar {
		<?php if ($size = senh_get_theme_mod('blog_post_gravatar_size', 80)) { ?>
		margin-top: -<?php echo ($size-get_theme_mod('blog_post_details_fontsize', 12))/2; ?>px;
		/*margin-right: <?php echo isset($height) && !empty($height) ? $height/2 + 10 : 0; ?>px;*/
		<?php } ?>
	}
	.home-post .home-post-details {
		font-size: <?php echo senh_get_theme_mod('blog_post_details_fontsize', 12); ?>px;
		<?php
			//Graag instellen: als uitgelichte afbeelding uitgesloten of niet bestaat, dan bij body.single .blog-header de margin-top van -30px omzetten naar de ‘Content padding’ setting vermenigvuldigd met 2 bij onderdeel 7 van het thema. Die is bij exterug.nl 15px, dus wordt dan margin-top: 30px.
			$marginTop = senh_get_theme_mod('content_padding', 15)*2 + $blog_postsnippet_padding;
		?>
		margin-top: <?php echo senh_get_theme_mod('blog_post_details_margin_top') + $marginTop; ?>px;
		margin-bottom: <?php echo senh_get_theme_mod('blog_post_details_margin_bottom'); ?>px;
	}
	.home-post .home-post-cover + .home-post-details {
		margin-top: 0px;
	}


	.home-post-details a:link,
	.home-post-details a:active,
	.home-post-details a:visited,
	.home-post-details a:hover,
	.home-post-details a:focus,
	.post-details a:link,
	.post-details a:active,
	.post-details a:visited,
	.post-details a:hover,
	.post-details a:focus,
	main a:link,
	main a:active,
	main a:visited,
	main a:hover,
	main a:focus,
	.footer a:link,
	.footer a:active,
	.footer a:visited,
	.footer a:hover,
	.footer a:focus {
		<?php if (get_theme_mod('blog_post_details_link_color')) { ?>
		color: <?php echo senh_get_theme_mod('blog_post_details_link_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('blog_post_details_link_underlined')) { ?>
		text-decoration: underline;
		<?php } else { ?>
		text-decoration: none;
		<?php } ?>
	}
	.home-post-details a:hover,
	.post-details a:hover,
	main a:hover,
	.footer a:hover {
		<?php if (get_theme_mod('blog_post_details_linkhover_color')) { ?>
		color: <?php echo senh_get_theme_mod('blog_post_details_linkhover_color'); ?>;
		<?php } ?>
		<?php if (get_theme_mod('blog_post_details_linkhover_underlined')) { ?>
		text-decoration: underline;
		<?php } else { ?>
		text-decoration: none;
		<?php } ?>
	}

	.post-details {
		font-weight: <?php echo senh_get_theme_mod('content_fontweight_paragraph', 'normal'); ?>;
	}

	<?php if (get_theme_mod('blog_post_image_zoomin', true)) { ?>
	.home-post .post-featured-image {
		transition: all 0.2s ease-out 0s;
	}
	.home-post .home-post-cover a:hover .post-featured-image {
		transform: scale(1.025);
	}
	<?php } ?>

	<?php if (get_theme_mod('blog_post_image_fade')) { ?>
	.home-post .post-featured-image {
		transition: all 0.2s ease-out 0s;
	}
	.home-post .home-post-cover a:hover .post-featured-image {
		opacity: .7;
	}
	<?php } ?>

	.home-post .home-post-description,
	.home-post .home-post-description p,
	.pagination > li, .blog-description {
		font-size: <?php echo senh_get_theme_mod('blog_post_description_fontsize', 14); ?>px;
		line-height: <?php echo senh_get_theme_mod('content_lineheight_paragraph', 19); ?>px;
	}

	body.single .main-content,
	body.page .main-content {
		border: <?php echo senh_get_theme_mod('content_border_width', 0); ?>px solid <?php echo senh_get_theme_mod('content_border_color', 'transparent'); ?>;
		/*<?php if (get_theme_mod('content_border_width', 0)) { ?>
		margin: 30px 0px;
		<?php } ?>*/
		/*overflow: hidden;*/
	}
	body.single .main-content-inner,
	body.page .main-content-inner,
	#breadcrumbs {
		<?php if (get_theme_mod('content_shadow_color')) { ?>
		box-shadow: 2px 2px 5px <?php echo senh_get_theme_mod('content_shadow_color'); ?>;
		<?php } ?>
	}


	@media(max-width:500px) {
		body.single .main-content-inner,
		body.page .main-content-inner {
			box-shadow: none;
		}
	}





	body.single .main-content-inner,
	body.page .main-content-inner,
	#breadcrumbs,
	#author-infobox {
		padding-left: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
		padding-right: <?php echo senh_get_theme_mod('content_padding', 15); ?>px;
	}

	#comments > h4,
	.comment .comment-body {
		padding-left: <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
		padding-right: <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
	}

	body.single .main-content-inner,
	body.page .main-content-inner,
	#comments,
	/*#author-infobox,*/
	#breadcrumbs {
		<?php //if (!get_theme_mod('content_shadow_color')) { ?>
		margin-left: -<?php echo senh_get_theme_mod('content_padding', 15) + (get_theme_mod('content_shadow_color') ? 15 : 0); ?>px;
		/*margin-right: -<?php echo senh_get_theme_mod('content_padding', 15) + (get_theme_mod('content_shadow_color') ? 15 : 0); ?>px;*/
		<?php //} ?>
	}







	.sidebar-content {
		padding-right: -<?php echo senh_get_theme_mod('content_padding', 15); ?>px;
	}

	.inner-content .widget {
		margin-left: <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
		margin-right: <?php echo senh_get_theme_mod('content_padding', 15) + 15; ?>px;
	}













	/*body.single .post-content,
	body.page .post-content {
		<?php if (get_theme_mod('content_shadow_color') || senh_get_theme_mod('content_border_width')) { ?>
		padding-left: 15px;
		padding-right: 15px;
		<?php } ?>
	}*/

	<?php if (get_theme_mod('layout_background_content') == senh_get_theme_mod('layout_background_content_sides')) { ?>
	.main-content > .col-xs-12 {
		padding-left: 0px;
		padding-right: 0px;
	}

	<?php if (get_theme_mod('content_shadow_color') || senh_get_theme_mod('content_border_width')) { ?>
	body.single .main-content > .col-xs-12,
	body.page .main-content > .col-xs-12 {
		padding-left: 15px;
		padding-right: 15px;
	}
	/*body.single .page-content,
	body.page .page-content {
		padding-left: 15px;
		padding-right: 15px;
	}*/
	<?php } else { ?>
	/*#breadcrumbs {
		padding-left: 0px;
		padding-right: 0px;
	}*/
	<?php } ?>

	<?php //if (true || senh_get_theme_mod('blog_postsnippet_borderwidth', senh_get_theme_mod('layout_all_border_width')) || senh_get_theme_mod('blog_postsnippet_shadowcolor', senh_get_theme_mod('layout_all_shadow'))) { ?>
	/*.main-content .pagination nav {
		margin-left: 15px;
		margin-right: 15px;
	}*/
	<?php //} ?>

	<?php } else { ?>



	<?php } ?>




<?php } ?>


	<?php if (get_theme_mod('mainmenu_bold', true)) { ?>
	.navbar-header-primary .nav > li > a,
	.navbar-header-primary .dropdown-menu > li > a {
		font-weight: bold;
	}
	<?php } ?>

	<?php if (get_theme_mod('submenu_bold', false)) { ?>
	.navbar-header-secondary .nav > li > a,
	.navbar-header-secondary .dropdown-menu > li > a {
		font-weight: bold;
	}
	<?php } ?>


<?php if (!isset($amps)) { ?>

	<?php if ($layout_has_full_background) { ?>
	/*body.blog .inner-content,
	body.archive .inner-content,*/
	/*body.blog .main-content-inner,
	body.archive .main-content-inner,
	.pagination-container {
		margin-left: -15px;
		margin-right: -15px;
	}*/
	<?php } ?>





	<?php if (get_theme_mod('content_fontcolor_paragraph')) { ?>
	p, .main-content li {
		color: <?php echo senh_get_theme_mod('content_fontcolor_paragraph'); ?>;
		font-weight: <?php echo senh_get_theme_mod('content_fontweight_paragraph', 'normal'); ?>;
	}
	<?php } ?>




	<?php if (get_theme_mod('content_shadow_color')) { ?>
	#breadcrumbs {
		padding: 10px 0px 10px <?php echo senh_get_theme_mod('content_padding', 15) + (get_theme_mod('content_shadow_color') ? 15 : 0); ?>px;
	}

	<?php } else { ?>

	<?php if (get_theme_mod('content_image_position') == 'above_title') { ?>
	.post-featured-image-container {
		padding-left: 15px;
		padding-right: 15px;
	}
	<?php } ?>

	<?php } ?>


	<?php if (get_theme_mod('blog_post_readmore_style', 'default') == 'custom' || senh_get_theme_mod('blog_post_show_readmore') == 'anchor') { ?>

	/*.home-post .home-post-more .click-more:hover,
	.home-post .home-post-more .click-more:active {
		text-decoration: inherit;
	}*/

	.home-post .home-post-more .btn.click-more {
		background-color: <?php echo senh_get_theme_mod('blog_post_readmore_backgroundcolor', '#990000'); ?>;
		padding: <?php echo senh_get_theme_mod('blog_post_readmore_padding_vertical', 6); ?>px <?php echo senh_get_theme_mod('blog_post_readmore_padding_horizontal', 12); ?>px;
		border: <?php echo senh_get_theme_mod('blog_post_readmore_border_width', 0); ?>px solid <?php echo senh_get_theme_mod('blog_post_readmore_border_color', 'transparent'); ?>;
		text-decoration: none;
	}
	.home-post .home-post-more .btn:hover, .home-post .home-post-more .btn:active {
		background-color: <?php echo senh_get_theme_mod('blog_post_readmore_hover_backgroundcolor', '#990000'); ?>;
	}

	.home-post .home-post-more .click-more {
		font-size: <?php echo senh_get_theme_mod('blog_post_readmore_fontsize', 14); ?>px;
		color: <?php echo senh_get_theme_mod('blog_post_readmore_fontcolor', '#ffffff'); ?>;
	}
	.home-post .home-post-more .click-more:hover,
	.home-post .home-post-more .click-more:active {
		color: <?php echo senh_get_theme_mod('blog_post_readmore_hover_fontcolor', '#ffffff'); ?>;
	}

	<?php } ?>

	<?php if (get_theme_mod('comments_response_button_style', 'default') == 'custom') { ?>
	#commentform .form-submit .btn, .sidebar-content .btn {
		font-size: <?php echo senh_get_theme_mod('comments_response_button_fontsize', 14); ?>px;
		color: <?php echo senh_get_theme_mod('comments_response_button_fontcolor', '#ffffff'); ?>;
		background-color: <?php echo senh_get_theme_mod('comments_response_button_backgroundcolor', '#990000'); ?>;
		padding: <?php echo senh_get_theme_mod('comments_response_button_padding_vertical', 6); ?>px <?php echo senh_get_theme_mod('comments_response_button_padding_horizontal', 12); ?>px;
		border: <?php echo senh_get_theme_mod('comments_response_button_border_width', 0); ?>px solid <?php echo senh_get_theme_mod('comments_response_button_border_color', 'transparent'); ?>;
	}
	#commentform .form-submit .btn:hover,
	#commentform .form-submit .btn:active, .sidebar-content .btn:hover, .sidebar-content .btn:active {
		color: <?php echo senh_get_theme_mod('comments_response_button_hover_fontcolor', '#ffffff'); ?>;
		background-color: <?php echo senh_get_theme_mod('comments_response_button_hover_backgroundcolor', '#990000'); ?>;
	}
	<?php } else { ?>
	#commentform .form-submit .btn, .sidebar-content .btn {
		font-size: <?php echo senh_get_theme_mod('blog_post_readmore_fontsize', 14); ?>px;
		color: <?php echo senh_get_theme_mod('blog_post_readmore_fontcolor', '#ffffff'); ?>;
		background-color: <?php echo senh_get_theme_mod('blog_post_readmore_backgroundcolor', '#990000'); ?>;
		padding: <?php echo senh_get_theme_mod('blog_post_readmore_padding_vertical', 6); ?>px <?php echo senh_get_theme_mod('blog_post_readmore_padding_horizontal', 12); ?>px;
		border: <?php echo senh_get_theme_mod('blog_post_readmore_border_width', 0); ?>px solid <?php echo senh_get_theme_mod('blog_post_readmore_border_color', 'transparent'); ?>;
	}
	#commentform .form-submit .btn:hover,
	#commentform .form-submit .btn:active, .sidebar-content .btn:hover, .sidebar-content .btn:active {
		color: <?php echo senh_get_theme_mod('blog_post_readmore_hover_fontcolor', '#ffffff'); ?>;
		background-color: <?php echo senh_get_theme_mod('blog_post_readmore_hover_backgroundcolor', '#990000'); ?>;
	}
	<?php } ?>

	.sidebar-content .btn {
		padding: 3px 5px;
	}

	<?php if (get_theme_mod('mainmenu_uppercase')) { ?>
	.navbar-header-primary .nav > li > a {
		text-transform: uppercase;
	}
	<?php } else { ?>
	.navbar-header-primary .nav > li > a {
		text-transform: none;
	}
	<?php } ?>

	<?php if (get_theme_mod('mainmenu_subitems_uppercase')) { ?>
	.navbar-header-primary .nav > li .dropdown-menu li a {
		text-transform: uppercase;
	}
	<?php } else { ?>
	.navbar-header-primary .nav > li .dropdown-menu li a {
		text-transform: none;
	}
	<?php } ?>

	<?php if (get_theme_mod('submenu_uppercase')) { ?>
	.navbar-header-secondary .nav > li > a {
		text-transform: uppercase;
	}
	<?php } else { ?>
	.navbar-header-secondary .nav > li > a {
		text-transform: none;
	}
	<?php } ?>

	<?php if (get_theme_mod('submenu_subitems_uppercase')) { ?>
	.navbar-header-secondary .nav > li .dropdown-menu li a {
		text-transform: uppercase;
	}
	<?php } else { ?>
	.navbar-header-secondary .nav > li .dropdown-menu li a {
		text-transform: none;
	}
	<?php } ?>

	<?php if (get_theme_mod('header_extra_menu_uppercase')) { ?>
	.navbar-header-extra .nav li a {
		text-transform: uppercase;
	}
	<?php } ?>

	#stopsearch-button-container {
		display: none;
	}



	.comment-author {
		color: <?php echo senh_get_theme_mod('comments_response_name_date_color', 'inherit'); ?>;
		font-size: <?php echo senh_get_theme_mod('comments_response_name_date_fontsize', 16); ?>px;
		font-weight: <?php echo senh_get_theme_mod('comments_response_name_date_fontweight', 'bold'); ?>;
	}
	<?php if (get_theme_mod('comments_gravatar_fullsize')) { ?>
	.comment {
		min-height: <?php echo senh_get_theme_mod('comments_gravatar_fullsize_size', 100); ?>px;
	}
	.comment-body {
		margin-left: <?php echo senh_get_theme_mod('comments_gravatar_fullsize_size', 100) + 10; ?>px;
	}
	.commentlist li cite img, .commentlist .avatar {
		position: absolute;
		left: 15px;
		width: <?php echo senh_get_theme_mod('comments_gravatar_fullsize_size', 100); ?>px;
		height: auto;
		margin-top: -15px;
	}
	<?php } else { ?>
	.commentlist li cite img, .commentlist .avatar {
		width: <?php echo senh_get_theme_mod('comments_gravatar_fullsize_size', 100); ?>px;
		height: auto;
	}
	<?php } ?>

	<?php if (get_theme_mod('comments_border_width', senh_get_theme_mod('layout_all_border_width', 0)) || senh_get_theme_mod('comments_shadow_color', senh_get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
	.commentlist .children {
		margin-top: 25px;
	}
	.commentlist .comment {
		margin-top: 25px;
		margin-bottom: 25px;
	}

	<?php } ?>



	<?php if (false && senh_get_theme_mod('layout_background_content') == senh_get_theme_mod('layout_background_content_sides')) { ?>
	/*#comments > h4 {
		padding-left: 30px;
	}*/
	<?php } ?>


	.post-title + .blog-description > .post-details.has-avatar {
		margin-top: <?php echo senh_get_theme_mod('content_details_margin_top') + 25; ?>px;
		margin-bottom: <?php echo senh_get_theme_mod('content_details_margin_bottom') + 25; ?>px;
	}

	.post-details + .post-title {
		padding-top: <?php echo senh_get_theme_mod('content_paragraph_marginbottom', 10); ?>px;
	}


	#header-search-button {
		color: <?php echo senh_get_theme_mod('searchbox_searchtoggle_color', 'white'); ?>;
	}

	@media(max-width:500px) {
		<?php if (get_theme_mod('searchbox_visible_mobile') == 'hide') { ?>
		.header-search {
			display: none !important;
		}
		<?php } ?>
	}

	<?php if (!get_theme_mod('searchbox_collapsed_on_mobile')) { ?>
	@media(max-width:500px) {
		.header-search {
			position: static !important;
		}
		.header-search #header-search-button {
			display: none;
		}
		.header-search .dropdown-menu {
			display: block !important;
		}
	}
	<?php } else { ?>
	@media(max-width:500px) {
		#menu-main-menu {
			width: 90%;
		}
	}
	<?php } ?>


	<?php if (get_theme_mod('searchbox_visible_mobile') == 'right_search') { ?>
	@media(max-width:500px) {
		<?php if (get_theme_mod('searchbox_show_on_toggle') && senh_get_theme_mod('searchbox_visible_mobile') != 'mainmenu') { ?>
		#header-search-button {
			display: none;
		}
		<?php } ?>

		.navbar-search-form {
			position: absolute;
			top: 10px;
			right: 2.5%;
			width: 40px;
		}
		.navbar-search-form.search-fullscreen {
			background: white;
			width: 100%;
			border: 1px solid #cdcdcd;
			right: 0px;
			height: 100%;
			top: 0px;
		}
		.navbar-search-form.search-fullscreen *, .navbar-search-form.search-fullscreen .form-control{
			height: 100%;
		}
		.navbar-search-form .form-control {
			display: none;
		}
		.navbar-search-form .form-control,
		.navbar-search-form .btn {
			font-size: 20px;
			line-height: 40px;
			height: 40px;
			border: none;
			background: none;
		}
		.navbar-search-form .btn {
			line-height: 30px;
			float: right;
			color: <?php echo senh_get_theme_mod('searchbox_searchtoggle_color', 'inherit'); ?>;
		}
		.navbar-search-form.search-fullscreen .form-control {
			display: block;
		}
		.navbar-search-form.search-fullscreen #stopsearch-button-container {
			display: table-cell;
		}
		<?php if (get_theme_mod('mainmenu_show_mobile', 'yes') == 'only_toggle') { ?>
		header .header-image {
			max-width: 75%;
			margin-left: 10%;
		}
		<?php if (get_theme_mod('mainmenu_togglebutton_position') == 'right') { ?>
		header .header-image {
			margin-left: 0px;
		}
		#navbar-header-header-primary {
			left: none;
			right: 12.5%;
		}
		<?php } else { ?>
		<?php } ?>
		<?php } ?>

	}
	@media(min-width:500px) {
		.navbar-search-form {
			display: none;
		}
		.open .navbar-search-form {
			display: block;
		}
	}
	<?php } else if (apply_filters('senhblog_navbar_nav_collapse', false, 'header-primary')) { ?>
	@media(max-width:992px) {
		#navbar-nav-header-primary .navbar-search-form {
			display: none;
		}
		#navbar-nav-header-primary .nav {
			float: left;
		}
		#navbar-nav-header-primary.collapse.in .navbar-search-form {
			display: inline-block;
		}
	}
	<?php } else { ?>
	@media(max-width:992px) {
		.navbar-header-primary .navbar-search-form {
			display: none;
		}
		.navbar-header-primary .header-search-open .navbar-search-form {
			display: inline-block;
		}
		.navbar-header-primary li.header-search-open {
			float: right !important;
		}
	}
	<?php } ?>




	@media(min-width:700px) and (max-width:992px){
		.sidebar-content .widget-container {
			max-width: <?php echo senh_get_theme_mod('layout_sidebar_width', '300'); ?>px;
			margin-bottom: <?php echo senh_get_theme_mod('sidebar_margin_widgets', 20); ?>px;
		}
	}



	.sidebar-right .widget-container {
		box-shadow: 2px 2px 5px <?php echo senh_get_theme_mod('sidebar_widgets_shadow', senh_get_theme_mod('blog_postsnippet_shadowcolor')) ?: 'transparent'; ?>;
	}


	.sidebar-right .widget-title {
		background-color: <?php echo senh_get_theme_mod('sidebar_widget_title_backgroundcolor', 'inherit'); ?>;
		margin-left: -10px;
		margin-right: -10px;
		margin-top: -10px;
		padding: 10px;
		font-size: <?php echo senh_get_theme_mod('sidebar_widget_title_fontsize', 18); ?>px;
		font-weight: <?php echo senh_get_theme_mod('sidebar_widget_title_fontweight', 'normal'); ?>;
	}
	.sidebar-right .widget-content,
	.footer .widget-content,
	.followus {
		font-size: <?php echo senh_get_theme_mod('sidebar_widget_fontsize', 14); ?>px;
	}


	/*.footer-widgets {
		margin-left: -10px;
		margin-right: -10px;
	}*/
	<?php if (!get_theme_mod('layout_fullwidth_header_footer', true)) { ?>
	.footer-widgets .widget {
		padding-left: 15px;
		padding-right: 15px;
	}
	<?php } else { ?>
	.footer-widgets .widget {
		padding-left: 0px;
		padding-right: 0px;
	}
	<?php } ?>

	.post-featured-image-container {
		max-height: <?php echo senh_get_theme_mod('content_image_maxheight', 0) > 0 ? senh_get_theme_mod('content_image_maxheight') : 'none'; ?>px;
		<?php if (get_theme_mod('content_image_position') == 'above_title') { ?>
		overflow: hidden;
		margin-bottom: 15px;
		<?php } ?>
	}
	.post-featured-image-container .post-featured-image {
		min-width: 100%;
	}
	body.single-post .metadata-icons,
	body.page .metadata-icons {
		margin-top: 10px;
		font-size: <?php echo senh_get_theme_mod('content_details_fontsize', 14); ?>px;
		display: block;
	}

	@media(min-width:500px) {
		body.single .post-featured-image-container {
			<?php if (get_theme_mod('content_image_position') == 'above_title') { ?>
			margin-left: -15px;
			margin-right: -15px;
			<?php } ?>
		}
	}


	@media(max-width:500px) {
		body.single .main-content-inner,
		body.page .main-content-inner {
			margin-right: 0px;
			margin-left: 0px;
			padding-left: 0px;
			padding-right: 0px;
		}
		body.single .main-content > .col-xs-12,
		body.page .main-content > .col-xs-12 {
			padding-left: 0px;
			padding-right: 0px;
		}
		main > .container > .row {
			padding-top: 0px;
		}
		#comments {
			margin-left: 15px;
			margin-right: 15px;
		}
		#comments > h4, .comment .comment-body {
			padding-left: 15px;
		}
		.sidebar-right {
		    max-width: 100%;
		}
	}



	.pre-footer {
		padding: <?php echo senh_get_theme_mod('footer_prefooter_padding', 15); ?>px;
		background-color: <?php echo senh_get_theme_mod('footer_prefooter_backgroundcolor', 'white'); ?>;
	}
	.footer {
		background-color: <?php echo senh_get_theme_mod('footer_widgets_backgroundcolor', 'black'); ?>;
	}
	.footer .widget-content,
	.footer .widget .widget-title,
	.footer .widget-content p,
	.footer .widget-content ul li,
	.footer .widget-content ol li,
	.footer .widget-content a {
		color: <?php echo senh_get_theme_mod('footer_widgets_fontcolor', '#ffffff'); ?>;
	}
	.footer .widget .widget-title {
		font-size: <?php echo senh_get_theme_mod('footer_widgets_headers_fontsize', 18); ?>px;
		font-weight: <?php echo senh_get_theme_mod('footer_widgets_headers_fontweight', 'bold'); ?>;
	}
	.footer .widget-content ul {
		padding-left: 0px;
		padding-left: 13px;
	}
	.footer .widget-content ul li {
		list-style: none;
	}
	.footer .widget-content ul li::after {
	    content: url("/wp-content/themes/<?php echo get_template(); ?>/bulletpoint.php?size=<?php echo senh_get_theme_mod('content_thickness_bulletpoints', 6); ?>&color=<?php echo urlencode(get_theme_mod('footer_widgets_bulletpointscolor', '#990000')); ?>");
		margin: 0px 4px !important;
		margin-left: -13px !important;
		float: left;
	}
	#navbar-nav-footer {
		text-align: <?php echo senh_get_theme_mod('footer_menu_alignment', 'center'); ?>;
		background-color: <?php echo senh_get_theme_mod('footer_menu_backgroundcolor', 'transparent'); ?>;
	}
	.footer .nav {
		font-size: <?php echo senh_get_theme_mod('footer_menu_fontsize', 13); ?>px;
	}
	.footer .navbar-nav > li:before {
		content: '<?php echo senh_get_theme_mod('footer_menu_seperator', '|'); ?>';
	}
	.footer .navbar-nav > li:first-child:before {
		content: '';
	}
	.footer .navbar-nav > li:before,
	.footer .nav > li > a:link,
	.footer .nav > li > a:focus,
	.footer .nav > li > a:hover,
	.footer .nav > li > a:visited,
	.footer .nav > li > a:active {
		color: <?php echo senh_get_theme_mod('footer_menu_fontcolor') ?: 'inherit'; ?>;
	}
	.footer .footer-copyright {
		text-align: <?php echo senh_get_theme_mod('footer_copyright_alignment', 'center'); ?>;
		padding-top: <?php echo senh_get_theme_mod('footer_copyright_padding_top', 15); ?>px;
		padding-bottom: <?php echo senh_get_theme_mod('footer_copyright_padding_bottom', 15); ?>px;
		padding-left: <?php echo senh_get_theme_mod('footer_copyright_padding_left', 15); ?>px;
		padding-right: <?php echo senh_get_theme_mod('footer_copyright_padding_right', 15); ?>px;
	}
	.footer-copyright-text {
		background-color: <?php echo senh_get_theme_mod('footer_copyright_backgroundcolor') ?: 'transparent'; ?>;
	}
	.footer .nav > li > a:link,
	.footer .nav > li > a:focus,
	.footer .nav > li > a:hover,
	.footer .nav > li > a:visited,
	.footer .nav > li > a:active {
		<?php if (get_theme_mod('footer_menu_links_underlined')) { ?>
		text-decoration: underline;
		<?php } ?>
	}


	.more-link {
		display: none;
	}

<?php } ?>

<?php
}


function authorbox_custom_css() {
	$content_biography_avatar_size = get_theme_mod('content_show_biography_avatar_size', null) ?: 0;
	$content_biography_title_fontsize = get_theme_mod('content_show_biography_title_fontsize', null) ?: 16;
	$content_biography_title_fontcolor = get_theme_mod('content_show_biography_title_fontcolor', null) ?: null;
	$content_biography_borderwidth = get_theme_mod('content_show_biography_borderwidth', null) ?: 0;
	$content_biography_bordercolor = get_theme_mod('content_show_biography_bordercolor', null) ?: 'transparent';
?>
	#author-infobox .avatar img {
		<?php if ($content_biography_avatar_size > 0) { ?>
		width: <?php echo $content_biography_avatar_size; ?>px;
		<?php } ?>
	}
	#author-infobox .author h3 {
		font-size: <?php echo $content_biography_title_fontsize; ?>px;
		<?php if ($content_biography_title_fontcolor) { ?>
		color: <?php echo $content_biography_title_fontcolor; ?>;
		<?php } ?>
	}
	#author-infobox {
		border: <?php echo get_theme_mod('layout_all_border_width', 0); ?>px solid <?php echo get_theme_mod('layout_all_border_color', 'transparent'); ?>;
		<?php if ($shadow = get_theme_mod('content_shadow_color', get_theme_mod('layout_all_shadow', 'transparent'))) { ?>
		box-shadow: 2px 2px 5px <?php echo $shadow; ?>;
		padding: 15px;
		<?php } ?>
	}
	<?php if ($content_biography_borderwidth > 0) { ?>
	#author-infobox > .row {
		margin: 0px;
		padding: 15px 0px;
		border: <?php echo $content_biography_borderwidth; ?>px solid <?php echo $content_biography_bordercolor; ?>;
	}
	<?php } ?>
<?php
}
add_action('senhtheme_customize_css', 'authorbox_custom_css');
