<?php

function wp_comment_has_avatar($comment_id) {
	$key = 'has_avatar';
	$single = true;
	$has_comment_avatar = get_comment_meta($comment_id, $key, $single);
	if ($has_comment_avatar == '' || substr($has_comment_avatar, 1) < time() - 3600*24*1) {
		$email = get_comment_author_email($comment_id);
		$has_comment_avatar = wp_user_has_avatar($email) ? 'Y' . time() : 'N' . time();
		add_comment_meta($comment_id, $key, $has_comment_avatar, true) OR update_comment_meta($comment_id, $key, $has_comment_avatar);
	}
	return substr($has_comment_avatar, 0, 1) == 'Y';
}


function wp_user_has_avatar($email) {
	/***
	this function is slowing down the site
	when few comments it's ok, but when there are many comments the site could be slowed down more dan 20 sec..
	***/

	if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) return false;
	
	if (strpos(get_avatar($email), '/wp-content/uploads/') !== false) return true;

	// Craft a potential url and test its headers
	$hash = md5(strtolower(trim($email)));
	$uri = 'http://www.gravatar.com/avatar/' . $hash . '?d=404';
	$headers = @get_headers($uri);
	if (!preg_match("|200|", $headers[0])) {
		$has_valid_avatar = FALSE;
	} else {
		$has_valid_avatar = TRUE;
	}
	return $has_valid_avatar;
}