<?php
/**
 * WordPress Bootstrap Pagination
 */

function wp_bootstrap_pagination( $args = array() ) {

    $defaults = array(
        'range'           => 4,
        'custom_query'    => FALSE,
        'previous_string' => __( '<i class="glyphicon glyphicon-chevron-left"></i>', 'text-domain' ),
        'next_string'     => __( '<i class="glyphicon glyphicon-chevron-right"></i>', 'text-domain' ),
        'before_output'   => '<div class="post-nav"><ul class="pager">',
        'after_output'    => '</ul></div>'
    );

    $args = wp_parse_args(
        $args,
        apply_filters( 'wp_bootstrap_pagination_defaults', $defaults )
    );

    $args['range'] = (int) $args['range'] - 1;
    if ( !$args['custom_query'] )
        $args['custom_query'] = @$GLOBALS['wp_query'];
    $count = (int) ($args['count'] ?: $args['custom_query']->max_num_pages);
    $page  = intval( get_query_var( 'paged' ) );
    $ceil  = ceil( $args['range'] / 2 );

    if ( $count <= 1 )
        return FALSE;

    if ( !$page )
        $page = 1;

    if ( $count > $args['range'] ) {
        if ( $page <= $args['range'] ) {
            $min = 1;
            $max = $args['range'] + 2;
        } elseif ( $page >= ($count - $ceil) ) {
            $min = $count - $args['range'];
            $max = $count;
        } elseif ( $page >= $args['range'] && $page < ($count - $ceil) ) {
            $min = $page - $ceil;
            $max = $page + $ceil;
        }
    } else {
        $min = 1;
        $max = $count;
    }

    $echo = '';
    $previous = intval($page) - 1;
    $previous = esc_attr( get_pagenum_link($previous) );

    //$firstpage = esc_attr( get_pagenum_link(1) );
    //if ( $firstpage && (1 != $page) )
    //    $echo .= '<li class="previous"><a href="' . $firstpage . '">' . ($args['first_string'] ?: __( 'First', 'text-domain' )) . '</a></li>';
	$echo .= '<li class="previous"><a>' . ($args['first_string'] ?: __( 'First', 'text-domain' )) . '</a></li>';

    if ( !empty($min) && !empty($max) ) {
        for( $i = $min; $i <= $max; $i++ ) {
            if ($page == $i) {
                $echo .= sprintf('<li class="active"><a href="%s">%d</a></li>', esc_attr( get_pagenum_link($i) ), $i);
            } else {
                $echo .= sprintf('<li><a href="%s">%d</a></li>', esc_attr( get_pagenum_link($i) ), $i);
            }
        }
    }


    //$lastpage = esc_attr( get_pagenum_link($count) );
    //if ( $lastpage ) {
    //    $echo .= '<li class="next"><a href="' . $lastpage . '">' . ($args['last_string'] ?: __( 'Last', 'text-domain' )) . '</a></li>';
	$echo .= '<li class="next"><a>' . ($args['last_string'] ?: __( 'Last', 'text-domain' )) . '</a></li>';
    //}

    if ( isset($echo) )
        echo $args['before_output'] . $echo . $args['after_output'];
}
