<?php

require_once( DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerCustomerNeoSeoSubscribe extends NeoSeoController
{

	private $error = array();

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName = "neoseo_subscribe";
		$this->_modulePostfix = ""; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	public function index()
	{
		$this->getList();
	}

	private function getList()
	{
		$filterExportUrlChunk = array();

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		if (isset($this->request->get['filter_email'])) {
			$filter_email = $this->request->get['filter_email'];
			$filterExportUrlChunk[] = 'filter_email=' . $this->request->get['filter_email'];
		} else {
			$filter_email = null;
		}
		if (isset($this->request->get['filter_date'])) {
			$filter_date = $this->request->get['filter_date'];
			$filterExportUrlChunk[] = 'filter_date=' . $this->request->get['filter_date'];
		} else {
			$filter_date = null;
		}

		if (isset($this->request->get['store_id'])) {
			$store_id = $this->request->get['store_id'];
			$filterExportUrlChunk[] = 'store_id=' . $this->request->get['store_id'];
		} else {
			$store_id = -1;
		}

		$filterExportUrlChunk = count($filterExportUrlChunk) ? '&' . implode('&', $filterExportUrlChunk) : '';

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data = $this->load->language('customer/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/store');

		$data['stores'] = $this->model_setting_store->getStores();

		$data = $this->initBreadcrumbs(array(
			array("customer/" . $this->_moduleSysName(), "text_list")
				), $data);

		$data['import'] = $this->url->link('customer/' . $this->_moduleSysName() . '/import', 'user_token=' . $this->session->data['user_token'], 'SSL');
		$data['export'] = $this->url->link('customer/' . $this->_moduleSysName() . '/export', 'user_token=' . $this->session->data['user_token'] . $filterExportUrlChunk, 'SSL');
		$data['add'] = $this->url->link('customer/' . $this->_moduleSysName() . '/add', 'user_token=' . $this->session->data['user_token'], 'SSL');
		$data['delete'] = $this->url->link('customer/' . $this->_moduleSysName() . '/delete', 'user_token=' . $this->session->data['user_token'], 'SSL');

		$data['subscribe'] = array();

		$filter_data = array(
			'filter_email' => $filter_email,
			'filter_date' => $filter_date,
			'store_id' => $store_id,
			'sort' => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin')
		);
		$this->load->model('customer/' . $this->_moduleSysName());
		$items_total = $this->model_customer_neoseo_subscribe->getTotalItems($filter_data);

		$results = $this->model_customer_neoseo_subscribe->getItems($filter_data);
		foreach ($results as $subscribe) {
			$data['subscribe'][] = array(
				'subscribe_id' => $subscribe['subscribe_id'],
				'date' => $subscribe['date'],
				'email' => $subscribe['email'],
				'name' => $subscribe['name'],
				'store' => !empty($subscribe['store_id']) ? $this->getStoreName($data['stores'], $subscribe['store_id']) : '',
				'edit' => $this->url->link('customer/' . $this->_moduleSysName() . '/edit', 'user_token=' . $this->session->data['user_token'] . '&subscribe_id=' . $subscribe['subscribe_id'] . $url, 'SSL')
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array) $this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$data['user_token'] = $this->session->data['user_token'];
		$data['filter_email'] = $filter_email;
		$data['filter_date'] = $filter_date;
		$data['store_id'] = $store_id;
		$data['sort_date'] = $this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $url, 'SSL');
		$data['sort_email'] = $this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . '&sort=email' . $url, 'SSL');

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $items_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($items_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($items_total - $this->config->get('config_limit_admin'))) ? $items_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $items_total, ceil($items_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('customer/' . $this->_moduleSysName() . '_list', $data));
	}

	public function export()
	{
		if (!$this->user->hasPermission('access', 'customer/' . $this->_moduleSysName()))
			return;

		header('Pragma: public');
		header('Expires: 0');
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename=subscribe.csv');
		header('Content-Transfer-Encoding: binary');

		$filterSql = array();

		if (isset($this->request->get['filter_email'])) {
			$filterSql[] = 'email = "' . $this->db->escape($this->request->get['filter_email']) . '"';
		}

		if (isset($this->request->get['filter_date'])) {
			$filterSql[] = 'date LIKE "%' . $this->db->escape($this->request->get['filter_date']) . '%"';
		}

		if (isset($this->request->get['store_id'])) {
			$filterSql[] = 'store_id = "' . $this->db->escape($this->request->get['store_id']) . '"';
		}

		$filterSql = count($filterSql) ? ' WHERE ' . implode(' AND ', $filterSql) : '';

		$results = $this->db->query("SELECT email, name FROM `" . DB_PREFIX . "subscribe` " . $filterSql . " ORDER BY subscribe_id ASC");

		echo implode(';', array_keys($results->row)) . "\n";
		foreach ($results->rows as $result) {
			echo str_replace('&amp;', '&', implode(';', str_replace('"', '%22', $result))) . "\n";
		}
		exit();
	}

	public function exportCustomerData()
	{
		if (!$this->user->hasPermission('access', 'customer/customer'))
			return;

		header('Pragma: public');
		header('Expires: 0');
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename=subscribe.csv');
		header('Content-Transfer-Encoding: binary');

		$results = $this->db->query("SELECT email as `Email Address`, lastname as `Last Name`, firstname as `First Name` FROM `" . DB_PREFIX . "customer` ORDER BY customer_id ASC");
		echo implode("\t", array_keys($results->row)) . "\n";
		foreach ($results->rows as $result) {
			echo str_replace('&amp;', '&', implode("\t", str_replace('"', '%22', $result))) . "\n";
		}
		exit();
	}

	public function add()
	{
		$this->load->language('customer/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('customer/' . $this->_moduleSysName());

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_customer_neoseo_subscribe->addItem(
					$this->request->post['item']
			);
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			$link = (isset($this->request->get['request_uri'])) ? 'customer/neoseo_broken_links' : 'customer/' . $this->_moduleSysName();
			$this->response->redirect($this->url->link($link, 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	public function edit()
	{
		$this->load->language('customer/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('customer/' . $this->_moduleSysName());
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_customer_neoseo_subscribe->editItem(
					$this->request->get['subscribe_id'], $this->request->post['item']
			);
			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

	protected function getForm()
	{
		$data = $this->load->language('customer/' . $this->_moduleSysName());

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$breadcrumbs[] = array('customer/' . $this->_moduleSysName(), "text_list");

		if (!isset($this->request->get['subscribe_id'])) {
			$data['action'] = $this->url->link('customer/' . $this->_moduleSysName() . '/add', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
			if (isset($this->request->get['request_uri'])) {
				$data['action'] = $this->url->link('customer/' . $this->_moduleSysName() . '/add', 'user_token=' . $this->session->data['user_token'] . '&request_uri=' . $this->request->get['request_uri'] . $url, 'SSL');
			}
			$breadcrumbs[] = array('customer/' . $this->_moduleSysName() . '/add', "text_add");
		} else {
			$data['action'] = $this->url->link('customer/' . $this->_moduleSysName() . '/edit', 'user_token=' . $this->session->data['user_token'] . '&subscribe_id=' . $this->request->get['subscribe_id'] . $url, 'SSL');
			$breadcrumbs[] = array('customer/' . $this->_moduleSysName() . '/edit&subscribe_id=' . $this->request->get['subscribe_id'], "text_edit");
		}

		$data = $this->initBreadcrumbs($breadcrumbs, $data);

		$data['cancel'] = $this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		if (isset($this->request->get['request_uri'])) {
			$data['cancel'] = $this->url->link('customer/neoseo_broken_links', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		}
		if (isset($this->request->get['subscribe_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$attribute_info = $this->model_customer_neoseo_subscribe->getItem($this->request->get['subscribe_id']);
		}
		$data['text_form'] = !isset($this->request->get['subscribe_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->request->get['subscribe_id'])) {

			$data['item_id'] = $this->request->get['subscribe_id'];
			$this->load->model('customer/' . $this->_moduleSysName());
			$data['item'] = $this->model_customer_neoseo_subscribe->getItem($this->request->get['subscribe_id']);
		} else {
			$data['item'] = array(
				'date' => '',
				'email' => '',
				'name' => ''
			);
		}
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('customer/' . $this->_moduleSysName() . '_form', $data));
	}

	public function delete()
	{
		$this->load->language('customer/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('customer/' . $this->_moduleSysName());

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $subscribe_id) {
				$this->model_customer_neoseo_subscribe->deleteItem($subscribe_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$this->response->redirect($this->url->link('customer/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	public function getStoreName($stores, $store_id)
	{
		foreach ($stores as $id => $data) {
			if ($stores[$id]['store_id'] == $store_id) {
				return $stores[$id]['name'];
			}
		}
	}

	protected function validateDelete()
	{
		if (!$this->user->hasPermission('modify', 'customer/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		$this->load->model('customer/' . $this->_moduleSysName());

		foreach ($this->request->post['selected'] as $subscribe_id) {

			$redirect_total = $this->model_customer_neoseo_subscribe->getTotalItemByRedirectId($subscribe_id);

			if (!$redirect_total) {
				$this->error['warning'] = sprintf($this->language->get('error_delete_redirect'), $redirect_total);
			}
		}

		return !$this->error;
	}

	protected function validateForm()
	{
		if (!$this->user->hasPermission('modify', 'customer/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

}

?>