<?php

require_once( DIR_SYSTEM . '/engine/neoseo_controller.php');
require_once( DIR_SYSTEM . '/engine/neoseo_view.php' );

class ControllerExtensionModuleNeoSeoProductLabels extends NeoSeoController
{

	private $error = array();

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_product_labels";
		$this->_module_code = "neoseo_firestore_free";
		$this->_modulePostfix = ""; // Постфикс для разных типов модуля, поэтому переходим на испольлзование $this->_moduleSysName()
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	public function index()
	{
		$this->upgrade();

		$data = $this->load->language('extension/' . $this->_route . '/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title_raw'));
		$this->document->addStyle('view/javascript/jquery/jpicker/css/jpicker-1.1.6.min.css');
		$this->document->addStyle('view/javascript/jquery/jpicker/css/jpicker.css');
		$this->document->addScript('view/javascript/jquery/jpicker/jpicker-1.1.6.js');

		$this->load->model('setting/setting');
		$this->load->model('tool/' . $this->_moduleSysName());
		$this->load->model('catalog/product');
		$this->load->model('localisation/language');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->cache->delete('product.labels');
			if (isset($this->request->post["labels"])) {
				$this->model_tool_neoseo_product_labels->saveLabel($this->request->post["labels"]);
				unset($this->request->post['labels']);
			}

			//Это нужно чтобы при нажатии кнопки "сохранить и закрыть" был правильный статус
			$this->model_extension_module_neoseo_product_labels->setModuleStatus($this->request->post[$this->_moduleSysName() . "_status"]);

			$this->model_setting_setting->editSetting($this->_moduleSysName(), $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			if ($this->request->post['action'] == "save") {
				$this->response->redirect($this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'], true));
			} else {
				$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true));
			}
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else if (isset($this->session->data['error_warning'])) {
			$data['error_warning'] = $this->session->data['error_warning'];
			unset($this->session->data['error_warning']);
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		}

		$data = $this->initBreadcrumbs(array(
			array('marketplace/extension', 'text_module'),
			array('extension/' . $this->_route . '/' . $this->_moduleSysName(), "heading_title_raw")
				), $data);

		$data = $this->initButtons($data);
		$data['delete'] = $this->url->link('extension/module/' . $this->_moduleSysName() . '/delete', 'user_token=' . $this->session->data['user_token'], 'SSL');

		$data['config_language_id'] = $this->config->get('config_language_id');

		$labels = array();
		$listLabels = $this->model_tool_neoseo_product_labels->getListLabels();
		$listLabels = is_array($listLabels) ? $listLabels : array();
		foreach ($listLabels as $label_id => $label) {
			$label['name'] = unserialize($label['name']);
			$label['stores'] = unserialize($label['store_ids']);
			$labels[$label["label_id"]] = $label;
			$products = $this->model_tool_neoseo_product_labels->getLabelProducts($label["label_id"]);
			foreach ($products as $product_id) {
				$product_info = $this->model_catalog_product->getProduct($product_id);
				if ($product_info) {
					$labels[$label["label_id"]]['prod'][$product_info['product_id']] = $product_info['name'];
				}
			}
			$data["max_id"] = $label["label_id"] + 1;
		}
		$data['active_sale_status'] = $this->config->get($this->_moduleSysName() . '_special_type');
		$label_products = $this->config->get($this->_moduleSysName() . '_special_label_products');
		if ($label_products) {
			foreach ($label_products as $product_id) {
				$product_info = $this->model_catalog_product->getProduct($product_id);
				if ($product_info) {
					$data['products'][$product_info['product_id']] = $product_info['name'];
				}
			}
		}
		$data["labels"] = $labels;

		$data['user_token'] = $this->session->data['user_token'];
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$data['array_params'] = array(
			0 => $this->language->get('params_type_hands'),
			1 => $this->language->get('params_type_new'),
			2 => $this->language->get('params_type_popular'),
			3 => $this->language->get('params_type_hit'),
			4 => $this->language->get('params_type_stock'),
			5 => $this->language->get('params_type_instock'),
		);
		$data['array_position'] = array(
			'label-left' => $this->language->get('params_position_top_left'),
			'label-right' => $this->language->get('params_position_top_right'),
		);
		$data['array_type_label'] = array(
			'sticker' => $this->language->get('params_type_label_sticker'),
			'chip' => $this->language->get('params_type_label_chip'),
		);


		$special_title = array();

		foreach ($data['languages'] as $language) {
			if ($language['language_id'] == $data['config_language_id']) {
				$new_name[$language ['language_id']] = 'new-label-name';
			}
			$special_title[$language['language_id']] = $this->language->get('text_special');
		}

		$this->load->model("extension/" . $this->_route . "/" . $this->_moduleSysName());
		$data = $this->initParamsListEx($this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->getParams(), $data);

		if (!isset($data['max_id']))
			$data['max_id'] = 1;
		$this->load->model('setting/store');
		$data['stores'] = $this->model_setting_store->getStores();

		$labels[$data["max_id"]] = array(
			'label_id' => $data["max_id"],
			'name' => $new_name,
			'label_type' => 'corner',
			'class' => '',
			'style' => '',
			'color' => 'f12717',
			'position' => 'label-top-left',
			'type' => 1,
			'products' => '',
			'priority' => 0,
			'stores' => '',
			'status' => 0,
			'days' => 0,
			'viewes' => 0,
			'sold' => 0,
			'product_limit' => 10,
		);
		$data["labels"] = $labels;

		$data['params'] = $data;

		$data["user_token"] = $this->session->data['user_token'];
		$data['params'] = $data;

		$data["logs"] = $this->getLogs();

		$widgets = new NeoSeoWidgets($this->_moduleSysName() . '_', $data);
		$widgets->text_select_all = $this->language->get('text_select_all');
		$widgets->text_unselect_all = $this->language->get('text_unselect_all');
		$data['widgets'] = $widgets;
		
		$data["label_form"] = str_replace(array("\n", "\r", "'"), "", $this->load->view('extension/module/' . $this->_moduleSysName() . '_form', $data));

		array_pop($data ["labels"]); //  элемент больше не нужен

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/' . $this->_moduleSysName(), $data));
	}

	public function delete()
	{

		$data = $this->load->language('extension/module/' . $this->_moduleSysName());
		$data['params'] = $data;
		$this->load->model('tool/' . $this->_moduleSysName());

		if (!$this->user->hasPermission('modify', 'extension/module/' . $this->_moduleSysName())) {
			$data['error_warning'] = $this->language->get('error_permission');

			$this->template = 'extension/module/' . $this->_moduleSysName();
			$this->children = array(
				'common/header',
				'common/footer'
			);

			$data['post'] = $this->request->post;
			$this->response->setOutput($this->
							render(), $this->config->get('config_compression'));
			return;
		} else {

			if (isset($this->request->get["label_id"])) {
				$this->model_tool_neoseo_product_labels->deleteLabel($this->request->get);

				$this->session->data['success'] = $this->language->get('text_success_delete');
			}

			header("location:" . str_replace('&amp;', '&', $this->url->link('extension/module/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'], 'SSL')));
		}
	}

	private function validate()
	{
		if (!$this->user->hasPermission('modify', 'extension/module/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

}

?>
