<?php

require_once( DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerToolNeoSeoSeoGen extends NeoSeoController
{

	private $error = array();

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_seogen";
		$this->_module_code = "neoseo_firestore_free";
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	public function handler_product($route_event, $data_event, $product_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$product_id = isset($product_id_event) ? (int)$product_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyProduct($product_id);
		}
	}

	public function handler_category($route_event, $data_event, $category_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$category_id = isset($category_id_event) ? (int)$category_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyCategory($category_id);
		}
	}

	public function handler_manufacturer($route_event, $data_event, $manufacturer_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$manufacturer_id = isset($manufacturer_id_event) ? (int)$manufacturer_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyManufacturer($manufacturer_id);
		}
	}

	public function handler_information($route_event, $data_event, $information_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$information_id = isset($information_id_event) ? (int)$information_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyInformation($information_id);

		}
	}

	public function handler_blog_category($route_event, $data_event, $blog_category_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$blog_category_id = isset($blog_category_id_event) ? (int)$blog_category_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyBlogCategory($blog_category_id);

		}
	}

	public function handler_blog_author($route_event, $data_event, $blog_author_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$blog_author_id = isset($blog_author_id_event) ? (int)$blog_author_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyBlogAuthor($blog_author_id);

		}
	}

	public function handler_blog_article($route_event, $data_event, $blog_article_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$blog_article_id = isset($blog_article_id_event) ? (int)$blog_article_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyBlogArticle($blog_article_id);

		}
	}

	public function handler_filter_page($route_event, $data_event, $filter_page_id_event = false)
	{
		if (1 == $this->config->get($this->_moduleSysName() . "_status")) {
			$this->load->model('tool/' . $this->_moduleSysName);
			$filter_page_id = isset($filter_page_id_event) ? (int)$filter_page_id_event : (int)$data_event[0];
			$this->model_tool_neoseo_seogen->urlifyFilterPages($filter_page_id);

		}
	}
}
