<?php

require_once(DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerExtensionModuleNeoSeoCategoryWallBlock extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_category_wall_block";
		$this->_module_code = 'neoseo_firestore_free';
		$this->_modulePostfix = "";
		$this->_logFile = $this->_moduleSysName . ".log";
		$this->debug = $this->config->get($this->_moduleSysName . "_debug") == 1;
	}

	public function index($setting)
	{

		static $module = 0;
		$data = $this->load->language('module/' . $this->_moduleSysName());
		$this->load->model("extension/module/neoseo_menu");
		$this->load->model('tool/image');
		if ( !file_exists('catalog/view/theme/' . $this->config->get('config_theme') . '/stylesheet/neoseo_unistor.scss') && file_exists('catalog/view/theme/' . $this->config->get('config_theme') . '/stylesheet/neoseo_category_wall.css') ) {
			$this->document->addStyle('catalog/view/theme/' . $this->config->get('config_theme') . '/stylesheet/neoseo_category_wall.css');
		}

		$data['heading_title'] = $setting['title'][(int)$this->config->get('config_language_id')];
		$data['description'] = $setting['description'][(int)$this->config->get('config_language_id')];

		$data['categories'] = array();

		if ($setting['type'] == 0) {
			$data['categories'] = array();
			$categories_data = $this->model_extension_module_neoseo_menu->getMenu(0, $setting['categories_id']);
			foreach ($categories_data as $category) {
				if ($category['image']) {
					$image = $category['image'];
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', $setting['icon_width'], $setting['icon_height']);
				}
				$data['categories'][] = array('category_id' => $category['pid'], 'name' => $category['name'], 'image' => $image, 'children' => $category['children'], 'column' => $category['column'] ? $category['column'] : 1, 'href' => $category['href']);
			}
		} elseif ($setting['type'] == 1) {
			$this->load->model('catalog/product');
			$this->load->model('catalog/category');
			$categories = $this->model_catalog_category->getCategories(0);
			if ($categories) {
				foreach ($categories as $category) {
					$children_data = array();

					$children = $this->model_catalog_category->getCategories($category['category_id']);

					foreach ($children as $child) {
						$filter_data = array('filter_category_id' => $child['category_id'], 'filter_sub_category' => true);

						$children_data[] = array('name' => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''), 'href' => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id']));
					}

					// Level 1
					if ($category['image']) {
						$image = $this->model_tool_image->resize($category['image'], $setting['icon_width'], $setting['icon_height']);
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $setting['icon_width'], $setting['icon_height']);
					}
					$data['categories'][] = array('category_id' => $category['category_id'], 'name' => $category['name'], 'image' => $image, 'children' => $children_data, 'column' => $category['column'] ? $category['column'] : 1, 'href' => $this->url->link('product/category', 'path=' . $category['category_id']));
				}
			}
		} elseif ($setting['type'] == 2) {

			$this->load->model('catalog/category');

			$parts = explode('_', $this->request->get['path']);

			$categories = $this->model_catalog_category->getCategories(end($parts));

			if (file_exists(DIR_APPLICATION . "model/extension/" . $this->_route . "/neoseo_filter_pages.php") && isset($this->request->get['nsf'])) {
				$this->load->model('extension/' . $this->_route . '/neoseo_filter_pages');
				$pageInfo = $this->{'model_extension_' . $this->_route . '_neoseo_filter_pages'}->getPage($this->request->get['nsf']);
				//print_r($pageInfo);
				if (isset($pageInfo['status'])) {
					$categories = 0;
				}
			}

			if ($categories) {

				if (count($parts) > 1) {
					$cat_name_id = $parts[count($parts) - 1];
				} else {
					$cat_name_id = $parts[0];
				}
				$category = $this->model_catalog_category->getCategory($cat_name_id);
				if ($category) {
					$data['category_name'] = $category['name'];
				}

				foreach ($categories as $category) {

					// Level 1
					if ($category['image']) {
						$image = $this->model_tool_image->resize($category['image'], $setting['icon_width'], $setting['icon_height']);
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $setting['icon_width'], $setting['icon_height']);
					}
					$data['categories'][] = array('category_id' => $category['category_id'], 'name' => $category['name'], 'image' => $image, //'children' => $children_data,
						'column' => $category['column'] ? $category['column'] : 1, 'href' => $this->url->link('product/category', 'path=' . $category['category_id']));
				}
			}

		}
		$data['module'] = $module++;
		$data['setting'] = $setting;

		$this->registry->set('data', $data);
		$data['registry'] = $this->registry;

		$template = $setting['template'];
		$template = str_replace(".twig", "", basename($template, '.twig'));

		$template = 'extension/module/' . $this->_moduleSysName . '_' . $template;
		//echo "<pre>";print_r($setting);exit;
		$data['icon_width'] = $setting['icon_width'];
		$data['icon_height'] = $setting['icon_height'];

		return $this->load->view($template, $data);
	}

}

?>
