<?php

require_once(DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerExtensionModuleNeoSeoFilter extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName = "neoseo_filter";
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug");
	}

	public function index($setting)
	{

		if (!$setting) {
			return;
		}

		$this->document->addScript('catalog/view/javascript/jquery/jquery-ui.js');

		$data = $this->load->language('extension/module/' . $this->_moduleSysName());
		$this->load->model('extension/module/' . $this->_moduleSysName());

		$data['cancel_all'] = $this->model_extension_module_neoseo_filter->getUrl(array(), 0, 0, true);
		$data['symbol_left'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));
		$data['symbol_right'] = $this->currency->getSymbolRight($this->config->get('config_currency'));

		$data['use_price'] = isset($setting['use_price']) ? $setting['use_price'] : 1;

		$use_manufacturer = isset($setting['manufacturer']) && $setting['manufacturer'];
		$ignore_seo_url_filter = isset($setting['ignore_seo_url_filter']) && $setting['ignore_seo_url_filter'];

		$language_id = $this->config->get('config_language_id');
		if (isset($setting['title'][$language_id])) {
			$data['heading_title'] = $setting['title'][$language_id];
		}

		$category_id = 0;
		$filter_data = array();
		if (isset($this->request->get['path'])) {
			$parts = explode('_', (string) $this->request->get['path']);
			$category_id = end($parts);
			$filter_data['filter_category'] = $category_id;
		}

		if ($this->request->get['route'] == 'product/manufacturer/info' && isset($this->request->get['manufacturer_id'])) {
			$filter_data['filter_manufacturer'] = $this->request->get['manufacturer_id'];
		}

		$options = $this->model_extension_module_neoseo_filter->getOptions($filter_data, $use_manufacturer, $setting);

		$data['min_price'] = 0;
		$data['max_price'] = 0;
		$data['price_begin'] = 0;
		$data['price_end'] = 0;
		$selected_options = $this->model_extension_module_neoseo_filter->getSelectedOptions($options);
		if ($data['use_price'] == 1) {
			$category_prices = $this->model_extension_module_neoseo_filter->getCategoryPrices($category_id);
			$data['min_price'] = floor($category_prices['min_price'] * $this->currency->getValue($this->config->get('config_currency')));
			$data['max_price'] = ceil($category_prices['max_price'] * $this->currency->getValue($this->config->get('config_currency')));
			if (isset($selected_options['p'])) {
				$keys = array_keys($selected_options['p']);
				$prices = explode("-", $keys[0]);
				unset($selected_options['p']);
				$data['price_begin'] = max($prices[0], (int) $data['min_price']);
				$data['price_end'] = min($prices[1], (int) $data['max_price']);
			} else {
				$data['price_begin'] = (int) $data['min_price'];
				$data['price_end'] = (int) $data['max_price'];
			}
		}

		$data['selected_options_values_count'] = 0;
		$selected_option_values = array();
		foreach ($selected_options as $selected_option_id => $selected_option_value_ids) {
			foreach ($selected_option_value_ids as $selected_option_value_id => $tmp) {
				$selected_option_values[] = $selected_option_value_id;
				$options[$selected_option_id]['selected'] = 1;
				$options[$selected_option_id]['values'][$selected_option_value_id]['selected'] = 1;
				$data['selected_options_values_count'] = $data['selected_options_values_count'] + 1;
			}
		}


		// В кеше должно быть сохранено итоговое значение по всем опциям, чтобы не делать 100 запросов к базе, а ограничиться одним
		$value_id_to_quantity = $this->model_extension_module_neoseo_filter->getOptionValueQuantity($options, $selected_options, $selected_option_values, $category_id, $ignore_seo_url_filter);
		$current_quantity = $value_id_to_quantity[0];
		$slider_options = array();
		$total_quantity = 0;
		foreach ($options as $key => $option) {

			if (isset($option['after_manufacturer']) && $option['after_manufacturer'] == 1 && !isset($selected_options['m'])) {
				unset($options[$key]);
				continue;
			}

			$slider_values = array();
			if ($option['type'] == "slider") {
				$values_list = array();
				foreach ($option['values'] as $value_key => $option_value) {

					$options[$key]['values'][$value_key]['name'] = str_replace(",", ".", $option_value['name']);
					if ((float) $option_value['name']) {
						$slider_options[$option['option_id']]['values'][$option_value['option_value_id']]['val'] = (float) $option_value['name'];
						$slider_values[] = (float) $option_value['name'];

						$values_list[$value_key] = (float) $option_value['name'];

						if (isset($value_id_to_quantity[(int) $option_value['option_value_id']])) {
							$url = $value_id_to_quantity[(int) $option_value['option_value_id']]['u'];
						} else {
							//$selected = $options[$option['option_id']]['values'][$option_value['option_value_id']]['selected'];
							//$url = $this->model_extension_module_neoseo_filter->getUrl($selected_options, $option['option_id'], $option_value['option_value_id'], $selected);
						}
						$slider_options[$option['option_id']]['values'][$option_value['option_value_id']]['url'] = $url;
						$slider_options[$option['option_id']]['values'][$option_value['option_value_id']]['option_value_id'] = $option_value['option_value_id'];
					} else {
						continue;
					}
				}

				if (count($slider_values)) {
					$slider_options[$option['option_id']]['values_min'] = min($slider_values);
					$slider_options[$option['option_id']]['values_max'] = max($slider_values);
				}

				$selected_range = array();
				if (isset($selected_options[$option['option_id']])) {
					foreach ($selected_options[$option['option_id']] as $key_sel_option => $val_sel_option) {
						if (isset($option['values'][$key_sel_option]['name'])) {
							$selected_range[] = (float) $option['values'][$key_sel_option]['name'];
						}
					}
					if (count($selected_range)) {
						$slider_options[$option['option_id']]['values_begin'] = min($selected_range);
						$slider_options[$option['option_id']]['values_end'] = max($selected_range);
					}
				} else {
					if (count($slider_values)) {
						$slider_options[$option['option_id']]['values_begin'] = min($slider_values);
						$slider_options[$option['option_id']]['values_end'] = max($slider_values);
					}
				}
				$slider_selected_options = $selected_options;
				if (isset($slider_selected_options[$option['option_id']])) {
					unset($slider_selected_options[$option['option_id']]);
				}
				$slider_options[$option['option_id']]['url_for_slider'] = htmlspecialchars_decode($this->model_extension_module_neoseo_filter->getUrl($slider_selected_options));
				$slider_options[$option['option_id']]['url_for_slider_clear'] = $this->model_extension_module_neoseo_filter->getUrlClear($slider_selected_options);
				$js_values_list = json_encode($values_list);
				$slider_options[$option['option_id']]['js_values_list'] = $js_values_list;
				//echo "var js_values_list = ". $js_values_list . ";\n";
			}

			foreach ($option['values'] as $option_value) {
				if (isset($value_id_to_quantity[(int) $option_value['option_value_id']])) {
					$url = $value_id_to_quantity[(int) $option_value['option_value_id']]['u'];
				} else {
					$selected = $options[$option['option_id']]['values'][$option_value['option_value_id']]['selected'];
					$url = $this->model_extension_module_neoseo_filter->getUrl($selected_options, $option['option_id'], $option_value['option_value_id'], $selected, 1, $ignore_seo_url_filter);
				}
				$options[$option['option_id']]['values'][$option_value['option_value_id']]['url'] = $url;

				if (in_array((int) $option_value['option_value_id'], $selected_option_values)) {
					// тут традиционно не вычисляем ничего
					$quantity = 0;
				} else {
					$quantity = isset($value_id_to_quantity[(int) $option_value['option_value_id']]) ? $value_id_to_quantity[(int) $option_value['option_value_id']]['q'] : 0;
					unset($selected_option_value_ids_plus_one);
					if ($options[$option['option_id']]['selected']) {
						$quantity -= $current_quantity;
						if ($quantity > 0) {
							$quantity = "+" . $quantity;
						}
					}
				}

				if ($quantity > 0) {
					$options[$option['option_id']]['quantity'] += $quantity;
					$total_quantity += $quantity;
				}
				$options[$option['option_id']]['values'][$option_value['option_value_id']]['count'] = $quantity;
			}
		}

		if ($this->request->get['route'] == 'product/manufacturer/info') {
			unset($options['m']);
		}

		$data['slider_options'] = $slider_options;
		$data['options'] = $options;
		$data['selected_options_count'] = count($selected_options);

		if ($data['use_price'] == 1) {
			$data['url_for_price'] = htmlspecialchars_decode($this->model_extension_module_neoseo_filter->getUrl($selected_options, "p", "PRICE_FROM-PRICE_TO", false));
			$data['url_priceless'] = htmlspecialchars_decode($this->model_extension_module_neoseo_filter->getUrl($selected_options));
		}

		if ($total_quantity == 0 && $data['min_price'] == $data['max_price'] && !$selected_option_values) {
			return '';
		}

		$template = isset($setting['template']) && $setting['template'] ? $setting['template'] : 'vertical';
		$this->document->addStyle('catalog/view/theme/default/stylesheet/jquery-ui.css');

		return $this->load->view('extension/module/' . $this->_moduleSysName() . '_' . $template, $data);
	}

}
