<?php

require_once(DIR_SYSTEM . '/engine/neoseo_controller.php');

class ControllerExtensionModuleNeoseoSmartSearch extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName ='neoseo_smart_search';
		$this->_logFile = $this->_moduleSysName() . '.log';
		$this->debug = $this->config->get($this->_moduleSysName() . '_debug') == 1;
	}

	public function index()
	{
		if (!isset($this->request->get['filter_name']) || !$this->request->get['filter_name']) {
			$this->response->setOutput(json_encode(array()), $this->config->get('config_compression'));
			return;
		}
		$filter_name = utf8_strtolower(trim($this->request->get['filter_name']));

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = false;
		}

		$this->load->model('extension/module/' . $this->_moduleSysName());
		$this->load->model('tool/image');

		$this->load->language('extension/module/' . $this->_moduleSysName());

		$search_array = array(
			'name' => 'pd.name',
			'model' => 'p.model',
			'sku' => 'p.sku'
		);

		$key = 'name';
		$search = 'pd.name';

		if (isset($this->request->get['key']) && isset($search_array[$this->request->get['key']])) {
			$key = $this->request->get['key'];
			$search = $search_array[$key];
		}

		$page = (isset($this->request->get['page'])) ? (int) $this->request->get['page'] : 1;
		$page = ($page < 1) ? 1 : $page;
		$product_limit = (int) $this->config->get($this->_moduleSysName() . '_product_limit');

		$data = array(
			'filter_name' => $filter_name,
			'filter_category' => $filter_category,
			'page' => ($page - 1) * $product_limit,
			'limit' => $product_limit,
			'search' => $search
		);

		$product_total = $this->{'model_extension_module_' . $this->_moduleSysName()}->getTotalProducts($data);
		if (!$product_total) {
			$this->response->setOutput(json_encode(array()), $this->config->get('config_compression'));
			return;
		}

		$image_status = $this->config->get($this->_moduleSysName() . '_image_status');
		$image_width = $this->config->get($this->_moduleSysName() . '_image_width');
		$image_height = $this->config->get($this->_moduleSysName() . '_image_height');
		$price_status = $this->config->get($this->_moduleSysName() . '_price_status');
		$rating_status = $this->config->get($this->_moduleSysName() . '_rating_status');
		$description_limit = (int) $this->config->get($this->_moduleSysName() . '_description_limit');

		$data['products'] = array();
		$results = $this->{'model_extension_module_' . $this->_moduleSysName()}->getProducts($data);
		foreach ($results as $result) {
			$product = array(
				'product_id' => $result['product_id'],
				'name' => $result['name'],
				'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $description_limit) . '...',
				'href' => $this->url->link('product/product', 'product_id=' . $result['product_id'])
			);

			if ($image_status) {
				if ($result['image']) {
					$image_src = $result['image'];
				} else {
					$image_src = "no_image.png";
				}
				$product['image'] = $this->model_tool_image->resize($image_src, $image_width, $image_height);
			}

			if ($price_status) {
				$product['special'] = 0;
				if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
					$product['price'] = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				}

				if ((float) $result['special']) {
					$product['special'] = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				}
				$product['saving'] = round((($result['price'] - $result['special']) / ($result['price'] + 0.01)) * 100, 0);
			}

			if ($rating_status) {
				$product['rating'] = $result['rating'];
				$product['reviews'] = sprintf($this->language->get('text_reviews'), (int) $result['reviews']);
			}

			$data['products'][] = $product;
		}

		$data['page'] = $page;
		$data['prevPage'] = $page - 1;
		$data['nextPage'] = $page + 1;
		$data['totalPages'] = ceil($product_total / $product_limit);
		$data['product_total'] = $product_total;
		$data['product_limit'] = $product_limit;
		$data['filter_name'] = $filter_name;
		$data['key'] = $key;

		$data['label_name'] = $this->language->get('label_name');
		$data['label_model'] = $this->language->get('label_model');
		$data['label_sku'] = $this->language->get('label_sku');
		$data['text_filter'] = $this->language->get('text_filter');
		$data['text_search_page'] = $this->language->get('text_search_page');
		$data['text_look_results'] = $this->language->get('text_look_results');

		$data['name_status'] = $this->config->get($this->_moduleSysName() . '_name_status');
		$data['model_status'] = $this->config->get($this->_moduleSysName() . '_model_status');
		$data['sku_status'] = $this->config->get($this->_moduleSysName() . '_sku_status');
		$data['selector'] = $this->config->get($this->_moduleSysName() . '_selector');

		$products = $this->load->view('extension/module/' . $this->_moduleSysName(), $data);
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode(array('content' => $products)), $this->config->get('config_compression'));
	}

}
