/* Search main */
$(document).ready(function() {
    $('.button-search').on('click', function () {

        let current_language_code = $('.language__compact-wrap li.active').attr('data-code');

        if (current_language_code === undefined || current_language_code === null) {
            var url = 'index.php?route=product/search';
        } else {
            var url = current_language_code + '/index.php?route=product/search';
        }

        $('#smart-search input[name="search"]').each(function () {
            if ($(this).val() && $(this).attr('changed') !== undefined) {
                let value = $(this).val();
                let filter_category = $('.category-list-title').data('categoryid');
                if (value) {
                    url += '&search=' + encodeURIComponent(value);
                    if (filter_category !== undefined) {
                        url += '&category_id=' + filter_category + '&sub_category=true';
                    }
                }

                const categoryId = $('.category-list-title').attr('data-categoryid');
                const categoryName = $('.category-list-title').text().trim();

                window.localStorage.setItem('category_id', categoryId);
                window.localStorage.setItem('category_name', categoryName);
                if (!/category_id/.test(url)) {
                    url = url + '&category_id=' + categoryId;
                }
                location = url;
                return false;
            }
        });
    });
    $('input[name="search"]').on('keydown', function (e) {
        $(this).attr('changed','true');
        var parents = $(this).parents('#smart-search');
        if (e.keyCode == 13) {
            parents.find('button').trigger('click');
        }
    });
});