function getURLVar(key) {
    var value = [];

    var query = String(document.location).split('?');

    if (query[1]) {
        var part = query[1].split('&');

        for (i = 0; i < part.length; i++) {
            var data = part[i].split('=');

            if (data[0] && data[1]) {
                value[data[0]] = data[1];
            }
        }

        if (value[key]) {
            return value[key];
        } else {
            return '';
        }
    }
}

$(document).ready(function() {
    // Highlight any found errors
    $('.text-danger').each(function() {
        var element = $(this).parent().parent();

        if (element.hasClass('form-group')) {
            element.addClass('has-error');
        }
    });

    // Currency
    $('#form-currency .currency-select').on('click', function(e) {
        e.preventDefault();

        $('#form-currency input[name=\'code\']').val($(this).attr('name'));

        $('#form-currency').submit();
    });

    // Language
    $('#form-language .language-select').on('click', function(e) {
        e.preventDefault();

        $('#form-language input[name=\'code\']').val($(this).attr('name'));

        $('#form-language').submit();
    });

    /* Search */
    $('#search input[name=\'search\']').parent().find('button').on('click', function() {
        let url = $('base').attr('href') + 'index.php?route=product/search';

        let value = $('.header-menu #search input[name=\'search\']').val();

        if (value) {
            url += '&search=' + encodeURIComponent(value);
        }

        location = url;
    });

    $('#search input[name=\'search\']').on('keydown', function(e) {
        if (e.key === 'Enter') {
            $('.header-menu #search input[name=\'search\']').parent().find('button').trigger('click');
        }
    });

    // Menu
    $('#menu .dropdown-menu').each(function() {
        var menu = $('#menu').offset();
        var dropdown = $(this).parent().offset();

        var i = (dropdown.left + $(this).outerWidth()) - (menu.left + $('#menu').outerWidth());

        if (i > 0) {
            $(this).css('margin-left', '-' + (i + 10) + 'px');
        }
    });

    // Product List
    $('#list-view').click(function() {
        $('.preview-products-box .preview-products__item').attr('class', 'preview-products__item --list');
        $('.preview-products-box').attr('class', 'preview-products-box grid-1');

        $('#grid-view').removeClass('active');
        $('#list-view').addClass('active');

        localStorage.setItem('display', 'list');
    });

    // Product Grid
    $('#grid-view').click(function() {
        // What a shame bootstrap does not take into account dynamically loaded columns
        $('.preview-products-box .preview-products__item').attr('class', 'preview-products__item --grid');
        $('.preview-products-box').attr('class', 'preview-products-box grid-'+$('.preview-products-box').attr('data-default-grid'));

        $('#list-view').removeClass('active');
        $('#grid-view').addClass('active');

        localStorage.setItem('display', 'grid');
    });

    if (localStorage.getItem('display') === 'list') {
        $('#list-view').trigger('click');
        $('#list-view').addClass('active');
    } else if (localStorage.getItem('display') === 'grid') {
        $('#grid-view').trigger('click');
        $('#grid-view').addClass('active');
    } else {
        $('#grid-view').trigger('click');
        $('#grid-view').addClass('active');
    }

    // Checkout
    $(document).on('keydown', '#collapse-checkout-option input[name=\'email\'], #collapse-checkout-option input[name=\'password\']', function(e) {
        if (e.keyCode == 13) {
            $('#collapse-checkout-option #button-login').trigger('click');
        }
    });

    // tooltips on hover
    $('[data-toggle=\'tooltip\']').tooltip({container: 'body'});

    // Makes tooltips work on ajax generated content
    $(document).ajaxStop(function() {
        $('[data-toggle=\'tooltip\']').tooltip({container: 'body'});
    });
});

// Cart add remove functions
var cart = {
    'add': function(product_id, quantity, target) {

        $.ajax({
            url: 'index.php?route=checkout/cart/add',
            type: 'post',
            data: 'product_id=' + product_id + '&quantity=' + (typeof(quantity) != 'undefined' ? quantity : 1),
            dataType: 'json',
            beforeSend: function() {
                $('#cart > button').button('loading');
            },
            complete: function() {
                $('#cart > button').button('reset');
            },
            success: function(json) {
                $('.alert-dismissible, .text-danger').remove();

                if (json['redirect']) {
                    location = json['redirect'];
                }

                if (json['success']) {
                    $('#content').parent().before('<div class="alert alert-success alert-dismissible alert-firestore" role="alert">' + json['success'] + ' <button type="button" class="btn-close button-reset" data-bs-dismiss="alert" aria-label="Close"><i class="las la-times"></i></button></div>');
                    setTimeout(() => $('.alert-firestore').remove(), 3000);

                    // Need to set timeout otherwise it wont update the total
                    cart.updateCart(json);

                    $('html, body').animate({ scrollTop: 0 }, 300);

                    $('#cart .cart-modal__list').load('index.php?route=common/cart/info ul li');

                    if (!$(target).hasClass('active')) {
                        $(target).addClass('active');
                    } else {
                        return true;
                    }
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    },
    'update': function(key, quantity) {
        $.ajax({
            url: 'index.php?route=checkout/cart/edit',
            type: 'post',
            data: 'key=' + key + '&quantity=' + (typeof(quantity) != 'undefined' ? quantity : 1),
            dataType: 'json',
            beforeSend: function() {
                $('#cart > button').button('loading');
            },
            complete: function() {
                $('#cart > button').button('reset');
            },
            success: function(json) {
                // Need to set timeout otherwise it wont update the total
                cart.updateCart(json);

                if (getURLVar('route') == 'checkout/cart' || getURLVar('route') == 'checkout/checkout') {
                    location = 'index.php?route=checkout/cart';
                } else {
                    $('#cart .cart-modal__list').load('index.php?route=common/cart/info ul li');
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    },
    'remove': function(key) {
        $.ajax({
            url: 'index.php?route=checkout/cart/remove',
            type: 'post',
            data: 'key=' + key,
            dataType: 'json',
            beforeSend: function() {
                $('#cart > button').button('loading');
            },
            complete: function() {
                $('#cart > button').button('reset');
            },
            success: function(json) {
                // Need to set timeout otherwise it wont update the total
                cart.updateCart(json);

                if (getURLVar('route') == 'checkout/cart' || getURLVar('route') == 'checkout/checkout') {
                    location = 'index.php?route=checkout/cart';
                } else {
                    $('#cart .cart-modal__list').load('index.php?route=common/cart/info ul li');
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    },
    'updateCart': function (json) {
        // Need to set timeout otherwise it wont update the total
        setTimeout(function () {

            const cartTotal = $('#cart .header-menu__cart-total');

            if (json['total'] > 0) {
                $('.header-menu__cart-button').addClass('has-items');

                (cartTotal.hasClass('d-none'))
                    ? cartTotal.removeClass('d-none').html(json['total'])
                    : cartTotal.html(json['total']);
            } else {
                $('.header-menu__cart-button').removeClass('has-items');
                cartTotal.addClass('d-none').html('');
                $('.cart-modal .button-close-cart').click();
            }

        }, 100);
    },
}

var voucher = {
    'add': function() {

    },
    'remove': function(key) {
        $.ajax({
            url: 'index.php?route=checkout/cart/remove',
            type: 'post',
            data: 'key=' + key,
            dataType: 'json',
            beforeSend: function() {
                $('#cart > button').button('loading');
            },
            complete: function() {
                $('#cart > button').button('reset');
            },
            success: function(json) {
                // Need to set timeout otherwise it wont update the total
                setTimeout(function () {
                    $('#cart > button').html('<span id="cart-total"><i class="fa fa-shopping-cart"></i> ' + json['total'] + '</span>');
                }, 100);

                if (getURLVar('route') == 'checkout/cart' || getURLVar('route') == 'checkout/checkout') {
                    location = 'index.php?route=checkout/cart';
                } else {
                    $('#cart > ul').load('index.php?route=common/cart/info ul li');
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }
}

var wishlist = {
    'add': function(product_id) {
        $.ajax({
            url: 'index.php?route=account/wishlist/add',
            type: 'post',
            data: 'product_id=' + product_id,
            dataType: 'json',
            success: function(json) {
                $('.alert-dismissible').remove();

                if (json['redirect']) {
                    location = json['redirect'];
                }

                if (json['success']) {
                    $('body').append('<div class="alert alert-success alert-dismissible alert-firestore" role="alert">' + json['success'] + ' <button type="button" onclick="$(this).parent().remove();" class="btn-close button-reset" data-bs-dismiss="alert" aria-label="Close"><i class="las la-times"></i></button></div>');
                    setTimeout(() => $('.alert-firestore').remove(), 5000);
                }

            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    },
    'remove': function(product_id) {
        $.ajax({
            url: 'index.php?route=account/wishlist',
            type: 'get',
            data: 'remove=' + product_id,
            success: function(json) {
                $('.alert-dismissible').remove();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }
}

var compare = {
    'add': function(product_id) {
        $.ajax({
            url: 'index.php?route=product/compare/add',
            type: 'post',
            data: 'product_id=' + product_id,
            dataType: 'json',
            success: function(json) {
                $('.alert-dismissible').remove();

                if (json['success']) {
                    $('body').append('<div class="alert alert-success alert-dismissible alert-firestore" role="alert">' + json['success'] + ' <button type="button" onclick="$(this).parent().remove();" class="btn-close button-reset" data-bs-dismiss="alert" aria-label="Close"><i class="las la-times"></i></button></div>');
                    setTimeout(() => $('.alert-firestore').remove(), 5000);
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    },
    'remove': function(product_id) {
        $.ajax({
            url: 'index.php?route=product/compare',
            type: 'get',
            data: 'remove=' + product_id,
            success: function(json) {
                $('.alert-dismissible').remove();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
            }
        });
    }
}

/* Agree to Terms */
$(document).delegate('.agree', 'click', function(e) {
    e.preventDefault();

    $('#modal-agree').remove();

    var element = this;

    $.ajax({
        url: $(element).attr('href'),
        type: 'get',
        dataType: 'html',
        success: function(data) {
            html  = '<div id="modal-agree" class="modal">';
            html += '  <div class="modal-dialog">';
            html += '    <div class="modal-content">';
            html += '      <div class="modal-header">';
            html += '        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>';
            html += '        <h4 class="modal-title">' + $(element).text() + '</h4>';
            html += '      </div>';
            html += '      <div class="modal-body">' + data + '</div>';
            html += '    </div>';
            html += '  </div>';
            html += '</div>';

            $('body').append(html);

            $('#modal-agree').modal('show');
        }
    });
});

// Autocomplete */
(function($) {
    $.fn.autocomplete = function(option) {
        return this.each(function() {
            this.timer = null;
            this.items = new Array();

            $.extend(this, option);

            $(this).attr('autocomplete', 'off');

            // Focus
            $(this).on('focus', function() {
                this.request();
            });

            // Blur
            $(this).on('blur', function() {
                setTimeout(function(object) {
                    object.hide();
                }, 200, this);
            });

            // Keydown
            $(this).on('keydown', function(event) {
                switch(event.keyCode) {
                    case 27: // escape
                        this.hide();
                        break;
                    default:
                        this.request();
                        break;
                }
            });

            // Click
            this.click = function(event) {
                event.preventDefault();

                value = $(event.target).parent().attr('data-value');

                if (value && this.items[value]) {
                    this.select(this.items[value]);
                }
            }

            // Show
            this.show = function() {
                var pos = $(this).position();

                $(this).siblings('ul.dropdown-menu').css({
                    top: pos.top + $(this).outerHeight(),
                    left: pos.left
                });

                $(this).siblings('ul.dropdown-menu').show();
            }

            // Hide
            this.hide = function() {
                $(this).siblings('ul.dropdown-menu').hide();
            }

            // Request
            this.request = function() {
                clearTimeout(this.timer);

                this.timer = setTimeout(function(object) {
                    object.source($(object).val(), $.proxy(object.response, object));
                }, 200, this);
            }

            // Response
            this.response = function(json) {
                html = '';

                if (json.length) {
                    for (i = 0; i < json.length; i++) {
                        this.items[json[i]['value']] = json[i];
                    }

                    for (i = 0; i < json.length; i++) {
                        if (!json[i]['category']) {
                            html += '<li data-value="' + json[i]['value'] + '"><a href="#">' + json[i]['label'] + '</a></li>';
                        }
                    }

                    // Get all the ones with a categories
                    var category = new Array();

                    for (i = 0; i < json.length; i++) {
                        if (json[i]['category']) {
                            if (!category[json[i]['category']]) {
                                category[json[i]['category']] = new Array();
                                category[json[i]['category']]['name'] = json[i]['category'];
                                category[json[i]['category']]['item'] = new Array();
                            }

                            category[json[i]['category']]['item'].push(json[i]);
                        }
                    }

                    for (i in category) {
                        html += '<li class="dropdown-header">' + category[i]['name'] + '</li>';

                        for (j = 0; j < category[i]['item'].length; j++) {
                            html += '<li data-value="' + category[i]['item'][j]['value'] + '"><a href="#">&nbsp;&nbsp;&nbsp;' + category[i]['item'][j]['label'] + '</a></li>';
                        }
                    }
                }

                if (html) {
                    this.show();
                } else {
                    this.hide();
                }

                $(this).siblings('ul.dropdown-menu').html(html);
            }

            $(this).after('<ul class="dropdown-menu"></ul>');
            $(this).siblings('ul.dropdown-menu').delegate('a', 'click', $.proxy(this.click, this));

        });
    }
})(window.jQuery);


function popupGallery (trigger = [], options = {}) {

    if (undefined === trigger) {
        console.log('ERROR: popupGallery.trigger undefined');
        return false;
    }

    if (undefined === options.activeClass) {
        console.log('ERROR: popupGallery.options.activeClass undefined');
        return false;
    }

    if (undefined !== options.title) {
        this.title = options.title;
    }

    this.activeClass = options.activeClass;

    this.popup = document.querySelector('.popupGallery');
    this.popupHead = document.querySelector('.popupGallery__head');
    this.popupTitle = document.querySelector('.popupGallery__title');
    this.popupClose = document.querySelector('.popupGallery__close');
    this.popupBox = document.querySelector('.popupGallery__box');
    this.popupImageList = document.querySelector('.popupGallery__imageList-Box');
    this.popupImage = document.querySelector('.popupGallery__image').children[0];

    const removeClassActive = () => {
        for (let value of Object.values(this.popupImageList.children)) {
            value.classList.remove('active');
        }
    }


    /*=== ADD EVENTS - begin ===*/

    for (let value of Object.values(this.popupImageList.children)) {

        value.addEventListener('click', (e) => {

            removeClassActive();

            e.target.classList.add('active');
            let src = e.target.getAttribute('href');
            let data_zoom_image = e.target.getAttribute('data-zoom-image');
            let maxHeightImage = 'max-height:' + ( popupBox.clientHeight - popupHead.clientHeight - 82) + 'px';
          
            this.popupImage.setAttribute('src', src);
            this.popupImage.setAttribute('data-zoom-image', data_zoom_image);
            this.popupImage.setAttribute('style', maxHeightImage);

            console.log(maxHeightImage);

        });
    }

    const galleryRun = (e) => {
        e.preventDefault();

        this.popup.classList.add('active');

        let index = 0;
        for (let value of Object.values(document.querySelectorAll('.image-additional'))) {
            if (value.children[0].classList.contains('active')) {
                break;
            }
            index++;
        }

        let index2 = 0;
        for (let value of Object.values(this.popupImageList.children)) {

            if (index === index2) {
                value.classList.add('active');
            }
            index2++;
        }


        setTimeout(() => {
            this.popupBox.classList.add('active');
            document.querySelector('.popupGallery__imageList img').click();
        },300)

        document.querySelector('html').classList.add('popupGalleryActive')

        // ADD TITLE

        if (undefined !== options.title) {
            console.log(document.querySelector(options.title).innerHTML);
            this.popupTitle.innerHTML = document.querySelector(options.title).innerHTML;

        }

    }


    trigger.forEach((element) => {
        document.querySelector(element).addEventListener('click', galleryRun, true)
    })


    this.popupClose.addEventListener('click', () => {

        this.popupBox.classList.remove('active')
        removeClassActive();

        if (null !== document.querySelector('.ZoomContainer')) {
            document.querySelector('.ZoomContainer').remove();
        }


        setTimeout(() => {
            this.popup.classList.remove('active');
            document.querySelector('html').classList.remove('popupGalleryActive')
        },300)
    }, true)

    /*=== ADD EVENTS - end ===*/

}
