<?php
class ControllerModuleCategoryPriceListView extends Controller {
	private $error = array(); 
	
	public function index() {   
		$this->load->language('module/category_pricelist_view');

		$this->document->setTitle(strip_tags($this->language->get('heading_title')));
		
		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			if ($this->request->post['apply']) {
				$url = $this->url->link('module/category_pricelist_view', 'token=' . $this->session->data['token'], 'SSL');
			} else {
				$url = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
			}
			
			unset($this->request->post['apply']);
			
			$this->model_setting_setting->editSetting('category_pricelist_view', $this->request->post);
		
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->redirect($url);
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_select_all'] = $this->language->get('text_select_all');
		$this->data['text_unselect_all'] = $this->language->get('text_unselect_all');
		
		$this->data['text_select_on'] = $this->language->get('text_select_on');
		$this->data['text_select_off'] = $this->language->get('text_select_off');
		$this->data['text_select_on1'] = $this->language->get('text_select_on1');
		$this->data['text_select_off1'] = $this->language->get('text_select_off1');
		$this->data['entry_category'] = $this->language->get('entry_category');
		
		$this->data['text_icons'] = $this->language->get('text_icons');
		$this->data['text_default_view'] = $this->language->get('text_default_view');
		$this->data['text_column_image'] = $this->language->get('text_column_image');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_apply'] = $this->language->get('button_apply');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/category_pricelist_view', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/category_pricelist_view', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['modules'] = array();
		
		if (isset($this->request->post['category_pricelist_view_module'])) {
			$this->data['modules'] = $this->request->post['category_pricelist_view_module'];
		} elseif ($this->config->get('category_pricelist_view_module')) { 
			$this->data['modules'] = $this->config->get('category_pricelist_view_module');
		}
		
		$this->load->model('catalog/category');		
		$this->data['categories'] = $this->model_catalog_category->getCategories(0);
		
		$this->load->model('catalog/attribute');
	    $this->data['attributes'] = $this->model_catalog_attribute->getAttributes();
		
		$config_vars = array(
			'category_pricelist_view_icon_show',
			'category_pricelist_view_image_show', 'category_pricelist_view_quantity_show',
			'category_pricelist_view_quantity_cart_show', 'category_pricelist_view_model_show',
			'category_pricelist_view_sku_show', 'category_pricelist_view_location_show',
			'category_pricelist_view_manufacturer_show', 'category_pricelist_view_manufacturer_link',
			'category_pricelist_view_attribute_show', 'category_pricelist_view_option_show',
			'category_pricelist_view_multicart_show', 'category_pricelist_view_cart_show',
			'search_pricelist_view_search_show',
			'search_pricelist_view_icon_show', 'search_pricelist_view_default_show',
			'search_pricelist_view_image_show', 'search_pricelist_view_quantity_show',
			'search_pricelist_view_quantity_cart_show', 'search_pricelist_view_model_show',
			'search_pricelist_view_sku_show', 'search_pricelist_view_location_show',
			'search_pricelist_view_manufacturer_show', 'search_pricelist_view_manufacturer_link',
			'search_pricelist_view_attribute_show', 'search_pricelist_view_option_show',
			'search_pricelist_view_multicart_show',	'search_pricelist_view_cart_show',
			'manufacturer_pricelist_view_manufacturer_show',
			'manufacturer_pricelist_view_icon_show', 'manufacturer_pricelist_view_default_show',
			'manufacturer_pricelist_view_image_show', 'manufacturer_pricelist_view_quantity_show',
			'manufacturer_pricelist_view_quantity_cart_show', 'manufacturer_pricelist_view_model_show',
			'manufacturer_pricelist_view_sku_show', 'manufacturer_pricelist_view_location_show',
			'manufacturer2_pricelist_view_manufacturer_show', 'manufacturer_pricelist_view_manufacturer_link',
			'manufacturer_pricelist_view_attribute_show', 'manufacturer_pricelist_view_option_show',
			'manufacturer_pricelist_view_multicart_show',	'manufacturer_pricelist_view_cart_show',
			'special_pricelist_view_special_show',
			'special_pricelist_view_icon_show', 'special_pricelist_view_default_show',
			'special_pricelist_view_image_show', 'special_pricelist_view_quantity_show',
			'special_pricelist_view_quantity_cart_show', 'special_pricelist_view_model_show',
			'special_pricelist_view_sku_show', 'special_pricelist_view_location_show',
			'special_pricelist_view_manufacturer_show', 'special_pricelist_view_manufacturer_link',
			'special_pricelist_view_attribute_show', 'special_pricelist_view_option_show',
			'special_pricelist_view_multicart_show',	'special_pricelist_view_cart_show',
		);
	
		
		foreach ($config_vars as $config_var) {
			if (isset($this->request->post[$config_var])) {
				$this->data[$config_var] = $this->request->post[$config_var];
			} elseif ($this->config->get($config_var)) {
				$this->data[$config_var] = $this->config->get($config_var);
			} else {
				$this->data[$config_var] = '0';
			}
		}
		
		if (isset($this->request->post['category_pricelist_view_default_show'])) {
			$this->data['category_pricelist_view_default_show'] = $this->request->post['category_pricelist_view_default_show'];
		} elseif ($this->config->get('category_pricelist_view_default_show')) { 
			$this->data['category_pricelist_view_default_show'] = $this->config->get('category_pricelist_view_default_show');
		} else {
			$this->data['category_pricelist_view_default_show'] = array();
		}

		if (isset($this->request->post['category_pricelist_view_category'])) {
			$this->data['category_pricelist_view_category'] = $this->request->post['category_pricelist_view_category'];
		} elseif ($this->config->get('category_pricelist_view_category')) { 
			$this->data['category_pricelist_view_category'] = $this->config->get('category_pricelist_view_category');
		} else {
			$this->data['category_pricelist_view_category'] = array();
		}

		if (isset($this->request->post['category_pricelist_view_attribute'])) {
			$this->data['category_pricelist_view_attribute'] = $this->request->post['category_pricelist_view_attribute'];
		} elseif ($this->config->get('category_pricelist_view_attribute')) { 
			$this->data['category_pricelist_view_attribute'] = $this->config->get('category_pricelist_view_attribute');
		} else {
			$this->data['category_pricelist_view_attribute'] = array();
		}

		if (isset($this->request->post['search_pricelist_view_attribute'])) {
			$this->data['search_pricelist_view_attribute'] = $this->request->post['search_pricelist_view_attribute'];
		} elseif ($this->config->get('search_pricelist_view_attribute')) { 
			$this->data['search_pricelist_view_attribute'] = $this->config->get('search_pricelist_view_attribute');
		} else {
			$this->data['search_pricelist_view_attribute'] = array();
		}
		
		if (isset($this->request->post['manufacturer_pricelist_view_attribute'])) {
			$this->data['manufacturer_pricelist_view_attribute'] = $this->request->post['manufacturer_pricelist_view_attribute'];
		} elseif ($this->config->get('manufacturer_pricelist_view_attribute')) { 
			$this->data['manufacturer_pricelist_view_attribute'] = $this->config->get('manufacturer_pricelist_view_attribute');
		} else {
			$this->data['manufacturer_pricelist_view_attribute'] = array();
		}
		
		if (isset($this->request->post['special_pricelist_view_attribute'])) {
			$this->data['special_pricelist_view_attribute'] = $this->request->post['special_pricelist_view_attribute'];
		} elseif ($this->config->get('special_pricelist_view_attribute')) { 
			$this->data['special_pricelist_view_attribute'] = $this->config->get('special_pricelist_view_attribute');
		} else {
			$this->data['special_pricelist_view_attribute'] = array();
		}
				
		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		$this->template = 'module/category_pricelist_view.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/category_pricelist_view')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>