$(document).ready(function () {
	$('.quantity_cart input:not([value=\'1\'])').each(function(){
		recalc($(this).attr('name'));
	});
	
	$('.cat-head .multicart input').live('change', function() {
		$('.multicart input:checkbox:enabled').attr('checked', this.checked);
	});
});

function price_view() {
	$('.product-list').attr('class', 'product-price');
	$('.product-grid').attr('class', 'product-price');
		
	$('.product-price > div').each(function(index, element) {
		html = '';
		
		var image = $(element).find('.image').html();
		var name = $(element).find('.name').html();
		var description = $(element).find('.description').html();
		var attribute = $(element).find('.attribute').html();
		var option = $(element).find('.options').html();
		var model = $(element).find('.model').html();
		var sku = $(element).find('.sku').html();
		var manufacturer = $(element).find('.manufacturer').html();
		var location = $(element).find('.location').html();
		var quantity = $(element).find('.quantity').html();
		var price = $(element).find('.price').html();
		var quantity_cart = $(element).find('.quantity_cart').html();
		var cart = $(element).find('.cart').html();
		var multicart = $(element).find('.multicart').html();
		var rating = $(element).find('.rating').html();
		var wishlist = $(element).find('.wishlist').html();
		var compare = $(element).find('.compare').html();
			
		if (image != null) {
			html += '<div class="image">' + image + '</div>';
		}
		if (name != null) {
			html += '<div class="name">' + name + '</div>';
		}
		if (description != null) {
			html += '<div class="description">' + description + '</div>';
		}
		if (attribute != null) {
			html += '<div class="attribute">' + attribute + '</div>';
		}
		if (option != null) {
			html += '<div class="options">' + option + '</div>';
		}
		if (model != null) {
			html += '<div class="model">' + model + '</div>';
		}
		if (sku != null) {
			html += '<div class="sku">' + sku + '</div>';
		}
		if (manufacturer != null) {
			html += '<div class="manufacturer">' + manufacturer + '</div>';
		}
		if (location != null) {
			html += '<div class="location">' + location + '</div>';
		}
		if (quantity != null) {
			html += '<div class="quantity">' + quantity + '</div>';
		}
		if (price != null) {
			html += '<div class="price">' + price + '</div>';
		}
		if (quantity_cart != null) {
			html += '<div class="quantity_cart">' + quantity_cart + '</div>';
		}
		if (cart != null) {
			html += '<div class="cart">' + cart + '</div>';
		}
		if (multicart != null) {
			html += '<div class="multicart">' + multicart + '</div>';
		}			
		if (rating != null) {
			html += '<div class="rating">' + rating + '</div>';
		}
		if (wishlist != null) {				
			html += '<div class="wishlist">' + wishlist + '</div>';
		}
		if (compare != null) {
			html += '<div class="compare">' + compare + '</div>';
		}
		
		$(element).html(html);
	});	
		
		$.totalStorage('display', 'price');
}

	function quantity(product_id, quantity ,minimum, maximum) {
		if (qnty == '') return;
		var qnty = Number($('input[name=\'' + product_id + '\']').val());
		qnty += Number(quantity);
		if(qnty > minimum) {
			$('input[name=\'' + product_id + '\']').val(qnty);
			recalc(product_id)
		} else {
			$('input[name=\'' + product_id + '\']').val(minimum);
			recalc(product_id)
		}
	}

	function recalc(product_id) {
		var quantity = $('input[name=\'' + product_id + '\']').val();
		var quantity = typeof(quantity) != 'undefined' ? quantity : 1;
		var options_price = 0;
	
		$('#option_'+product_id+' option:selected, #option_'+product_id+' input:checked').each(function() {
			if ($(this).attr('price_prefix') == '+') { options_price = options_price + Number($(this).attr('price')); }
			if ($(this).attr('price_prefix') == '-') { options_price = options_price - Number($(this).attr('price')); }
		});
	
		var price_no_format = Number($('.change-price'+product_id).attr('price'));
		var special_no_format = Number($('.change-special'+product_id).attr('price'));
		var new_price = (price_no_format + options_price) * quantity;
		var new_special = (special_no_format + options_price) * quantity;
		$('.change-price' + product_id).html(price_format(new_price));
		$('.change-special' + product_id).html(price_format(new_special));
	}

	function addToCart(product_id, quantity) {

		var quantity = typeof(quantity) != 'undefined' ? quantity : 1;
		var option = $('#option_'+product_id+' input[type=\'text\'], #option_'+product_id+' input[type=\'radio\']:checked, #option_'+product_id+' input[type=\'checkbox\']:checked, #option_'+product_id+' select, #option_'+product_id+' textarea');
		if ($('#option_'+product_id).length != 0) {
			var data = option.serialize() + '&product_id=' + product_id + '&quantity=' + quantity;
			var productpage = true;
		} else {
			var data = 'product_id=' + product_id + '&quantity=' + quantity;
		}

	$.ajax({
		url: 'index.php?route=checkout/cart/add',
		type: 'post',
		data: data,
		dataType: 'json',
		success: function(json) {
			$('.success, .warning, .attention, .information, .error').remove();
			
			if (json['redirect'] && !productpage) {
				location = json['redirect'];
			}

			if (json['error'] && productpage) {
				if (json['error']['option']) {
					for (i in json['error']['option']) {
						$('#option-' + i).after($('<span class="error">' + json['error']['option'][i] + '</span>').fadeIn().delay('2000').fadeOut());
					}
				}
			} 
			
			if (json['success']) {
				$('#notification').html('<div class="success" style="display: none;">' + json['success'] + '<img src="catalog/view/theme/default/image/close.png" alt="" class="close" /></div>');
				$('.success').fadeIn('slow');
				$('#cart-total').html(json['total']);
				$('html, body').animate({ scrollTop: 0 }, 'slow');
			}	
		}
	});
}
	
	function addtoCart2() {
		$('.product-price > div input:checked').each(function() {
		var p_id = $(this).attr('value');
		var q_id = $(this).parent().parent().find('input[name=\'' + p_id + '\']').val();
		addToCart(p_id, q_id);
		});
	}
	
	function hideblocks() {
		var atr = $('.attribute').contents().length;
		if (atr == 1) { 
			$('.attribute').hide(); 
		}
		
		var man = $('.manufacturer').contents().length;
		if (man == 1) { 
			$('.manufacturer').hide(); 
		}
	}