Sequence.js [![Flattr this git repo](http://api.flattr.com/button/flattr-badge-large.png)](https://flattr.com/submit/auto?user_id=IanLunn&url=https://github.com/IanLunn/Sequence&title=Sequence&language=english&tags=github&category=software) [![Join the chat at https://gitter.im/IanLunn/Sequence](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/IanLunn/Sequence?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)
=====================

> The responsive CSS animation framework for creating unique sliders, presentations, banners, and other step-based applications.

Sequence.js provides all of the JavaScript functionality you need for step-based applications such as sliders and presentations, allowing you to concentrate on producing your content with style.

Easily add transitions using the `.seq-in` and `.seq-out` CSS classes automatically added via Sequence.js to style how your slides/steps and content animate.

Find out how Sequence.js works in the [Introduction theme](http://ianlunn.github.io/Sequence/) or for more details, head to the [documentation](http://sequencejs.com/documentation/).

See the [introduction](http://ianlunn.github.io/Sequence/) and [ready-made themes](http://www.sequencejs.com/themes/).

## Features

- Rapid development of animated step-based applications using CSS
- Fully supports responsive design
- Supported on mobile, tablet, and desktop devices
- No limitations on CSS, HTML, and workflow you can use
- Animate canvas and content
- Hardware acceleration (for smooth animation even on mobile devices)
- Touch support via [Hammer.js](http://eightmedia.github.io/hammer.js/)
- Auto play
- Easy-to-add next/previous/pause buttons and pagination
- Preloader via [ImagesLoaded](http://imagesloaded.desandro.com/)
- Hash tag support
- Keyboard navigation
- 30+ options and API for custom functionality
- Top quality [documentation](http://sequencejs.com/documentation/)
- Supports all major browsers with a fallback mode for legacy browsers ([detailed browser support](http://sequencejs.com/developers/browser-support/))
- [Ready-made themes](http://sequencejs.com/themes/) available
- [Yeoman generator](https://github.com/IanLunn/generator-sequence) available for quick scaffolding of themes

### Browser Support

Sequence.js is supported in modern browsers on major platforms, with a [fallback theme](http://www.sequencejs.com/documentation/#browser-support-and-fallback-mode) for Internet Explorer 8 and 9, and other older browsers that don't support CSS transitions.

[See Browser Support in more detail](http://www.sequencejs.com/developers/browser-support/).

## Getting Started

To get started [download](http://sequencejs.com/download/) Sequence.js and then head to the [documentation](http://www.sequencejs.com/documentation/). If you'd like to contribute to Sequence.js development, please see the [contributing guidelines](https://github.com/IanLunn/Sequence/blob/master/CONTRIBUTING.md).

### Download

- [Download Sequence.js](http://sequencejs.com/download/)

Sequence.js can also be installed using the [Bower](http://bower.io/) command:

```
bower install sequencejs
```

or [NPM](https://www.npmjs.org/):

```
npm install sequencejs
```

## Philosophy

Sequence.js aims to provide a complete animation framework for you to create animated step-based applications almost entirely in CSS without getting in the way of how you or a web browser work. Create content and then animate it using the HTML, CSS, and workflow you're used to. Sequence.js will take care of the JavaScript functionality. There's no special syntax to learn, no limitations on the workflow you are used to, and no heavy JavaScript implementations recreating what the browser is already capable of.

## Authors

[Ian Lunn](http://ianlunn.co.uk/) and [contributors](https://github.com/IanLunn/Sequence/graphs/contributors).

Follow [@IanLunn](https://twitter.com/IanLunn/) on Twitter for Sequence.js news, web design &amp; development links, tips, and opinions

## Sponsors

Browser testing environment provided by <a href="http://browserstack.com/">BrowserStack</a>.

[![Browser Stack](http://www.sequencejs.com/wp-content/themes/sequence/images/browserstack-light.png)](http://browserstack.com/)

## Licenses

License information can be found on the [Sequence.js website](http://www.sequencejs.com/licenses/).

## Hire Ian Lunn

[Ian Lunn](http://ianlunn.co.uk) is a Web Designer, Front-end Developer, and author of [CSS3 Foundations](http://css3foundations.com/).

Hire [Ian Lunn](http://ianlunn.co.uk) for responsive design, WordPress sites, HTML, CSS, and JavaScript.
