/*
 * Sequence.js
 *
 * The responsive CSS animation framework for creating unique sliders,
 * presentations, banners, and other step-based applications.
 *
 * @link https://github.com/IanLunn/Sequence
 * @author IanLunn
 * @version 2.1.0
 * @license http://sequencejs.com/licenses/
 * @copyright Ian Lunn Design Limited 2015
 */
function defineSequence(imagesLoaded,Hammer){"use strict";var instances=[],instance=0,Sequence=function(element,options){function isArray(object){return"[object Array]"===Object.prototype.toString.call(object)?!0:!1}function extend(a,b){for(var i in b)a[i]=b[i];return a}function getStyle(element,property){var value;return element.currentStyle?value=element.currentStyle[property]:document.defaultView&&document.defaultView.getComputedStyle&&(value=document.defaultView.getComputedStyle(element,"")[property]),value}function addEvent(element,eventName,handler){if(element.addEventListener)return element.addEventListener(eventName,handler,!1),handler;if(element.attachEvent){var handlerr=function(){handler.call(element)};return element.attachEvent("on"+eventName,handlerr),handlerr}}function removeEvent(element,eventName,handler){element.addEventListener?element.removeEventListener(eventName,handler,!1):element.detachEvent&&element.detachEvent("on"+eventName,handler)}function convertTimeToMs(time){var convertedTime,fraction;return fraction=time.indexOf("ms")>-1?1:1e3,convertedTime="0s"==time?0:parseFloat(time.replace("s",""))*fraction}function hasClass(element,name){return void 0!==element?new RegExp("(\\s|^)"+name+"(\\s|$)").test(element.className):void 0}function addClass(elements,name){var element,elementsLength,i;for(isArray(elements)===!1&&(elementsLength=1,elements=[elements]),elementsLength=elements.length,i=0;elementsLength>i;i++)element=elements[i],hasClass(element,name)===!1&&(element.className+=(element.className?" ":"")+name)}function removeClass(elements,name){var element,elementsLength,i;for(isArray(elements)===!1?(elementsLength=1,elements=[elements]):elementsLength=elements.length,i=0;elementsLength>i;i++)element=elements[i],hasClass(element,name)===!0&&(element.className=element.className.replace(new RegExp("(\\s|^)"+name+"(\\s|$)")," ").replace(/^\s+|\s+$/g,""))}function insideElement(element,cursor){var rect=element.getBoundingClientRect(),inside=!1;return cursor.clientX>=rect.left&&cursor.clientX<=rect.right&&cursor.clientY>=rect.top&&cursor.clientY<=rect.bottom&&(inside=!0),inside}function hasParent(parent,target,previousTarget){if("BODY"===target.nodeName)return!1;if(parent!==target)return previousTarget=target,hasParent(parent,target.parentNode,previousTarget);if(void 0!==previousTarget)for(var topLevel=previousTarget,allTopLevel=parent.getElementsByTagName(topLevel.nodeName),i=allTopLevel.length;i--;)if(topLevel===allTopLevel[i])return i+1}function getHammerDirection(swipeEvents){var swipeDirections=0,hammerDirection=Hammer.DIRECTION_NONE;return(void 0!==swipeEvents.left||void 0!==swipeEvents.right)&&(swipeDirections+=1),(void 0!==swipeEvents.up||void 0!==swipeEvents.down)&&(swipeDirections+=2),1===swipeDirections?hammerDirection=Hammer.DIRECTION_HORIZONTAL:2===swipeDirections?hammerDirection=Hammer.DIRECTION_VERTICAL:3===swipeDirections&&(hammerDirection=Hammer.DIRECTION_ALL),hammerDirection}function addFeatureSupportClasses($el,Modernizr){var prefix="seq-",support="no-touch";Modernizr.touch===!0&&(support="touch"),addClass($el,prefix+support)}var instanceId=element.getAttribute("data-seq-enabled");if(null!==instanceId)return instances[instanceId];element.setAttribute("data-seq-enabled",instance),instance++;var defaults={startingStepId:1,startingStepAnimatesIn:!1,cycle:!0,phaseThreshold:!0,reverseWhenNavigatingBackwards:!1,reverseTimingFunctionWhenNavigatingBackwards:!1,moveActiveStepToTop:!0,animateCanvas:!0,animateCanvasDuration:250,autoPlay:!1,autoPlayInterval:5e3,autoPlayDelay:null,autoPlayDirection:1,autoPlayButton:!0,autoPlayPauseOnHover:!0,navigationSkip:!0,navigationSkipThreshold:250,fadeStepWhenSkipped:!0,fadeStepTime:500,ignorePhaseThresholdWhenSkipped:!1,preventReverseSkipping:!1,nextButton:!0,prevButton:!0,pagination:!0,preloader:!1,preloadTheseSteps:[1],preloadTheseImages:[],hideStepsUntilPreloaded:!1,pausePreloader:!1,keyNavigation:!1,numericKeysGoToSteps:!1,keyEvents:{left:function(sequence){sequence.prev()},right:function(sequence){sequence.next()}},swipeNavigation:!0,swipeEvents:{left:function(sequence){sequence.next()},right:function(sequence){sequence.prev()},up:void 0,down:void 0},swipeHammerOptions:{},hashTags:!1,hashDataAttribute:!1,hashChangesOnFirstStep:!1,fallback:{speed:500}},domThreshold=50,resizeThreshold=100,prefixTranslations={animation:{WebkitAnimation:"-webkit-",animation:""}},Modernizr=function(a,b,c){function z(a){i.cssText=a}function B(a,b){return typeof a===b}function C(a,b){return!!~(""+a).indexOf(b)}function D(a,b){for(var d in a){var e=a[d];if(!C(e,"-")&&i[e]!==c)return"pfx"==b?e:!0}return!1}function E(a,b,d){for(var e in a){var f=b[a[e]];if(f!==c)return d===!1?a[e]:B(f,"function")?f.bind(d||b):f}return!1}function F(a,b,c){var d=a.charAt(0).toUpperCase()+a.slice(1),e=(a+" "+n.join(d+" ")+d).split(" ");return B(b,"string")||B(b,"undefined")?D(e,b):(e=(a+" "+o.join(d+" ")+d).split(" "),E(e,b,c))}var j,v,y,d="2.8.3",e={},f=b.documentElement,g="modernizr",h=b.createElement(g),i=h.style,l=({}.toString," -webkit- -moz- -o- -ms- ".split(" ")),m="Webkit Moz O ms",n=m.split(" "),o=m.toLowerCase().split(" "),p={svg:"http://www.w3.org/2000/svg"},q={},t=[],u=t.slice,w=function(a,c,d,e){var h,i,j,k,l=b.createElement("div"),m=b.body,n=m||b.createElement("body");if(parseInt(d,10))for(;d--;)j=b.createElement("div"),j.id=e?e[d]:g+(d+1),l.appendChild(j);return h=["&#173;",'<style id="s',g,'">',a,"</style>"].join(""),l.id=g,(m?l:n).innerHTML+=h,n.appendChild(l),m||(n.style.background="",n.style.overflow="hidden",k=f.style.overflow,f.style.overflow="hidden",f.appendChild(n)),i=c(l,a),m?l.parentNode.removeChild(l):(n.parentNode.removeChild(n),f.style.overflow=k),!!i},x={}.hasOwnProperty;y=B(x,"undefined")||B(x.call,"undefined")?function(a,b){return b in a&&B(a.constructor.prototype[b],"undefined")}:function(a,b){return x.call(a,b)},Function.prototype.bind||(Function.prototype.bind=function(b){var c=this;if("function"!=typeof c)throw new TypeError;var d=u.call(arguments,1),e=function(){if(this instanceof e){var a=function(){};a.prototype=c.prototype;var f=new a,g=c.apply(f,d.concat(u.call(arguments)));return Object(g)===g?g:f}return c.apply(b,d.concat(u.call(arguments)))};return e}),q.touch=function(){var c;return"ontouchstart"in a||a.DocumentTouch&&b instanceof DocumentTouch?c=!0:w(["@media (",l.join("touch-enabled),("),g,")","{#modernizr{top:9px;position:absolute}}"].join(""),function(a){c=9===a.offsetTop}),c},q.cssanimations=function(){return F("animationName")},q.csstransforms=function(){return!!F("transform")},q.csstransitions=function(){return F("transition")},q.svg=function(){return!!b.createElementNS&&!!b.createElementNS(p.svg,"svg").createSVGRect};for(var G in q)y(q,G)&&(v=G.toLowerCase(),e[v]=q[G](),t.push((e[v]?"":"no-")+v));return e.addTest=function(a,b){if("object"==typeof a)for(var d in a)y(a,d)&&e.addTest(d,a[d]);else{if(a=a.toLowerCase(),e[a]!==c)return e;b="function"==typeof b?b():b,"undefined"!=typeof enableClasses&&enableClasses&&(f.className+=" "+(b?"":"no-")+a),e[a]=b}return e},z(""),h=j=null,e._version=d,e._prefixes=l,e._domPrefixes=o,e._cssomPrefixes=n,e.testProp=function(a){return D([a])},e.testAllProps=F,e.testStyles=w,e.prefixed=function(a,b,c){return b?F(a,b,c):F(a,"pfx")},e}(window,window.document);Array.prototype.indexOf||(Array.prototype.indexOf=function(searchElement,fromIndex){if(void 0===this||null===this)throw new TypeError('"this" is null or not defined');var length=this.length>>>0;for(fromIndex=+fromIndex||0,Math.abs(fromIndex)===1/0&&(fromIndex=0),0>fromIndex&&(fromIndex+=length,0>fromIndex&&(fromIndex=0));length>fromIndex;fromIndex++)if(this[fromIndex]===searchElement)return fromIndex;return-1});var hidden,visibilityChange;"undefined"!=typeof document.hidden?(hidden="hidden",visibilityChange="visibilitychange"):"undefined"!=typeof document.mozHidden?(hidden="mozHidden",visibilityChange="mozvisibilitychange"):"undefined"!=typeof document.msHidden?(hidden="msHidden",visibilityChange="msvisibilitychange"):"undefined"!=typeof document.webkitHidden&&(hidden="webkitHidden",visibilityChange="webkitvisibilitychange");var self={modernizr:Modernizr};return self.ui={defaultElements:{nextButton:"seq-next",prevButton:"seq-prev",autoPlayButton:"seq-autoplay",pagination:"seq-pagination",preloader:"seq-preloader"},getElements:function(type,option){var element,elements,elementsLength,rel,i,relatedElements=[];for(elements=option===!0?document.querySelectorAll("."+this.defaultElements[type]):document.querySelectorAll(option),elementsLength=elements.length,i=0;elementsLength>i;i++)element=elements[i],rel=element.getAttribute("rel"),(null===rel||rel===self.$container.getAttribute("id"))&&relatedElements.push(element);return relatedElements},show:function(element,duration){self.propertySupport.transitions===!0?(element.style[Modernizr.prefixed("transitionDuration")]=duration+"ms",element.style[Modernizr.prefixed("transitionProperty")]="opacity, "+Modernizr.prefixed("transform"),element.style.opacity=1):self.animationFallback.animate(element,"opacity","",0,1,duration)},hide:function(element,duration,callback){self.propertySupport.transitions===!0?(element.style[Modernizr.prefixed("transitionDuration")]=duration+"ms",element.style[Modernizr.prefixed("transitionProperty")]="opacity, "+Modernizr.prefixed("transform"),element.style.opacity=0):self.animationFallback.animate(element,"opacity","",1,0,duration),void 0!==callback&&(self.hideTimer=setTimeout(function(){callback()},duration))}},self.autoPlay={init:function(){self.isAutoPlayPaused=!1,self.isAutoPlaying=!1},getDelay:function(delay,startDelay,autoPlayInterval){switch(delay){case!0:delay=null===startDelay?autoPlayInterval:startDelay;break;case!1:case void 0:delay=0}return delay},start:function(delay,continuing){if(self.isAutoPlaying===!0||self.isReady===!1)return!1;var options=self.options;return delay=this.getDelay(delay,options.autoPlayDelay,options.autoPlayInterval),void 0===continuing&&self.started(self),addClass(self.$container,"seq-autoplaying"),addClass(self.$autoPlay,"seq-autoplaying"),options.autoPlay=!0,self.isAutoPlaying=!0,self.isAnimating===!1&&(self.autoPlayTimer=setTimeout(function(){1===options.autoPlayDirection?self.next():self.prev()},delay)),!0},stop:function(){return self.options.autoPlay!==!0||self.isAutoPlaying!==!0?!1:(self.options.autoPlay=!1,self.isAutoPlaying=!1,clearTimeout(self.autoPlayTimer),removeClass(self.$container,"seq-autoplaying"),removeClass(self.$autoPlay,"seq-autoplaying"),self.stopped(self),!0)},unpause:function(){return self.isAutoPlayPaused!==!0?!1:(self.isAutoPlayPaused=!1,this.start(!0),!0)},pause:function(){return self.options.autoPlay!==!0?!1:(self.isAutoPlayPaused=!0,this.stop(),!0)}},self.canvas={init:function(id){void 0!==self.$screen&&(self.$screen.style.height="100%",self.$screen.style.width="100%"),self.canvas.getTransformProperties()},getSteps:function(canvas){var stepId,step,i,steps=[],stepElements=canvas.children,stepsLength=stepElements.length;for(self.stepProperties={},i=0;stepsLength>i;i++)step=stepElements[i],stepId=i+1,steps.push(step),self.stepProperties[stepId]={},self.stepProperties[stepId].isActive=!1;return steps},getTransformProperties:function(){var i,step,stepId,canvasTransform;for(i=0;i<self.noOfSteps;i++)step=self.$steps[i],stepId=i+1,canvasTransform={seqX:0,seqY:0,seqZ:0},canvasTransform.seqX+=-1*step.offsetLeft,canvasTransform.seqY+=-1*step.offsetTop,self.stepProperties[stepId].canvasTransform=canvasTransform},move:function(id,animate){if(self.options.animateCanvas===!0){var transforms,duration=0;return animate===!0&&self.firstRun===!1&&(duration=self.options.animateCanvasDuration),self.isFallbackMode===!1&&(transforms=self.stepProperties[id].canvasTransform,self.$canvas.style[Modernizr.prefixed("transitionDuration")]=duration+"ms",self.$canvas.style[Modernizr.prefixed("transform")]="translateX("+transforms.seqX+"px) translateY("+transforms.seqY+"px) translateZ("+transforms.seqZ+"px) "),!0}return!1},removeNoJsClass:function(){if(self.isFallbackMode!==!0)for(var i=0;i<self.$steps.length;i++){var element=self.$steps[i];if(hasClass(element,"seq-in")===!0){var step=i+1;self.animation.resetInheritedSpeed(step),removeClass(element,"seq-in")}}}},self.animation={getPhaseProperties:function(stepId){var el,i,duration,delay,stepElement=self.$steps[stepId-1],stepAnimatedChildren=stepElement.querySelectorAll("*[data-seq]"),stepChildren=stepElement.querySelectorAll("*"),stepChildrenLength=stepChildren.length,watchedDurations=[],watchedDelays=[],watchedLengths=[],durations=[],delays=[],lengths=[];for(i=0;stepChildrenLength>i;i++)el=stepChildren[i],duration=convertTimeToMs(getStyle(el,Modernizr.prefixed("transitionDuration"))),delay=convertTimeToMs(getStyle(el,Modernizr.prefixed("transitionDelay"))),durations.push(duration),delays.push(delay),lengths.push(duration+delay),null!==el.getAttribute("data-seq")&&(watchedDurations.push(duration),watchedDelays.push(delay),watchedLengths.push(duration+delay));var maxDuration=Math.max.apply(Math,durations),maxDelay=Math.max.apply(Math,delays),maxTotal=Math.max.apply(Math,lengths),watchedMaxDuration=Math.max.apply(Math,watchedDurations),watchedMaxDelay=Math.max.apply(Math,watchedDelays),watchedMaxTotal=Math.max.apply(Math,watchedLengths);return{stepId:stepId,stepElement:stepElement,children:stepChildren,animatedChildren:stepAnimatedChildren,watchedTimings:{maxDuration:watchedMaxDuration,maxDelay:watchedMaxDelay,maxTotal:watchedMaxTotal},timings:{maxDuration:maxDuration,maxDelay:maxDelay,maxTotal:maxTotal}}},getPhaseThreshold:function(ignorePhaseThreshold,phaseThresholdOption,isAnimating,currentPhaseDuration){var phaseThresholdTime=0;return isAnimating===!0&&self.options.ignorePhaseThresholdWhenSkipped===!0&&(ignorePhaseThreshold=!0),void 0===ignorePhaseThreshold&&(phaseThresholdOption===!0?phaseThresholdTime=currentPhaseDuration:phaseThresholdOption!==!1&&(phaseThresholdTime=phaseThresholdOption)),phaseThresholdTime},getReversePhaseDelay:function(currentPhaseTotal,nextPhaseTotal,phaseThresholdOption,ignorePhaseThresholdWhenSkippedOption,isAnimating){var phaseDifference=0,current=0,next=0;return phaseThresholdOption===!0||ignorePhaseThresholdWhenSkippedOption!==!1&&isAnimating!==!1||(phaseDifference=currentPhaseTotal-nextPhaseTotal,phaseDifference>0?next=phaseDifference:0>phaseDifference&&(current=Math.abs(phaseDifference))),{next:next,current:current}},moveActiveStepToTop:function(currentElement,nextElement){if(self.options.moveActiveStepToTop===!0){var prevStepElement=self.$steps[self.prevStepId-1],lastStepId=self.noOfSteps-1;prevStepElement.style.zIndex=1,currentElement.style.zIndex=lastStepId,nextElement.style.zIndex=self.noOfSteps}return null},manageNavigationSkip:function(id,nextStepElement){if(self.isFallbackMode!==!0){var i,stepProperties,stepElement,stepId,phaseSkipped;if(self.ui.show(nextStepElement,0),self.options.navigationSkip===!0){if(self.navigationSkipThresholdActive=!0,0!==self.phasesAnimating&&(clearTimeout(self.phaseThresholdTimer),clearTimeout(self.nextPhaseStartedTimer),self.options.fadeStepWhenSkipped===!0))for(i=1;i<=self.noOfSteps;i++)stepProperties=self.stepProperties[i],stepProperties.isActive===!0&&i!==id&&(stepElement=self.$steps[i-1],stepId=i,phaseSkipped={},phaseSkipped.id=stepId,phaseSkipped.element=stepElement,self.phasesSkipped.push(phaseSkipped),self.animation.stepSkipped(stepElement));self.navigationSkipThresholdTimer=setTimeout(function(){self.navigationSkipThresholdActive=!1},self.options.navigationSkipThreshold)}}},stepSkipped:function(stepElement){self.ui.hide(stepElement,self.options.fadeStepTime,function(){})},changeStep:function(id){var stepToAdd="seq-step"+id;if(void 0!==self.currentStepId){var stepToRemove="seq-step"+self.currentStepId;addClass(self.$container,stepToAdd),removeClass(self.$container,stepToRemove)}else addClass(self.$container,stepToAdd)},reverseProperties:function(phaseProperties,phaseDelay,phaseThresholdTime,ignorePhaseThreshold,options){var el,i,duration,delay,total,maxTotal,maxWatchedTotal,animation=this,phaseElements=phaseProperties.children,noOfPhaseElements=phaseElements.length,stepDurations=phaseProperties.timings,timingFunction="",timingFunctionReversed="",totals=[],watchedTotals=[];for(i=0;noOfPhaseElements>i;i++)el=phaseElements[i],duration=convertTimeToMs(getStyle(el,Modernizr.prefixed("transitionDuration"))),delay=convertTimeToMs(getStyle(el,Modernizr.prefixed("transitionDelay"))),total=duration+delay,delay=stepDurations.maxTotal-total,ignorePhaseThreshold!==!0&&(delay+=phaseDelay),total=duration+delay,totals.push(total),null!==el.getAttribute("data-seq")&&watchedTotals.push(total),options.reverseTimingFunctionWhenNavigatingBackwards===!0&&(timingFunction=getStyle(el,Modernizr.prefixed("transitionTimingFunction")),timingFunctionReversed=animation.reverseTimingFunction(timingFunction)),el.style[Modernizr.prefixed("transition")]=duration+"ms "+delay+"ms "+timingFunctionReversed;return maxTotal=Math.max.apply(Math,totals),maxWatchedTotal=Math.max.apply(Math,watchedTotals),setTimeout(function(){animation.domDelay(function(){for(i=0;noOfPhaseElements>i;i++)el=phaseElements[i],el.style[Modernizr.prefixed("transition")]=""})},maxTotal+phaseThresholdTime),maxWatchedTotal},forward:function(id,currentStepElement,nextStepElement,ignorePhaseThreshold,hashTagNav){var currentPhaseProperties,currentPhaseTotal,phaseThresholdTime,animation=this;self.firstRun===!1&&animation.currentPhaseStarted(self.currentStepId),removeClass(nextStepElement,"seq-out"),animation.domDelay(function(){currentPhaseProperties=animation.startAnimateOut(self.currentStepId,currentStepElement,1),currentPhaseTotal=currentPhaseProperties.watchedTimings.maxTotal,phaseThresholdTime=animation.getPhaseThreshold(ignorePhaseThreshold,self.options.phaseThreshold,self.isAnimating,currentPhaseTotal),self.isAnimating=!0,animation.startAnimateIn(id,currentPhaseTotal,nextStepElement,phaseThresholdTime,hashTagNav)})},reverse:function(id,currentStepElement,nextStepElement,ignorePhaseThreshold,hashTagNav){var reversePhaseDelay,currentPhaseProperties,nextPhaseProperties,currentPhaseTotal,nextPhaseTotal,animation=this,phaseThresholdTime=0;addClass(nextStepElement,"seq-out"),animation.domDelay(function(){currentPhaseProperties=animation.getPhaseProperties(self.currentStepId,"current"),nextPhaseProperties=animation.getPhaseProperties(id,"next"),phaseThresholdTime=animation.getPhaseThreshold(ignorePhaseThreshold,self.options.phaseThreshold,self.isAnimating,currentPhaseProperties.timings.maxTotal),reversePhaseDelay=animation.getReversePhaseDelay(currentPhaseProperties.timings.maxTotal,nextPhaseProperties.timings.maxTotal,self.options.phaseThreshold,self.options.ignorePhaseThresholdWhenSkipped,self.isAnimating),currentPhaseTotal=animation.reverseProperties(currentPhaseProperties,reversePhaseDelay.current,0,ignorePhaseThreshold,self.options),nextPhaseTotal=animation.reverseProperties(nextPhaseProperties,reversePhaseDelay.next,phaseThresholdTime,ignorePhaseThreshold,self.options),animation.startAnimateOut(self.currentStepId,currentStepElement,-1,currentPhaseTotal),self.isAnimating=!0,self.firstRun===!1&&animation.currentPhaseStarted(self.currentStepId),animation.startAnimateIn(id,currentPhaseTotal,nextStepElement,phaseThresholdTime,hashTagNav,nextPhaseTotal)})},startAnimateIn:function(id,currentPhaseTotal,nextStepElement,phaseThresholdTime,hashTagNav,nextPhaseTotal){var nextPhaseProperties,stepDuration,animation=this;self.prevStepId=self.currentStepId,self.currentStepId=id,self.firstRun===!0&&self.pagination.update(),self.firstRun===!1||self.options.startingStepAnimatesIn===!0?(self.stepProperties[id].isActive=!0,self.nextPhaseStartedTimer=setTimeout(function(){animation.nextPhaseStarted(id,hashTagNav)},phaseThresholdTime),self.phaseThresholdTimer=setTimeout(function(){addClass(nextStepElement,"seq-in"),removeClass(nextStepElement,"seq-out"),void 0===nextPhaseTotal&&(nextPhaseProperties=self.animation.getPhaseProperties(id,"next"),nextPhaseTotal=nextPhaseProperties.watchedTimings.maxTotal),animation.phaseEnded(id,"next",nextPhaseTotal,animation.nextPhaseEnded),stepDuration=animation.getStepDuration(currentPhaseTotal,nextPhaseTotal,self.options.phaseThreshold),self.stepEndedTimer=setTimeout(function(){self.animation.stepEnded(id)},stepDuration)},phaseThresholdTime)):(animation.resetInheritedSpeed(id),self.phasesAnimating=0,self.isAnimating=!1,self.options.autoPlay===!0&&self.autoPlay.start(!0),addClass(nextStepElement,"seq-in"),removeClass(nextStepElement,"seq-out")),self.firstRun=!1},startAnimateOut:function(id,currentStepElement,direction,currentPhaseTotal){var currentPhaseProperties,animation=this;return 1===direction?(removeClass(currentStepElement,"seq-in"),addClass(currentStepElement,"seq-out"),currentPhaseProperties=animation.getPhaseProperties(id,"current"),currentPhaseTotal=currentPhaseProperties.watchedTimings.maxTotal):removeClass(currentStepElement,"seq-in"),self.firstRun===!1&&(self.stepProperties[id].isActive=!0,animation.phaseEnded(id,"current",currentPhaseTotal,animation.currentPhaseEnded)),currentPhaseProperties},getStepDuration:function(currentPhaseTotal,nextPhaseTotal,phaseThresholdOption){var stepDuration;switch(phaseThresholdOption){case!0:stepDuration=nextPhaseTotal;break;case!1:stepDuration=currentPhaseTotal>=nextPhaseTotal?currentPhaseTotal:nextPhaseTotal;break;default:stepDuration=currentPhaseTotal>=nextPhaseTotal+phaseThresholdOption?currentPhaseTotal-phaseThresholdOption:nextPhaseTotal}return stepDuration},currentPhaseStarted:function(id){self.phasesAnimating++,self.currentPhaseStarted(id,self)},currentPhaseEnded:function(id){self.currentPhaseEnded(id,self)},nextPhaseStarted:function(id,hashTagNav){self.phasesAnimating++,void 0===hashTagNav&&self.hashTags.update(),self.pagination.update(),self.nextPhaseStarted(id,self)},nextPhaseEnded:function(id){self.nextPhaseEnded(id,self)},phaseEnded:function(id,phase,phaseDuration,callback){var phaseEnded;phaseEnded=function(id){self.stepProperties[id].isActive=!1,self.phasesAnimating--,callback(id)},"current"===phase?self.currentPhaseEndedTimer=setTimeout(function(){phaseEnded(id)},phaseDuration):self.nextPhaseEndedTimer=setTimeout(function(){phaseEnded(id)},phaseDuration)},stepEnded:function(id){self.isAnimating=!1,self.isAutoPlaying=!1,self.options.autoPlay===!0&&self.autoPlay.start(!0,!0),self.animationEnded(id,self)},reversePhase:function(phase){var reversePhase={"seq-out":"seq-in","seq-in":"seq-out"};return reversePhase[phase]},domDelay:function(callback){setTimeout(function(){callback()},domThreshold)},reverseTimingFunction:function(timingFunction){if(""===timingFunction||void 0===timingFunction)return timingFunction;var cubicBezier,cubicBezierLength,reversedCubicBezier,i,timingFunctionToCubicBezier={linear:"cubic-bezier(0.0,0.0,1.0,1.0)",ease:"cubic-bezier(0.25, 0.1, 0.25, 1.0)","ease-in":"cubic-bezier(0.42, 0.0, 1.0, 1.0)","ease-in-out":"cubic-bezier(0.42, 0.0, 0.58, 1.0)","ease-out":"cubic-bezier(0.0, 0.0, 0.58, 1.0)"};for(timingFunction.indexOf("cubic-bezier")<0&&(timingFunction=timingFunction.split(",")[0],timingFunction=timingFunctionToCubicBezier[timingFunction]),cubicBezier=timingFunction.replace("cubic-bezier(","").replace(")","").split(","),cubicBezierLength=cubicBezier.length,i=0;cubicBezierLength>i;i++)cubicBezier[i]=parseFloat(cubicBezier[i]);return reversedCubicBezier=[1-cubicBezier[2],1-cubicBezier[3],1-cubicBezier[0],1-cubicBezier[1]],timingFunction="cubic-bezier("+reversedCubicBezier+")"},resetInheritedSpeed:function(step){if(self.isFallbackMode!==!0){var el,i,stepElements=self.$steps[step-1].querySelectorAll("*"),numberOfStepElements=stepElements.length;for(i=0;numberOfStepElements>i;i++)el=stepElements[i],el.style[Modernizr.prefixed("transition")]="0ms 0ms";self.animation.domDelay(function(){for(i=0;numberOfStepElements>i;i++)el=stepElements[i],el.style[Modernizr.prefixed("transition")]=""})}},getDirection:function(id,definedDirection,currentStepId,noOfSteps,isFallbackMode,reverseWhenNavigatingBackwardsOption,cycleOption){var direction=1;return direction=void 0!==definedDirection?definedDirection:reverseWhenNavigatingBackwardsOption===!0||isFallbackMode===!0?cycleOption===!0&&1===id&&currentStepId===noOfSteps?1:currentStepId>id?-1:1:1},requiresFallbackMode:function(propertySupport){var transitions=propertySupport.transitions,isFallbackMode=!1;return transitions===!1&&(isFallbackMode=!0),isFallbackMode},getPropertySupport:function(properties){var transitions=!1,animations=!1;return Modernizr.csstransitions===!0&&(transitions=!0),Modernizr.cssanimations===!0&&(animations=!0),{transitions:transitions,animations:animations}}},self.animationFallback={animate:function(element,style,unit,from,to,time,callback){if(element!==!1){var start=(new Date).getTime(),timer=setInterval(function(){var step=Math.min(1,((new Date).getTime()-start)/time);element.style[style]=from+step*(to-from)+unit,1===step&&(void 0!==callback&&callback(),clearInterval(timer))},25);element.style[style]=from+unit}},setupCanvas:function(id){var i,step,stepId;if(self.isFallbackMode===!0)for(addClass(self.$container,"seq-fallback"),void 0!==self.$screen&&(self.$screen.style.overflow="hidden",self.$screen.style.width="100%",self.$screen.style.height="100%"),self.$canvas.style.width="100%",self.$canvas.style.height="100%",this.canvasWidth=self.$canvas.offsetWidth,i=0;i<self.noOfSteps;i++)step=self.$steps[i],stepId=i+1,addClass(step,"seq-in"),step.style.width="100%",step.style.height="100%",step.style.position="absolute",step.style.whiteSpace="normal",step.style.left="100%"},moveCanvas:function(nextStepElement,currentStepElement,direction,animate){if(animate===!0){var currentFrom=0,currentTo=-100,nextFrom=100,nextTo=0;-1===direction&&(currentTo=100,nextFrom=-100),this.animate(currentStepElement,"left","%",currentFrom,currentTo,self.options.fallback.speed),this.animate(nextStepElement,"left","%",nextFrom,nextTo,self.options.fallback.speed)}else currentStepElement.style.left="-100%",nextStepElement.style.left="0"},goTo:function(id,currentStep,currentStepElement,nextStep,nextStepElement,direction,hashTagNav){self.prevStepId=self.currentStepId,self.currentStepId=id,void 0===hashTagNav&&self.hashTags.update(),self.pagination.update(),self.firstRun===!1?(this.moveCanvas(nextStepElement,currentStepElement,direction,!0),self.isAnimating=!0,self.animationStarted(self.currentStepId,self),self.stepEndedTimer=setTimeout(function(){self.animation.stepEnded(self.currentStepId)},self.options.fallback.speed)):(this.moveCanvas(nextStepElement,currentStepElement,direction,!1),self.firstRun=!1,self.options.autoPlay===!0&&self.autoPlay.start(!0))}},self.pagination={getLinks:function(element,rel){var childElement,i,childElements=element.childNodes,childElementsLength=childElements.length,paginationLinks=[];for(i=0;childElementsLength>i;i++)childElement=childElements[i],1===childElement.nodeType&&paginationLinks.push(childElement);return paginationLinks},update:function(){if(void 0!==self.$pagination.elements){var i,j,currentPaginationLink,currentPaginationLinksLength,id=self.currentStepId-1,paginationLength=self.$pagination.elements.length;if(void 0!==self.$pagination.currentLinks)for(currentPaginationLinksLength=self.$pagination.currentLinks.length,i=0;currentPaginationLinksLength>i;i++)currentPaginationLink=self.$pagination.currentLinks[i],removeClass(currentPaginationLink,"seq-current");for(self.$pagination.currentLinks=[],j=0;paginationLength>j;j++)currentPaginationLink=self.$pagination.links[j][id],self.$pagination.currentLinks.push(currentPaginationLink),addClass(currentPaginationLink,"seq-current")}return self.$pagination.currentLinks}},self.hashTags={init:function(id){if(self.options.hashTags===!0){var correspondingStepId,newHashTag;self.hasPushstate=!(!window.history||!history.pushState),newHashTag=location.hash.replace("#!",""),self.stepHashTags=this.getStepHashTags(),""!==newHashTag&&(self.currentHashTag=newHashTag,correspondingStepId=this.hasCorrespondingStep(self.currentHashTag),correspondingStepId>-1&&(id=correspondingStepId+1))}return id},hasCorrespondingStep:function(hashTag){var correspondingStep=-1,correspondingStepId=self.stepHashTags.indexOf(hashTag);return correspondingStepId>-1&&(correspondingStep=correspondingStepId),correspondingStep},getStepHashTags:function(){var i,elementHashTag,stepHashTags=[];for(i=0;i<self.noOfSteps;i++)elementHashTag=self.options.hashDataAttribute===!1?self.$steps[i].id:self.$steps[i].getAttribute("data-seq-hashtag"),stepHashTags.push(elementHashTag);return stepHashTags},update:function(){if(self.options.hashTags===!0&&self.firstRun===!1||self.options.hashTags===!0&&self.firstRun===!0&&self.options.hashChangesOnFirstStep===!0){var hashTagId=self.currentStepId-1;self.currentHashTag=self.stepHashTags[hashTagId],""!==self.currentHashtag&&(self.hasPushstate===!0?history.pushState(null,null,"#!"+self.currentHashTag):location.hash="#!"+self.currentHashTag)}},setupEvent:function(){if("onhashchange"in window){if(window.addEventListener)return window.addHashChange=function(func,before){window.addEventListener("hashchange",func,before)},void(window.removeHashChange=function(func){window.removeEventListener("hashchange",func)});if(window.attachEvent)return window.addHashChange=function(func){window.attachEvent("onhashchange",func)},void(window.removeHashChange=function(func){window.detachEvent("onhashchange",func)})}var hashChangeFuncs=[],oldHref=location.href;window.addHashChange=function(func,before){"function"==typeof func&&hashChangeFuncs[before?"unshift":"push"](func)},window.removeHashChange=function(func){for(var i=hashChangeFuncs.length-1;i>=0;i--)hashChangeFuncs[i]===func&&hashChangeFuncs.splice(i,1)},setInterval(function(){var newHref=location.href;if(oldHref!==newHref){var _oldHref=oldHref;oldHref=newHref;for(var i=0;i<hashChangeFuncs.length;i++)hashChangeFuncs[i].call(window,{type:"hashchange",newURL:newHref,oldURL:_oldHref})}},100)}},self.preload={defaultHtml:'<svg width="39" height="16" viewBox="0 0 39 16" xmlns="http://www.w3.org/2000/svg" class="seq-preload-indicator"><title>Sequence.js Preloading Indicator</title><desc>Three orange dots increasing in size from left to right</desc><g fill="#F96D38"><path class="seq-preload-circle seq-preload-circle-1" d="M3.999 12.012c2.209 0 3.999-1.791 3.999-3.999s-1.79-3.999-3.999-3.999-3.999 1.791-3.999 3.999 1.79 3.999 3.999 3.999z"/><path class="seq-preload-circle seq-preload-circle-2" d="M15.996 13.468c3.018 0 5.465-2.447 5.465-5.466 0-3.018-2.447-5.465-5.465-5.465-3.019 0-5.466 2.447-5.466 5.465 0 3.019 2.447 5.466 5.466 5.466z"/><path class="seq-preload-circle seq-preload-circle-3" d="M31.322 15.334c4.049 0 7.332-3.282 7.332-7.332 0-4.049-3.282-7.332-7.332-7.332s-7.332 3.283-7.332 7.332c0 4.05 3.283 7.332 7.332 7.332z"/></g></svg>',fallbackHtml:'<div class="seq-preload-indicator seq-preload-indicator-fallback"><div class="seq-preload-circle seq-preload-circle-1"></div><div class="seq-preload-circle seq-preload-circle-2"></div><div class="seq-preload-circle seq-preload-circle-3"></div></div>',defaultStyles:"@"+prefixTranslations.animation[Modernizr.prefixed("animation")]+"keyframes seq-preloader {50% {opacity: 1;}100% {opacity: 0;}}.seq-preloader {background: white;visibility: visible;opacity: 1;position: absolute;z-index: 9999;height: 100%;width: 100%;top: 0;left: 0;right: 0;bottom: 0;} .seq-preloader.seq-preloaded {opacity: 0;visibility: hidden;"+Modernizr.prefixed("transition")+": visibility 0s .5s, opacity .5s;}.seq-preload-indicator {overflow: visible;position: relative;top: 50%;left: 50%;-webkit-transform: translate(-50%, -50%);transform: translate(-50%, -50%);}.seq-preload-circle {display: inline-block;height: 12px;width: 12px;fill: #F96D38;opacity: 0;"+prefixTranslations.animation[Modernizr.prefixed("animation")]+"animation: seq-preloader 1.25s infinite;}.seq-preload-circle-2 {"+prefixTranslations.animation[Modernizr.prefixed("animation")]+"animation-delay: .15s;}.seq-preload-circle-3 {"+prefixTranslations.animation[Modernizr.prefixed("animation")]+"animation-delay: .3s;}.seq-preload-indicator-fallback{width: 42px;margin-left: -21px;overflow: visible;}.seq-preload-indicator-fallback .seq-preload-circle {width: 8px; height:8px;background-color: #F96D38;border-radius: 100%; opacity: 1;display: inline-block; vertical-align: middle;}.seq-preload-indicator-fallback .seq-preload-circle-2{margin-left: 3px; margin-right: 3px; width: 12px; height: 12px;}.seq-preload-indicator-fallback .seq-preload-circle-3{width: 16px; height: 16px;}",
init:function(callback){if(self.options.preloader!==!1){var stepImagesToPreload,individualImagesToPreload,imagesToPreload,imgLoad,progress,result,preload=this;return addClass(self.$container,"seq-preloading"),self.$preloader=self.ui.getElements("preloader",self.options.preloader),preload.append(),preload.addStyles(),preload.toggleStepsVisibility("hide"),stepImagesToPreload=preload.getImagesToPreload(self.options.preloadTheseSteps),individualImagesToPreload=preload.getImagesToPreload(self.options.preloadTheseImages,!0),imagesToPreload=stepImagesToPreload.concat(individualImagesToPreload),imgLoad=imagesLoaded(imagesToPreload),imgLoad.on("always",function(instance){preload.complete(callback)}),progress=1,imgLoad.on("progress",function(instance,image){result=image.isLoaded?"loaded":"broken",self.preloadProgress(result,image.img.src,progress++,imagesToPreload.length,self)}),!0}return!1},complete:function(callback){self.preloaded(self),self.options.pausePreloader!==!0&&(this.toggleStepsVisibility("show"),removeClass(self.$container,"seq-preloading"),addClass(self.$container,"seq-preloaded"),addClass(self.$preloader[0],"seq-preloaded"),void 0!==this.preloadIndicatorTimer&&clearInterval(this.preloadIndicatorTimer),(Modernizr.prefixed("animation")===!1||Modernizr.svg===!1)&&(self.$preloader[0].style.display="none"),void 0!==callback&&callback())},addStyles:function(){if(self.options.preloader===!0){var head=document.head||document.getElementsByTagName("head")[0];if(this.styleElement=document.createElement("style"),this.styleElement.type="text/css",this.styleElement.styleSheet?this.styleElement.styleSheet.cssText=this.defaultStyles:this.styleElement.appendChild(document.createTextNode(this.defaultStyles)),head.appendChild(this.styleElement),Modernizr.prefixed("animation")===!1||Modernizr.svg===!1){var preloadIndicator=self.$preloader[0].firstChild,indicatorFlash=function(){preloadIndicator.style.visibility="hidden",preloadFlashTime=1e3,setTimeout(function(){preloadIndicator.style.visibility="visible"},500)};indicatorFlash(),this.preloadIndicatorTimer=setInterval(function(){indicatorFlash()},1e3)}return!0}return!1},removeStyles:function(){this.styleElement.parentNode.removeChild(this.styleElement)},getImagesToPreload:function(elements,srcOnly){var imagesToPreload=[];if(isArray(elements)===!0){var i,j,step,imagesInStep,imagesInStepLength,image,img,src,elementLength=elements.length;if(srcOnly!==!0)for(i=0;elementLength>i;i++)for(step=self.$steps[i],imagesInStep=step.getElementsByTagName("img"),imagesInStepLength=imagesInStep.length,j=0;imagesInStepLength>j;j++)image=imagesInStep[j],imagesToPreload.push(image);else for(img=[],i=0;elementLength>i;i++)src=elements[i],img[i]=new Image,img[i].src=src,imagesToPreload.push(img[i])}return imagesToPreload},append:function(){return self.options.preloader===!0?(self.$preloader=document.createElement("div"),self.$preloader.className="seq-preloader",self.$preloader=[self.$preloader],Modernizr.prefixed("animation")!==!1&&Modernizr.svg===!0?self.$preloader[0].innerHTML=self.preload.defaultHtml:self.$preloader[0].innerHTML=self.preload.fallbackHtml,self.$container.insertBefore(self.$preloader[0],null),!0):!1},toggleStepsVisibility:function(type){if(self.options.hideStepsUntilPreloaded===!0){var i,step;for(i=0;i<self.noOfSteps;i++)step=self.$steps[i],"hide"===type?self.ui.hide(step,0):self.ui.show(step,0);return!0}return!1}},self.manageEvents={list:{load:[],click:[],touchstart:[],mousemove:[],mouseleave:[],hammer:[],keyup:[],hashchange:[],resize:[]},init:function(){return self.manageEvents.list[visibilityChange]=[],self.options.hashTags===!0&&this.add.hashChange(),self.options.swipeNavigation===!0?this.add.swipeNavigation():self.hammerTime=!1,self.options.keyNavigation===!0&&this.add.keyNavigation(),this.add.resizeThrottle(),this.add.pageVisibility(),self.options.nextButton!==!1&&(self.$next=self.ui.getElements("nextButton",self.options.nextButton),this.add.button(self.$next,"nav",self.next)),self.options.prevButton!==!1&&(self.$prev=self.ui.getElements("prevButton",self.options.prevButton),this.add.button(self.$prev,"nav",self.prev)),self.options.autoPlayButton!==!1&&(self.$autoPlay=self.ui.getElements("autoPlayButton",self.options.autoPlayButton),this.add.button(self.$autoPlay,"nav",self.toggleAutoPlay)),this.add.stopOnHover(),self.options.pagination!==!1&&(self.$pagination={},self.$pagination.relatedElementId=instance,self.$pagination.links=[],self.$pagination.elements=self.ui.getElements("pagination",self.options.pagination),this.add.button(self.$pagination.elements,"pagination")),null},removeAll:function(eventList){var eventType,theEvents;for(eventType in eventList)eventList.hasOwnProperty(eventType)===!0&&(theEvents=eventList[eventType],this.remove(eventType));return null},remove:function(type){var eventElements=self.manageEvents.list[type],eventElementsLength=eventElements.length;switch(type){case"hashchange":self.options.hashTags===!0&&removeHashChange(eventElements[0].handler);break;case"hammer":if(self.manageEvents.list.hammer.length>0&&void 0!==document.querySelectorAll){var handler=self.manageEvents.list.hammer[0].handler;self.hammerTime.off("swipe",[handler])}break;default:for(var i=0;eventElementsLength>i;i++){var eventProperties=eventElements[i];removeEvent(eventProperties.element,type,eventProperties.handler)}}},add:{hashChange:function(){self.hashTags.setupEvent();var handler=function(e){var newHashTag,id;newHashTag=e.newURL||location.href,newHashTag=newHashTag.split("#!")[1],self.currentHashTag!==newHashTag&&(id=self.stepHashTags.indexOf(newHashTag)+1,self.currentHashTag=newHashTag,self.goTo(id,void 0,void 0,!0))};return addHashChange(handler),self.manageEvents.list.hashchange.push({element:window,handler:handler}),self.manageEvents.list.hashchange},button:function(elements,type,callback){var handler,element,buttonEvent,parent,rel,id,i,elementsLength=elements.length;switch(type){case"nav":buttonEvent=function(element){handler=addEvent(element,"click",function(event){event||(event=window.event),event.preventDefault?event.preventDefault():event.returnValue=!1,callback()})};break;case"pagination":buttonEvent=function(element,rel){handler=addEvent(element,"click",function(event,element){event||(event=window.event),event.preventDefault?event.preventDefault():event.returnValue=!1;var targetElement=event.target||event.srcElement;parent=this,id=hasParent(parent,targetElement),self.goTo(id)}),self.$pagination.links.push(self.pagination.getLinks(element,rel))}}for(i=0;elementsLength>i;i++)element=elements[i],rel=element.getAttribute("rel"),rel===self.$container.id&&null===element.getAttribute("data-seq-button")?(element.setAttribute("data-seq-button",!0),buttonEvent(element,rel)):null===rel&&null===element.getAttribute("data-seq-button")&&buttonEvent(element,rel),self.manageEvents.list.click.push({element:element,handler:handler});return self.manageEvents.list.click},stopOnHover:function(){var touchHandler,handler;return self.isMouseOver=!1,touchHandler=addEvent(self.$container,"touchstart",function(e){self.isTouched=!0}),self.manageEvents.list.touchstart.push({element:self.$container,handler:touchHandler}),handler=addEvent(self.$container,"mousemove",function(e){return e=e||window.event,self.isTouched===!0?void(self.isTouched=!1):void(insideElement(self.$container,e)===!0?(self.options.autoPlayPauseOnHover===!0&&self.isMouseOver===!1&&self.autoPlay.pause(),self.isMouseOver=!0):(self.options.autoPlayPauseOnHover===!0&&self.isMouseOver===!0&&self.autoPlay.unpause(),self.isMouseOver=!1))}),self.manageEvents.list.mousemove.push({element:self.$container,handler:handler}),handler=addEvent(self.$container,"mouseleave",function(e){self.options.autoPlayPauseOnHover===!0&&self.autoPlay.unpause(),self.isMouseOver=!1}),self.manageEvents.list.mouseleave.push({element:self.$container,handler:handler}),null},swipeNavigation:function(){if(void 0===window.addEventListener)return void(self.hammerTime=!1);var hammerDirection,handler;"function"==typeof Hammer&&(handler=function(e){switch(e.direction){case 2:self.options.swipeEvents.left(self);break;case 4:self.options.swipeEvents.right(self);break;case 8:self.options.swipeEvents.up(self);break;case 16:self.options.swipeEvents.down(self)}},self.hammerTime=new Hammer(self.$container).on("swipe",handler),self.hammerTime.get("swipe").set(self.options.swipeHammerOptions),hammerDirection=getHammerDirection(self.options.swipeEvents),self.hammerTime.get("swipe").set({direction:hammerDirection}),self.manageEvents.list.hammer.push({element:self.$container,handler:handler}))},keyNavigation:function(){var handler=addEvent(document,"keyup",function(event){event||(event=window.event);var keyCodeChar=parseInt(String.fromCharCode(event.keyCode));switch(keyCodeChar>0&&keyCodeChar<=self.noOfSteps&&self.options.numericKeysGoToSteps&&self.goTo(keyCodeChar),event.keyCode){case 37:self.options.keyEvents.left(self);break;case 39:self.options.keyEvents.right(self)}});self.manageEvents.list.keyup.push({element:document,handler:handler})},resizeThrottle:function(){function throttledEvents(){setTimeout(function(){self.canvas.getTransformProperties(),self.propertySupport.transitions===!0&&self.canvas.move(self.currentStepId,!1)},500),self.throttledResize(self)}var throttleTimer,handler;handler=addEvent(window,"resize",function(e){clearTimeout(throttleTimer),throttleTimer=setTimeout(throttledEvents,resizeThreshold)}),self.manageEvents.list.resize.push({element:window,handler:handler})},pageVisibility:function(){var handler=addEvent(document,visibilityChange,function(){document[hidden]?self.autoPlay.pause():self.autoPlay.unpause()},!1);self.manageEvents.list[visibilityChange].push({element:document,handler:handler})}}},self.init=function(element){var id,prevStep,prevStepId,goToFirstStep;self.options=extend(defaults,options),self.isAnimating=!1,self.isReady=!1,self.$container=element,self.$screen=self.$container.querySelectorAll(".seq-screen")[0],self.$canvas=self.$container.querySelectorAll(".seq-canvas")[0],self.$steps=self.canvas.getSteps(self.$canvas),self.noOfSteps=self.$steps.length,self.phasesAnimating=0,self.phasesSkipped=[],addFeatureSupportClasses(self.$container,Modernizr),id=self.options.startingStepId,addClass(self.$container,"seq-active"),self.propertySupport=self.animation.getPropertySupport(),self.isFallbackMode=self.animation.requiresFallbackMode(self.propertySupport),self.canvas.init(id),self.canvas.removeNoJsClass(self),self.manageEvents.init(),self.autoPlay.init(),self.firstRun=!0,id=self.hashTags.init(id),1===self.options.autoPlayDirection?(prevStepId=id-1,self.prevStepId=1>prevStepId?self.noOfSteps:prevStepId):(prevStepId=id+1,self.prevStepId=prevStepId>self.noOfSteps?1:prevStepId),self.currentStepId=self.prevStepId,prevStep=self.prevStepId,self.animationFallback.setupCanvas(id),goToFirstStep=function(){self.animation.domDelay(function(){self.animation.domDelay(function(){self.animation.resetInheritedSpeed(prevStep)}),self.isReady=!0,self.ready(self),self.goTo(id,self.options.autoPlayDirection,!0)})},self.options.preloader!==!1&&void 0!==document.querySelectorAll&&"function"==typeof imagesLoaded?self.preload.init(function(){goToFirstStep()}):goToFirstStep()},self.destroy=function(){var i,step,lastStep;for(self.autoPlay.stop(),clearTimeout(self.autoPlayTimer),clearTimeout(self.phaseThresholdTimer),clearTimeout(self.stepEndedTimer),clearTimeout(self.currentPhaseEndedTimer),clearTimeout(self.nextPhaseStartedTimer),clearTimeout(self.nextPhaseEndedTimer),clearTimeout(self.fadeStepTimer),clearTimeout(self.hideTimer),clearTimeout(self.navigationSkipThresholdTimer),self.manageEvents.removeAll(self.manageEvents.list),removeClass(self.$pagination.currentLinks,"seq-current"),removeClass(self.$container,"seq-step"+self.currentStepId),removeClass(self.$container,"seq-active"),self.$container.removeAttribute("style"),void 0!==self.$screen&&self.$screen.removeAttribute("style"),self.$canvas.removeAttribute("style"),i=0;i<self.noOfSteps;i++)step=self.$steps[i],step.removeAttribute("style"),self.animation.resetInheritedSpeed(i+1),removeClass(step,"seq-in"),removeClass(step,"seq-out");return lastStep=self.$steps[self.options.startingStepId-1],self.animation.resetInheritedSpeed(self.options.startingStepId),addClass(lastStep,"seq-in"),element.removeAttribute("data-seq-enabled"),self.destroyed(self),self=null},self.next=function(){var nextStepId=self.currentStepId+1;return nextStepId>self.noOfSteps&&self.options.cycle===!1?!1:(nextStepId>self.noOfSteps&&(nextStepId=1),self.goTo(nextStepId),nextStepId)},self.prev=function(){var direction,prevStepId=self.currentStepId-1;return 1>prevStepId&&self.options.cycle===!1?!1:(1>prevStepId&&(prevStepId=self.noOfSteps),self.options.reverseWhenNavigatingBackwards===!0&&(direction=-1),self.goTo(prevStepId,direction),prevStepId)},self.toggleAutoPlay=function(delay){return self.isAutoPlaying===!1?self.start(delay):self.stop(),self.isAutoPlaying},self.stop=function(){self.autoPlay.stop()},self.start=function(delay){self.autoPlay.start(delay)},self.goTo=function(id,direction,ignorePhaseThreshold,hashTagNav){if(direction=self.animation.getDirection(id,direction,self.currentStepId,self.noOfSteps,self.isFallbackMode,self.options.reverseWhenNavigatingBackwards,self.options.cycle),void 0===id||1>id||id>self.noOfSteps||id===self.currentStepId||self.options.navigationSkip===!1&&self.isAnimating===!0||self.options.navigationSkip===!0&&self.navigationSkipThresholdActive===!0&&void 0===hashTagNav||self.isFallbackMode===!0&&self.isAnimating===!0&&void 0===hashTagNav||self.options.preventReverseSkipping===!0&&self.direction!==direction&&self.isAnimating===!0)return!1;var currentStepElement,nextStepElement;return clearTimeout(self.autoPlayTimer),self.direction=direction,1===direction?removeClass(self.$container,"seq-reversed"):addClass(self.$container,"seq-reversed"),currentStepElement=self.$steps[self.currentStepId-1],nextStepElement=self.$steps[id-1],self.animation.moveActiveStepToTop(currentStepElement,nextStepElement),self.animation.changeStep(id),self.isFallbackMode===!1?(self.animation.resetInheritedSpeed(id),(self.firstRun===!1||self.firstRun===!0&&self.options.startingStepAnimatesIn===!0)&&self.animationStarted(id,self),self.canvas.move(id,!0),self.animation.manageNavigationSkip(id,nextStepElement),1===direction?self.animation.forward(id,currentStepElement,nextStepElement,ignorePhaseThreshold,hashTagNav):self.animation.reverse(id,currentStepElement,nextStepElement,ignorePhaseThreshold,hashTagNav)):self.animationFallback.goTo(id,self.currentStepId,currentStepElement,id,nextStepElement,direction,hashTagNav),!0},self.started=function(self){},self.stopped=function(self){},self.animationStarted=function(id,self){},self.animationEnded=function(id,self){},self.currentPhaseStarted=function(id,self){},self.currentPhaseEnded=function(id,self){},self.nextPhaseStarted=function(id,self){},self.nextPhaseEnded=function(id,self){},self.throttledResize=function(self){},self.preloaded=function(self){},self.preloadProgress=function(result,src,progress,length,self){},self.ready=function(self){},self.destroyed=function(self){},self.utils={addClass:addClass,removeClass:removeClass,addEvent:addEvent,removeEvent:removeEvent},self.init(element),instances.push(self),self};return Sequence}if("function"==typeof define&&define.amd)define(["imagesLoaded","Hammer"],defineSequence);else{Hammer="function"!=typeof Hammer?null:Hammer,imagesLoaded="function"!=typeof imagesLoaded?null:imagesLoaded;var sequence=defineSequence(imagesLoaded,Hammer)}
//# sourceMappingURL=sequence.min.map