<?php

require_once(realpath(__DIR__ . '/../init.php'));

use Senh\Overrides\Html2Text;

// overridable variables
$domain = isset($domain) ? $domain : 'afslankreceptenbijbel.nl';
$contactFormUrl = isset($contactFormUrl) ? $contactFormUrl : $domain . '/contactformulier/';
$organisationEmail = isset($organisationEmail) ? $organisationEmail : null;
$organisationPerson = isset($organisationPerson) ? $organisationPerson : 'Oscar Helm';
$organisation = isset($organisation) ? $organisation : 'Helpdesk ' . $organisationPerson;
$googleReCaptchaSecret = isset($googleReCaptchaSecret) ? $googleReCaptchaSecret : GOOGLE_RECAPTCHA_SECRET;

// template variables
$organisationBcc = 'info@senhuitgeverij.nl';
$reCaptchaError = "Er ging iets met met de reCaptcha, probeer het nog een keer.";
$ok = 'OK';
$not = "Het is niet gelukt je bericht te verzenden. Probeer het later nog een keer.";
$unknownError = "Sorry, er ging iets mis en dat lag niet aan jou. Probeer het later nog eens.";
$inputError = "Je hebt niet alle velden ingevuld. Controleer de velden.";
$emailError = "Je e-mailadres blijkt niet te kloppen. Controleer je e-mailadres.";
$emailError = "Je e-mailadres blijkt niet te kloppen. Controleer je e-mailadres.";
$whiteListCode = 'ot3meg8q';
$unknownSaleEmailError = 'De combinatie van het e-mailadres en referentienummer is niet bij ons bekend. Controleer deze velden.';
$saleAlreadyClosed = 'Het lidmaatschap is al afgemeld.';
$saleNotFoundError = 'De combinatie van het referentienummer en aankoop datum is niet bij ons bekend. Controleer deze velden.';
$sorrySaleNotFoundError = 'Helaas, de huidige combinatie van referentienummer en datum aankoop kunnen wij niet terugvinden. Controleer de gegevens en probeer het opnieuw.';

// post variables
$category = RequestHelper::getPostVariable('category');
$email = RequestHelper::getPostVariable('email');
$subject = RequestHelper::getPostVariable('subject');
$message = RequestHelper::getPostVariable('message');
$name = RequestHelper::getPostVariable('name');
$cmd = RequestHelper::getPostVariable('cmd');
$saleId = RequestHelper::getPostVariable('saleId');
$sale = null;
if ($saleId) {
    $saleId = str_replace('i', '', $saleId);
    $saleId = str_replace('I', '', $saleId);
    $saleId = str_replace('-', '', $saleId);
    $sale = senh_get_sale($saleId);
}

$reCaptchaResponse = RequestHelper::getPostVariable('recaptcha_response');

$email = strtolower(trim($email));

if ($cmd === 'downloaden') {
	$saleDate = RequestHelper::getPostVariable('saleDate');
	$saleDateValid = $sale && $saleDate === $sale->getDate()->format('d/m/Y');
	if (!$sale || !$saleDateValid) {
        die($sorrySaleNotFoundError);
    }
    
    $download_urls = array(
	    '21142' => 'https://afslankreceptenbijbel.nl/bedankt/Dow-ARB-ou7eee6R4InKotlnsj1lGss117ECZpkABHmE9qjO/',
	    '38520' => 'https://afslankreceptenbijbel.nl/bedankt/Dow-ARB-ou7eee6R4InKotlnsj1lGss117ECZpkABHmE9qjO/',
	    '20138' => 'https://strakkebuikbijbel.nl/bedankt/Dow-BB-aZr2D0Nvx4odjnplDxVFi5YAIO6gxmwSK3vWIuq8/',
	    '37542' => 'https://strakkebuikbijbel.nl/bedankt/Dow-BB-aZr2D0Nvx4odjnplDxVFi5YAIO6gxmwSK3vWIuq8/',
	    '46948' => 'https://smoothieafslankbijbel.nl/bedankt/Dow-SAB-OlQFA7amaZQh1LCom7ph/',
	    '46945' => 'https://smoothieafslankbijbel.nl/bedankt/Dow-SAB-OlQFA7amaZQh1LCom7ph/'
    );
    
    if (!isset($download_urls[$sale->getProductId()])) {
	    die($sorrySaleNotFoundError);
    }
    
    die('OK' . $download_urls[$sale->getProductId()]);
    
    return;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    die($emailError);
}
if ($cmd === 'contact') {
    if (strlen($name) < 3 || !$subject || !$category || !$message) {
        die($inputError);
    }
} elseif ($cmd === 'afmelden') {
    if (!$saleId) {
        die($inputError);
    }
    if (!$sale || strtolower(trim($sale->getEmail())) !== $email) {
        die($unknownSaleEmailError);
    }
//
//    $sequence = senh_get_sequence($sale, $sale->getCurrentNumberOfPeriods());
//    if (!$sequence) {
//        die($unknownError);
//    }
//
//    if ($sequence->getCurrentStatus() )

    $subject = 'Afmelden lidmaatschap: i-' . $saleId;
}

if ($cmd !== 'contact' && $cmd !== 'afmelden') {
    die($inputError);
}

//
//$recaptcha = new \ReCaptcha\ReCaptcha($googleReCaptchaSecret);
//$reCaptchaResult = $recaptcha->verify($reCaptchaResponse);
//if (!$reCaptchaResult->isSuccess()) {
//    die($reCaptchaError);
//}

$email = trim($email);

if ($cmd === 'contact') {
    $bodyOrganisationHtml = '
Van: '.$name.' <'.$email.'><br>
Categorie: '.$category.'<br>
Onderwerp: '.$subject.'<br>
<br>
'.nl2br($message).'<br>
<br>
---<br>
Dit bericht is verzonden vanaf '.$contactFormUrl.'<br>
Whitelist code for gmail filters: '.$whiteListCode.'<br>
<br>
	';
} elseif ($cmd === 'afmelden') {
    $bodyOrganisationHtml = '
Email: '.$email.'<br>
Referentienumer: '.$saleId.'<br>
Onderwerp: '.$subject.'<br>
---<br>
Dit bericht is verzonden vanaf '.$contactFormUrl.'<br>
Whitelist code for gmail filters: '.$whiteListCode.'<br>
<br>
	';
}

if ($cmd === 'contact') {
    $bodyClientHtml = '
Beste '.$name.',<br>
<br>
We hebben je vraag in goede orde ontvangen en de klantenservice zal zo spoedig mogelijk je vraag gaan beantwoorden. <br>
<br>
De klantenservice beantwoordt e-mails  <b>binnen 5 werkdagen</b>.<br>
<br>
Groet,<br>
'.$organisationPerson.'<br>
<br>
<a href="https://'.$domain.'">https://'.$domain.'</a><br>
<br>
<br>
---<br>
Dit was jouw vraag:<br>
<br>
Van: '.$name.' <'.$email.'><br>
Categorie: '.$category.'<br>
Onderwerp: '.$subject.'<br>
<br>
'.nl2br($message).'<br>
<br>
';
} elseif ($cmd === 'afmelden') {
    $bodyClientHtml = '
Beste meneer / mevrouw,<br>
<br>
We hebben je afmelding ontvangen en de klantenservice zal deze zo spoedig mogelijk in behandelijk nemen. <br>
<br>
De klantenservice beantwoordt e-mails  <b>binnen 5 werkdagen</b>.<br>
<br>
Groet,<br>
'.$organisationPerson.'<br>
<br>
<a href="https://'.$domain.'">https://'.$domain.'</a><br>
<br>
<br>
---<br>
Jouw gegevens:<br>
<br>
Email: '.$email.'<br>
Referentienummer: '.$saleId.'<br>
';
}

$bodyOrganisationText = Html2Text::convert($bodyOrganisationHtml, true);
$bodyClientText = Html2Text::convert($bodyClientHtml, true);
$subjectOrganisation = $category.": ".$subject;
if ($cmd === 'afmelden') {
    $subjectOrganisation = $subject;
}
$subjectClient = $subjectOrganisation;

$mailer = MailerFactory::getInstance()->getMailer();
$messageOrganisation = new Swift_Message();
$messageOrganisation
    ->setSubject($subjectOrganisation)
    ->setBody($bodyOrganisationHtml, 'text/html', 'utf-8')
    ->setTo($organisationEmail, $organisation)
    ->setFrom($email, $name)
    ->setReplyTo($email, $name)
    ->setReturnPath($organisationEmail)
    ->addPart($bodyOrganisationText)
;
if (
    $category === 'betalen' ||
    strpos($category, 'Ik heb mijn boek nog niet ontvangen') !== false
) {
    $messageOrganisation->addBcc($organisationBcc);
}

$messageClient = new Swift_Message();
$messageClient
    ->setSubject($subjectClient)
    ->setBody($bodyClientHtml, 'text/html', 'utf-8')
    ->setTo($email, $name)
    ->setReplyTo($organisationEmail, $organisation)
    ->setReturnPath($organisationEmail)
    ->setFrom($organisationEmail, $organisation)
    ->addPart($bodyClientText)
;

$sentOrganisation = $mailer->send($messageOrganisation);
$sentClient = $mailer->send($messageClient);
if ($sentOrganisation && $sentClient) {
    die($ok);
}

die($not);