<?php

namespace Senh\Lib\Helpers;

class FileHelper
{
    public static function getFilenameSameLevelFolder($filename, $folderName)
    {
        return dirname(dirname($filename))."/$folderName/".basename($filename);
    }

    /**
     * @param string $filename
     * @param string $folderName
     * @return string|false: string of new location, or false on error
     */
    public static function moveToSameLevelFolder($filename, $folderName)
    {
        $folderPath = dirname(dirname($filename))."/$folderName/";
        if (!is_dir($folderPath)) {
            mkdir($folderPath);
        }
        $newName = "$folderPath/".basename($filename);
        $success = rename($filename, $newName);

        return $success ? realpath($newName) : false;
    }

    /**
     * @param string $filename
     * @param string $folderName
     * @return string
     */
    public static function copyToSameLevelFolder($filename, $folderName)
    {
        $copyName = $filename.'_copy';
        copy($filename, $copyName);
        $copyMovedName = self::moveToSameLevelFolder($copyName, $folderName);
        $finalName = substr($copyMovedName, 0, strlen($copyMovedName) - 5);
        rename($copyMovedName, $finalName);

        return realpath($finalName);
    }

    /**
     * @param string $dirPath
     * @return bool: success
     */
    public static function deleteDirRecursively($dirPath)
    {
        if (!is_dir($dirPath)) {
            return false;
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath.'*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                self::deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);

        return true;
    }


}