<?php

namespace Senh\Lib\Models;

class InternalProductModel
{

    /**
     * @var string: payPro productId
     */
    protected $productId;

    /**
     * ac list id
     * @var int|string
     */
    protected $listId;

    /**
     * The properties for the first period
     * @var InternalProductPropertiesModel
     */
    protected $properties1;

    /**
     * Properties for period > 1 (program)
     * @var InternalProductPropertiesModel
     */
    protected $propertiesN;

    /**
     * @var string
     */
    protected $productCountryCode;

    /**
     * InternalProductModel constructor.
     * @param string $productId
     * @param InternalProductPropertiesModel $properties1
     * @param InternalProductPropertiesModel|null $propertiesN
     */
    public function __construct($productId, $listId, $properties1, $propertiesN = null, $productCountryCode = 'nl')
    {
        $this->productId = $productId;
        $this->listId = $listId;
        $this->properties1 = $properties1;
        $this->propertiesN = $propertiesN;
        $this->productCountryCode = strtolower($productCountryCode);
    }

    /**
     * @return string
     */
    public function getProductId()
    {
        return $this->productId;
    }

    /**
     * @param string $productId
     */
    public function setProductId($productId)
    {
        $this->productId = $productId;
    }

    /**
     * @return int|string
     */
    public function getListId()
    {
        return $this->listId;
    }

    /**
     * @param int|string $listId
     */
    public function setListId($listId)
    {
        $this->listId = $listId;
    }

    /**
     * @return InternalProductPropertiesModel
     */
    public function getProperties1()
    {
        return $this->properties1;
    }

    /**
     * @param InternalProductPropertiesModel $properties1
     */
    public function setProperties1($properties1)
    {
        $this->properties1 = $properties1;
    }

    /**
     * @return InternalProductPropertiesModel
     */
    public function getPropertiesN()
    {
        return $this->propertiesN;
    }

    /**
     * @param InternalProductPropertiesModel $propertiesN
     */
    public function setPropertiesN($propertiesN)
    {
        $this->propertiesN = $propertiesN;
    }

    /**
     * @return bool
     */
    public function hasPropertiesN()
    {
        return $this->propertiesN !== null;
    }

    /**
     * @return int|null
     */
    public function getProductCategory1()
    {
        return $this->getProperties1()->getProductCategory();
    }

    /**
     * @return int|null
     */
    public function getProductType1()
    {
        return $this->getProperties1()->getProductType();
    }

    /**
     * @param null $variant
     * @return int|null
     */
    public function getPrice1($variant = null)
    {
        return $this->getProperties1()->getPrice($variant);
    }

    /**
     * @param null $variant
     * @return int|null
     */
    public function getCommission1($variant = null)
    {
        return $this->getProperties1()->getCommission($variant);
    }

    /**
     * @return array|null
     */
    public function getListTags1()
    {
        return $this->getProperties1()->getListTags();
    }

    /**
     * @return int|string
     */
    public function getListId1()
    {
        return $this->getProperties1()->getListId();
    }

    /**
     * @return int|null
     */
    public function getProductCategoryN()
    {
        return !$this->hasPropertiesN() ? null : $this->getPropertiesN()->getProductCategory();
    }

    /**
     * @return int|null
     */
    public function getProductTypeN()
    {
        return !$this->hasPropertiesN() ? null : $this->getPropertiesN()->getProductType();
    }

    /**
     * @param null $variant
     * @return int|null
     */
    public function getPriceN($variant = null)
    {
        return !$this->hasPropertiesN() ? null : $this->getPropertiesN()->getPrice($variant);
    }

    /**
     * @param null $variant
     * @return int|null
     */
    public function getCommissionN($variant = null)
    {
        return !$this->hasPropertiesN() ? null : $this->getPropertiesN()->getCommission($variant);
    }

    /**
     * @return array|null
     */
    public function getListTagsN()
    {
        return !$this->hasPropertiesN() ? null :  $this->getPropertiesN()->getListTags();
    }

    /**
     * @return int|string
     */
    public function getListIdN()
    {
        return !$this->hasPropertiesN() ? null :  $this->getPropertiesN()->getListId();
    }

    /**
     * @return string
     */
    public function getProductCountryCode()
    {
        return $this->productCountryCode;
    }

    /**
     * @param string $productCountryCode
     */
    public function setProductCountryCode($productCountryCode)
    {
        $this->productCountryCode = strtolower($productCountryCode);
    }
}
