<?php

class ModelHelper
{
    /**
     * @param $id
     * @return int
     */
    public static function fixPayproId($id)
    {
        if ($id === null) {
            return null;
        }

        if (strpos($id, 'I-') === 0) {
            return (int) substr($id, 2);
        }

        return (int) $id;
    }

    /**
     * @param string $payproDate
     * @return DateTime
     */
    public static function fromPayproDate($payproDate)
    {
        if ($payproDate instanceof DateTime) {
            return $payproDate;
        }

        $date = new DateTime();
        if ($payproDate) {
            $date = DateHelper::fromPayproFormat($payproDate);
        }

        return $date;
    }
}