<?php

namespace Senh\Lib\Prices;

class CountDownHelper
{

    /**
     * @var PricesHelper;
     */
    protected $pricesHelper;

    /**
     * CountDownHelper constructor.
     * @param PricesHelper $pricesHelper
     */
    public function __construct(PricesHelper $pricesHelper)
    {
        $this->pricesHelper = $pricesHelper;
    }

    /**
     * @param int|string $productId
     * @param int $priceFactor
     * @param null $priceOverride
     */
    public function getPrice1Html($productId, $priceFactor = 1)
    {
        $originalPrice = $this->pricesHelper->getCurrentVariantPrice1($productId, false) * $priceFactor;
        $reducedPrice = $this->pricesHelper->getCurrentVariantPrice1($productId, true) * $priceFactor;

        $originalFormattedPrice = $this->pricesHelper->formatPrice($originalPrice);
        $reducedFormattedPrice = $this->pricesHelper->formatPrice($reducedPrice);

        return $this->getPriceHtmlRaw($originalFormattedPrice, $reducedFormattedPrice);
    }

    /**
     * @param int|string $productId
     * @param int $priceFactor
     * @param null $priceOverride
     */
    public function getPriceNHtml($productId, $priceFactor = 1)
    {
        $originalPrice = $this->pricesHelper->getCurrentVariantPriceN($productId, false) * $priceFactor;
        $reducedPrice = $this->pricesHelper->getCurrentVariantPriceN($productId, true) * $priceFactor;

        $originalFormattedPrice = $this->pricesHelper->formatPrice($originalPrice);
        $reducedFormattedPrice = $this->pricesHelper->formatPrice($reducedPrice);

        return $this->getPriceHtmlRaw($originalFormattedPrice, $reducedFormattedPrice);
    }

    /**
     * @param $price : cents
     * @param string $period : '1' or 'N'
     */
    protected function getPriceHtmlRaw($originalPriceFormatted, $reducedPriceFormatted)
    {
        return "<span class=\"korting-countdown-price\" data-original-price='$originalPriceFormatted'>$reducedPriceFormatted</span>";
    }
}