<?php

namespace Senh\Lib\Helpers;

use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Senh\Lib\Helpers\FileHelper
 */
class FileHelperTest extends TestCase
{

    public function testGetFilenameSameLevelFolder()
    {
        $input = '/foo/bar/123.txt';
        $expected = '/foo/baz/123.txt';
        $actual = FileHelper::getFilenameSameLevelFolder($input, 'baz');
        $this->assertSame($expected, $actual);
    }

    /**
     * @covers ::moveToSameLevelFolder()
     */
    public function testMoveToSameLevelFolder()
    {
        $filename = __DIR__.'/file-helper-test-files/a/1.txt';
        $target = __DIR__.'/file-helper-test-files/b/1.txt';
        $actual = FileHelper::moveToSameLevelFolder($filename, 'b');
        $this->assertSame($target, $actual);
        $this->assertTrue(file_exists($target));
        $this->assertFalse(file_exists($filename));

        $filename = $target;
        $target = __DIR__.'/file-helper-test-files/a/1.txt';
        $actual = FileHelper::moveToSameLevelFolder($filename, 'a');
        $this->assertSame($target, $actual);
        $this->assertTrue(file_exists($target));
        $this->assertFalse(file_exists($filename));

        // creates dir if not exists
        $filename = __DIR__.'/file-helper-test-files/a/1.txt';
        $target = __DIR__.'/file-helper-test-files/c/1.txt';
        $dir = __DIR__.'/file-helper-test-files/c/';
        $this->assertFalse(is_dir($dir));
        $actual = FileHelper::moveToSameLevelFolder($filename, 'c');
        $this->assertTrue(is_dir($dir));
        $this->assertTrue(file_exists($target));
        FileHelper::moveToSameLevelFolder($target, 'a');
        $this->assertTrue(file_exists($filename));
        rmdir($dir);
        $this->assertFalse(is_dir($dir));
    }

    /**
     * @covers ::copyToSameLevelFolder()
     */
    public function testCopyToSameLevelFolder()
    {
        $filename = __DIR__.'/file-helper-test-files/a/1.txt';
        $target = __DIR__.'/file-helper-test-files/b/1.txt';
        $actual = FileHelper::copyToSameLevelFolder($filename, 'b');
        $this->assertSame($target, $actual);
        $this->assertTrue(file_exists($target));
        $this->assertTrue(file_exists($filename));

        unlink($target);
        $this->assertFalse(file_exists($target));
    }


}
