$( document ).ready(function() {
  
  
  
  function debounce(func, wait, immediate) {
	var timeout;
	return function() {
		var context = this, args = arguments;
		var later = function() {
			timeout = null;
			if (!immediate) func.apply(context, args);
		};
		var callNow = immediate && !timeout;
		clearTimeout(timeout);
		timeout = setTimeout(later, wait);
		if (callNow) func.apply(context, args);
	};
	};


	
	$(window).on('scroll', debounce(function() {
	         if ($(window).scrollTop() > 700) {
			 		$('.buy-banner.nocount').css({'display':'inherit', 'visibility':'visible'});
			    }
			    else {
			        $('.buy-banner.nocount').css({'display':'none', 'visibility':'hidden'})
			    }
	
	}, 25)); 

	if($(window).height() < 500){
		$('.buy-banner.countdown a').css({'display':'none'});

		$('.buy-banner.countdown').css({
			'height' : '100px',
			'padding' : '0px'
		});
	}

	$('.order-button').click(function(){
	  $('.overlay, .betaal-popup').css({'display':'inherit'});
	  $('body, html, .wrapper').css({'overflow-y':'hidden', 'height':'100%'}); 
   });
   
   $('.preview-button.desktop').click(function(){
	  $('.overlay, .preview-popup').css({'display':'inherit'}); 
	   $('body, html, .wrapper').css({'overflow-y':'hidden', 'height':'100%'}); 

	
   });

   
    $('.overlay, .cross').click(function(){
	  $('.overlay, .betaal-popup').css({'display':'none'});
	  $('.overlay, .preview-popup').css({'display':'none'}); 
	   $('body, html, .wrapper').css({'overflow-y':'scroll', 'height':'auto'});
   });
   
   $('.preview-popup .button-primary').click(function(){
	  $('.preview-popup').css({'display':'none'});
	  $('.overlay').css({'display':'none'});
   });

   /* Vrouw */ 
   $('.popwomen').click(function(){
   	location.href='http://www.fitness-tips.nl/tw/fitfoodkit/checkout.php?product=vrouw';
   });
   
   /* Man */
   $('.popmen').click(function(){
   	location.href='http://www.fitness-tips.nl/tw/fitfoodkit/checkout.php?product=man';
   });
   
   
    if ($(window).width() < 1020) {
         $('.mobile').css({'display':'inherit'}); 
        $('.desktop').css({'display':'none'}); 
    }else{
	   $('.preview-popup iframe').attr('src', 'https://www.fitness-tips.nl/tw/fitfoodkit/fit-food-kit-voorbeeld.pdf#zoom=100');
    }
    
    if ($(window).width() < 600) {
       
    }

    function updatePrices(rate){
    	if(rate == 'high'){
    		var rate = "default";
    	}
    	else{
    		var rate = "low";
    	}
    }

});